/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RunTimeAssessmentStatus {
    DATA_COLLECTION_TASK_TO_BE_SCHEDULED("dataCollectionTaskToBeScheduled"),
    DATA_COLLECTION_TASK_SCHEDULED("dataCollectionTaskScheduled"),
    DATA_COLLECTION_TASK_STARTED("dataCollectionTaskStarted"),
    DATA_COLLECTION_TASK_STOPPED("dataCollectionTaskStopped"),
    DATA_COLLECTION_TASK_SUCCESS("dataCollectionTaskSuccess"),
    DATA_COLLECTION_TASK_FAILED("dataCollectionTaskFailed"),
    DATA_COLLECTION_TASK_PARTIAL_SUCCESS("dataCollectionTaskPartialSuccess"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RunTimeAssessmentStatus> VALUE_MAP;
    private final String value;

    private RunTimeAssessmentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RunTimeAssessmentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RunTimeAssessmentStatus> knownValues() {
        EnumSet<RunTimeAssessmentStatus> knownValues = EnumSet.allOf(RunTimeAssessmentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RunTimeAssessmentStatus.class, RunTimeAssessmentStatus::toString);
    }
}

