/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.AnalysisStatusUnion;
import software.amazon.awssdk.services.migrationhubstrategy.model.AnalysisType;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportResult;
import software.amazon.awssdk.services.migrationhubstrategy.model.AntipatternReportResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Result
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Result> {
    private static final SdkField<AnalysisStatusUnion> ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("analysisStatus").getter(Result.getter(Result::analysisStatus)).setter(Result.setter(Builder::analysisStatus)).constructor(AnalysisStatusUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisStatus").build()}).build();
    private static final SdkField<String> ANALYSIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analysisType").getter(Result.getter(Result::analysisTypeAsString)).setter(Result.setter(Builder::analysisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analysisType").build()}).build();
    private static final SdkField<List<AntipatternReportResult>> ANTIPATTERN_REPORT_RESULT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("antipatternReportResultList").getter(Result.getter(Result::antipatternReportResultList)).setter(Result.setter(Builder::antipatternReportResultList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antipatternReportResultList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AntipatternReportResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(Result.getter(Result::statusMessage)).setter(Result.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_STATUS_FIELD, ANALYSIS_TYPE_FIELD, ANTIPATTERN_REPORT_RESULT_LIST_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Result.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AnalysisStatusUnion analysisStatus;
    private final String analysisType;
    private final List<AntipatternReportResult> antipatternReportResultList;
    private final String statusMessage;

    private Result(BuilderImpl builder) {
        this.analysisStatus = builder.analysisStatus;
        this.analysisType = builder.analysisType;
        this.antipatternReportResultList = builder.antipatternReportResultList;
        this.statusMessage = builder.statusMessage;
    }

    public final AnalysisStatusUnion analysisStatus() {
        return this.analysisStatus;
    }

    public final AnalysisType analysisType() {
        return AnalysisType.fromValue(this.analysisType);
    }

    public final String analysisTypeAsString() {
        return this.analysisType;
    }

    public final boolean hasAntipatternReportResultList() {
        return this.antipatternReportResultList != null && !(this.antipatternReportResultList instanceof SdkAutoConstructList);
    }

    public final List<AntipatternReportResult> antipatternReportResultList() {
        return this.antipatternReportResultList;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAntipatternReportResultList() ? this.antipatternReportResultList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Result)) {
            return false;
        }
        Result other = (Result)obj;
        return Objects.equals(this.analysisStatus(), other.analysisStatus()) && Objects.equals(this.analysisTypeAsString(), other.analysisTypeAsString()) && this.hasAntipatternReportResultList() == other.hasAntipatternReportResultList() && Objects.equals(this.antipatternReportResultList(), other.antipatternReportResultList()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"Result").add("AnalysisStatus", (Object)this.analysisStatus()).add("AnalysisType", (Object)this.analysisTypeAsString()).add("AntipatternReportResultList", this.hasAntipatternReportResultList() ? this.antipatternReportResultList() : null).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analysisStatus": {
                return Optional.ofNullable(clazz.cast(this.analysisStatus()));
            }
            case "analysisType": {
                return Optional.ofNullable(clazz.cast(this.analysisTypeAsString()));
            }
            case "antipatternReportResultList": {
                return Optional.ofNullable(clazz.cast(this.antipatternReportResultList()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("analysisStatus", ANALYSIS_STATUS_FIELD);
        map.put("analysisType", ANALYSIS_TYPE_FIELD);
        map.put("antipatternReportResultList", ANTIPATTERN_REPORT_RESULT_LIST_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Result, T> g) {
        return obj -> g.apply((Result)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AnalysisStatusUnion analysisStatus;
        private String analysisType;
        private List<AntipatternReportResult> antipatternReportResultList = DefaultSdkAutoConstructList.getInstance();
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(Result model) {
            this.analysisStatus(model.analysisStatus);
            this.analysisType(model.analysisType);
            this.antipatternReportResultList(model.antipatternReportResultList);
            this.statusMessage(model.statusMessage);
        }

        public final AnalysisStatusUnion.Builder getAnalysisStatus() {
            return this.analysisStatus != null ? this.analysisStatus.toBuilder() : null;
        }

        public final void setAnalysisStatus(AnalysisStatusUnion.BuilderImpl analysisStatus) {
            this.analysisStatus = analysisStatus != null ? analysisStatus.build() : null;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatusUnion analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        public final String getAnalysisType() {
            return this.analysisType;
        }

        public final void setAnalysisType(String analysisType) {
            this.analysisType = analysisType;
        }

        @Override
        public final Builder analysisType(String analysisType) {
            this.analysisType = analysisType;
            return this;
        }

        @Override
        public final Builder analysisType(AnalysisType analysisType) {
            this.analysisType(analysisType == null ? null : analysisType.toString());
            return this;
        }

        public final List<AntipatternReportResult.Builder> getAntipatternReportResultList() {
            List<AntipatternReportResult.Builder> result = AntipatternReportResultListCopier.copyToBuilder(this.antipatternReportResultList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAntipatternReportResultList(Collection<AntipatternReportResult.BuilderImpl> antipatternReportResultList) {
            this.antipatternReportResultList = AntipatternReportResultListCopier.copyFromBuilder(antipatternReportResultList);
        }

        @Override
        public final Builder antipatternReportResultList(Collection<AntipatternReportResult> antipatternReportResultList) {
            this.antipatternReportResultList = AntipatternReportResultListCopier.copy(antipatternReportResultList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder antipatternReportResultList(AntipatternReportResult ... antipatternReportResultList) {
            this.antipatternReportResultList(Arrays.asList(antipatternReportResultList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder antipatternReportResultList(Consumer<AntipatternReportResult.Builder> ... antipatternReportResultList) {
            this.antipatternReportResultList(Stream.of(antipatternReportResultList).map(c -> (AntipatternReportResult)((AntipatternReportResult.Builder)AntipatternReportResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public Result build() {
            return new Result(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Result> {
        public Builder analysisStatus(AnalysisStatusUnion var1);

        default public Builder analysisStatus(Consumer<AnalysisStatusUnion.Builder> analysisStatus) {
            return this.analysisStatus((AnalysisStatusUnion)((AnalysisStatusUnion.Builder)AnalysisStatusUnion.builder().applyMutation(analysisStatus)).build());
        }

        public Builder analysisType(String var1);

        public Builder analysisType(AnalysisType var1);

        public Builder antipatternReportResultList(Collection<AntipatternReportResult> var1);

        public Builder antipatternReportResultList(AntipatternReportResult ... var1);

        public Builder antipatternReportResultList(Consumer<AntipatternReportResult.Builder> ... var1);

        public Builder statusMessage(String var1);
    }
}

