/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DatabaseManagementPreference {
    AWS_MANAGED("AWS-managed"),
    SELF_MANAGE("Self-manage"),
    NO_PREFERENCE("No preference"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DatabaseManagementPreference> VALUE_MAP;
    private final String value;

    private DatabaseManagementPreference(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DatabaseManagementPreference fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DatabaseManagementPreference> knownValues() {
        EnumSet<DatabaseManagementPreference> knownValues = EnumSet.allOf(DatabaseManagementPreference.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DatabaseManagementPreference.class, DatabaseManagementPreference::toString);
    }
}

