/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMigrationTaskUpdatesRequest extends MigrationHubRequest implements
        ToCopyableBuilder<ListMigrationTaskUpdatesRequest.Builder, ListMigrationTaskUpdatesRequest> {
    private static final SdkField<String> PROGRESS_UPDATE_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgressUpdateStream").getter(getter(ListMigrationTaskUpdatesRequest::progressUpdateStream))
            .setter(setter(Builder::progressUpdateStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressUpdateStream").build())
            .build();

    private static final SdkField<String> MIGRATION_TASK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MigrationTaskName").getter(getter(ListMigrationTaskUpdatesRequest::migrationTaskName))
            .setter(setter(Builder::migrationTaskName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MigrationTaskName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMigrationTaskUpdatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListMigrationTaskUpdatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROGRESS_UPDATE_STREAM_FIELD,
            MIGRATION_TASK_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String progressUpdateStream;

    private final String migrationTaskName;

    private final String nextToken;

    private final Integer maxResults;

    private ListMigrationTaskUpdatesRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The name of the progress-update stream, which is used for access control as well as a namespace for
     * migration-task names that is implicitly linked to your AWS account. The progress-update stream must uniquely
     * identify the migration tool as it is used for all updates made by the tool; however, it does not need to be
     * unique for each AWS account because it is scoped to the AWS account.
     * </p>
     * 
     * @return The name of the progress-update stream, which is used for access control as well as a namespace for
     *         migration-task names that is implicitly linked to your AWS account. The progress-update stream must
     *         uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not
     *         need to be unique for each AWS account because it is scoped to the AWS account.
     */
    public final String progressUpdateStream() {
        return progressUpdateStream;
    }

    /**
     * <p>
     * A unique identifier that references the migration task. <i>Do not include sensitive data in this field.</i>
     * </p>
     * 
     * @return A unique identifier that references the migration task. <i>Do not include sensitive data in this
     *         field.</i>
     */
    public final String migrationTaskName() {
        return migrationTaskName;
    }

    /**
     * <p>
     * If <code>NextToken</code> was returned by a previous call, there are more results available. The value of
     * <code>NextToken</code> is a unique pagination token for each page. To retrieve the next page of results, specify
     * the <code>NextToken</code> value that the previous call returned. Keep all other arguments unchanged. Each
     * pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken
     * error.
     * </p>
     * 
     * @return If <code>NextToken</code> was returned by a previous call, there are more results available. The value of
     *         <code>NextToken</code> is a unique pagination token for each page. To retrieve the next page of results,
     *         specify the <code>NextToken</code> value that the previous call returned. Keep all other arguments
     *         unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an
     *         HTTP 400 InvalidToken error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If more results exist than the value that you specify
     * here for <code>MaxResults</code>, the response will include a token that you can use to retrieve the next set of
     * results.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If more results exist than the value that you
     *         specify here for <code>MaxResults</code>, the response will include a token that you can use to retrieve
     *         the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMigrationTaskUpdatesRequest)) {
            return false;
        }
        ListMigrationTaskUpdatesRequest other = (ListMigrationTaskUpdatesRequest) obj;
        return Objects.equals(progressUpdateStream(), other.progressUpdateStream())
                && Objects.equals(migrationTaskName(), other.migrationTaskName())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMigrationTaskUpdatesRequest").add("ProgressUpdateStream", progressUpdateStream())
                .add("MigrationTaskName", migrationTaskName()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProgressUpdateStream":
            return Optional.ofNullable(clazz.cast(progressUpdateStream()));
        case "MigrationTaskName":
            return Optional.ofNullable(clazz.cast(migrationTaskName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProgressUpdateStream", PROGRESS_UPDATE_STREAM_FIELD);
        map.put("MigrationTaskName", MIGRATION_TASK_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMigrationTaskUpdatesRequest, T> g) {
        return obj -> g.apply((ListMigrationTaskUpdatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListMigrationTaskUpdatesRequest> {
        /**
         * <p>
         * The name of the progress-update stream, which is used for access control as well as a namespace for
         * migration-task names that is implicitly linked to your AWS account. The progress-update stream must uniquely
         * identify the migration tool as it is used for all updates made by the tool; however, it does not need to be
         * unique for each AWS account because it is scoped to the AWS account.
         * </p>
         * 
         * @param progressUpdateStream
         *        The name of the progress-update stream, which is used for access control as well as a namespace for
         *        migration-task names that is implicitly linked to your AWS account. The progress-update stream must
         *        uniquely identify the migration tool as it is used for all updates made by the tool; however, it does
         *        not need to be unique for each AWS account because it is scoped to the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressUpdateStream(String progressUpdateStream);

        /**
         * <p>
         * A unique identifier that references the migration task. <i>Do not include sensitive data in this field.</i>
         * </p>
         * 
         * @param migrationTaskName
         *        A unique identifier that references the migration task. <i>Do not include sensitive data in this
         *        field.</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder migrationTaskName(String migrationTaskName);

        /**
         * <p>
         * If <code>NextToken</code> was returned by a previous call, there are more results available. The value of
         * <code>NextToken</code> is a unique pagination token for each page. To retrieve the next page of results,
         * specify the <code>NextToken</code> value that the previous call returned. Keep all other arguments unchanged.
         * Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400
         * InvalidToken error.
         * </p>
         * 
         * @param nextToken
         *        If <code>NextToken</code> was returned by a previous call, there are more results available. The value
         *        of <code>NextToken</code> is a unique pagination token for each page. To retrieve the next page of
         *        results, specify the <code>NextToken</code> value that the previous call returned. Keep all other
         *        arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token
         *        will return an HTTP 400 InvalidToken error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to include in the response. If more results exist than the value that you
         * specify here for <code>MaxResults</code>, the response will include a token that you can use to retrieve the
         * next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If more results exist than the value that
         *        you specify here for <code>MaxResults</code>, the response will include a token that you can use to
         *        retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String progressUpdateStream;

        private String migrationTaskName;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMigrationTaskUpdatesRequest model) {
            super(model);
            progressUpdateStream(model.progressUpdateStream);
            migrationTaskName(model.migrationTaskName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getProgressUpdateStream() {
            return progressUpdateStream;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final String getMigrationTaskName() {
            return migrationTaskName;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMigrationTaskUpdatesRequest build() {
            return new ListMigrationTaskUpdatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
