/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotifyApplicationStateRequest extends MigrationHubRequest implements
        ToCopyableBuilder<NotifyApplicationStateRequest.Builder, NotifyApplicationStateRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(NotifyApplicationStateRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NotifyApplicationStateRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATE_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdateDateTime").getter(getter(NotifyApplicationStateRequest::updateDateTime))
            .setter(setter(Builder::updateDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDateTime").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(NotifyApplicationStateRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            STATUS_FIELD, UPDATE_DATE_TIME_FIELD, DRY_RUN_FIELD));

    private final String applicationId;

    private final String status;

    private final Instant updateDateTime;

    private final Boolean dryRun;

    private NotifyApplicationStateRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.status = builder.status;
        this.updateDateTime = builder.updateDateTime;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The configurationId in Application Discovery Service that uniquely identifies the grouped application.
     * </p>
     * 
     * @return The configurationId in Application Discovery Service that uniquely identifies the grouped application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * Status of the application - Not Started, In-Progress, Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application - Not Started, In-Progress, Complete.
     * @see ApplicationStatus
     */
    public final ApplicationStatus status() {
        return ApplicationStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the application - Not Started, In-Progress, Complete.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ApplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the application - Not Started, In-Progress, Complete.
     * @see ApplicationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when the application state changed.
     * </p>
     * 
     * @return The timestamp when the application state changed.
     */
    public final Instant updateDateTime() {
        return updateDateTime;
    }

    /**
     * <p>
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission
     * to make the call.
     * </p>
     * 
     * @return Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
     *         permission to make the call.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyApplicationStateRequest)) {
            return false;
        }
        NotifyApplicationStateRequest other = (NotifyApplicationStateRequest) obj;
        return Objects.equals(applicationId(), other.applicationId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updateDateTime(), other.updateDateTime()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotifyApplicationStateRequest").add("ApplicationId", applicationId())
                .add("Status", statusAsString()).add("UpdateDateTime", updateDateTime()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdateDateTime":
            return Optional.ofNullable(clazz.cast(updateDateTime()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyApplicationStateRequest, T> g) {
        return obj -> g.apply((NotifyApplicationStateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, NotifyApplicationStateRequest> {
        /**
         * <p>
         * The configurationId in Application Discovery Service that uniquely identifies the grouped application.
         * </p>
         * 
         * @param applicationId
         *        The configurationId in Application Discovery Service that uniquely identifies the grouped application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * Status of the application - Not Started, In-Progress, Complete.
         * </p>
         * 
         * @param status
         *        Status of the application - Not Started, In-Progress, Complete.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the application - Not Started, In-Progress, Complete.
         * </p>
         * 
         * @param status
         *        Status of the application - Not Started, In-Progress, Complete.
         * @see ApplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationStatus
         */
        Builder status(ApplicationStatus status);

        /**
         * <p>
         * The timestamp when the application state changed.
         * </p>
         * 
         * @param updateDateTime
         *        The timestamp when the application state changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateDateTime(Instant updateDateTime);

        /**
         * <p>
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         * permission to make the call.
         * </p>
         * 
         * @param dryRun
         *        Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has
         *        permission to make the call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String status;

        private Instant updateDateTime;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyApplicationStateRequest model) {
            super(model);
            applicationId(model.applicationId);
            status(model.status);
            updateDateTime(model.updateDateTime);
            dryRun(model.dryRun);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ApplicationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdateDateTime() {
            return updateDateTime;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyApplicationStateRequest build() {
            return new NotifyApplicationStateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
