/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationDataPlaneRouting;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationDefaultLargeStagingDiskType;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationEbsEncryption;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisk;
import software.amazon.awssdk.services.mgn.model.ReplicationConfigurationReplicatedDisksCopier;
import software.amazon.awssdk.services.mgn.model.ReplicationServersSecurityGroupsIDsCopier;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReplicationConfigurationResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, GetReplicationConfigurationResponse> {
    private static final SdkField<Boolean> ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("associateDefaultSecurityGroup").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::associateDefaultSecurityGroup)).setter(GetReplicationConfigurationResponse.setter(Builder::associateDefaultSecurityGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associateDefaultSecurityGroup").build()}).build();
    private static final SdkField<Long> BANDWIDTH_THROTTLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("bandwidthThrottling").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::bandwidthThrottling)).setter(GetReplicationConfigurationResponse.setter(Builder::bandwidthThrottling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidthThrottling").build()}).build();
    private static final SdkField<Boolean> CREATE_PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("createPublicIP").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::createPublicIP)).setter(GetReplicationConfigurationResponse.setter(Builder::createPublicIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createPublicIP").build()}).build();
    private static final SdkField<String> DATA_PLANE_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataPlaneRouting").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::dataPlaneRoutingAsString)).setter(GetReplicationConfigurationResponse.setter(Builder::dataPlaneRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataPlaneRouting").build()}).build();
    private static final SdkField<String> DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultLargeStagingDiskType").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::defaultLargeStagingDiskTypeAsString)).setter(GetReplicationConfigurationResponse.setter(Builder::defaultLargeStagingDiskType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultLargeStagingDiskType").build()}).build();
    private static final SdkField<String> EBS_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ebsEncryption").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::ebsEncryptionAsString)).setter(GetReplicationConfigurationResponse.setter(Builder::ebsEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryption").build()}).build();
    private static final SdkField<String> EBS_ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ebsEncryptionKeyArn").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::ebsEncryptionKeyArn)).setter(GetReplicationConfigurationResponse.setter(Builder::ebsEncryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsEncryptionKeyArn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::name)).setter(GetReplicationConfigurationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<ReplicationConfigurationReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicatedDisks").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::replicatedDisks)).setter(GetReplicationConfigurationResponse.setter(Builder::replicatedDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicationConfigurationReplicatedDisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPLICATION_SERVER_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationServerInstanceType").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::replicationServerInstanceType)).setter(GetReplicationConfigurationResponse.setter(Builder::replicationServerInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServerInstanceType").build()}).build();
    private static final SdkField<List<String>> REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationServersSecurityGroupsIDs").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::replicationServersSecurityGroupsIDs)).setter(GetReplicationConfigurationResponse.setter(Builder::replicationServersSecurityGroupsIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationServersSecurityGroupsIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::sourceServerID)).setter(GetReplicationConfigurationResponse.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<String> STAGING_AREA_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stagingAreaSubnetId").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::stagingAreaSubnetId)).setter(GetReplicationConfigurationResponse.setter(Builder::stagingAreaSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaSubnetId").build()}).build();
    private static final SdkField<Map<String, String>> STAGING_AREA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("stagingAreaTags").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::stagingAreaTags)).setter(GetReplicationConfigurationResponse.setter(Builder::stagingAreaTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stagingAreaTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEDICATED_REPLICATION_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useDedicatedReplicationServer").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::useDedicatedReplicationServer)).setter(GetReplicationConfigurationResponse.setter(Builder::useDedicatedReplicationServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useDedicatedReplicationServer").build()}).build();
    private static final SdkField<Boolean> USE_FIPS_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("useFipsEndpoint").getter(GetReplicationConfigurationResponse.getter(GetReplicationConfigurationResponse::useFipsEndpoint)).setter(GetReplicationConfigurationResponse.setter(Builder::useFipsEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useFipsEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD, BANDWIDTH_THROTTLING_FIELD, CREATE_PUBLIC_IP_FIELD, DATA_PLANE_ROUTING_FIELD, DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD, EBS_ENCRYPTION_FIELD, EBS_ENCRYPTION_KEY_ARN_FIELD, NAME_FIELD, REPLICATED_DISKS_FIELD, REPLICATION_SERVER_INSTANCE_TYPE_FIELD, REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD, SOURCE_SERVER_ID_FIELD, STAGING_AREA_SUBNET_ID_FIELD, STAGING_AREA_TAGS_FIELD, USE_DEDICATED_REPLICATION_SERVER_FIELD, USE_FIPS_ENDPOINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetReplicationConfigurationResponse.memberNameToFieldInitializer();
    private final Boolean associateDefaultSecurityGroup;
    private final Long bandwidthThrottling;
    private final Boolean createPublicIP;
    private final String dataPlaneRouting;
    private final String defaultLargeStagingDiskType;
    private final String ebsEncryption;
    private final String ebsEncryptionKeyArn;
    private final String name;
    private final List<ReplicationConfigurationReplicatedDisk> replicatedDisks;
    private final String replicationServerInstanceType;
    private final List<String> replicationServersSecurityGroupsIDs;
    private final String sourceServerID;
    private final String stagingAreaSubnetId;
    private final Map<String, String> stagingAreaTags;
    private final Boolean useDedicatedReplicationServer;
    private final Boolean useFipsEndpoint;

    private GetReplicationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.associateDefaultSecurityGroup = builder.associateDefaultSecurityGroup;
        this.bandwidthThrottling = builder.bandwidthThrottling;
        this.createPublicIP = builder.createPublicIP;
        this.dataPlaneRouting = builder.dataPlaneRouting;
        this.defaultLargeStagingDiskType = builder.defaultLargeStagingDiskType;
        this.ebsEncryption = builder.ebsEncryption;
        this.ebsEncryptionKeyArn = builder.ebsEncryptionKeyArn;
        this.name = builder.name;
        this.replicatedDisks = builder.replicatedDisks;
        this.replicationServerInstanceType = builder.replicationServerInstanceType;
        this.replicationServersSecurityGroupsIDs = builder.replicationServersSecurityGroupsIDs;
        this.sourceServerID = builder.sourceServerID;
        this.stagingAreaSubnetId = builder.stagingAreaSubnetId;
        this.stagingAreaTags = builder.stagingAreaTags;
        this.useDedicatedReplicationServer = builder.useDedicatedReplicationServer;
        this.useFipsEndpoint = builder.useFipsEndpoint;
    }

    public final Boolean associateDefaultSecurityGroup() {
        return this.associateDefaultSecurityGroup;
    }

    public final Long bandwidthThrottling() {
        return this.bandwidthThrottling;
    }

    public final Boolean createPublicIP() {
        return this.createPublicIP;
    }

    public final ReplicationConfigurationDataPlaneRouting dataPlaneRouting() {
        return ReplicationConfigurationDataPlaneRouting.fromValue(this.dataPlaneRouting);
    }

    public final String dataPlaneRoutingAsString() {
        return this.dataPlaneRouting;
    }

    public final ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType() {
        return ReplicationConfigurationDefaultLargeStagingDiskType.fromValue(this.defaultLargeStagingDiskType);
    }

    public final String defaultLargeStagingDiskTypeAsString() {
        return this.defaultLargeStagingDiskType;
    }

    public final ReplicationConfigurationEbsEncryption ebsEncryption() {
        return ReplicationConfigurationEbsEncryption.fromValue(this.ebsEncryption);
    }

    public final String ebsEncryptionAsString() {
        return this.ebsEncryption;
    }

    public final String ebsEncryptionKeyArn() {
        return this.ebsEncryptionKeyArn;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasReplicatedDisks() {
        return this.replicatedDisks != null && !(this.replicatedDisks instanceof SdkAutoConstructList);
    }

    public final List<ReplicationConfigurationReplicatedDisk> replicatedDisks() {
        return this.replicatedDisks;
    }

    public final String replicationServerInstanceType() {
        return this.replicationServerInstanceType;
    }

    public final boolean hasReplicationServersSecurityGroupsIDs() {
        return this.replicationServersSecurityGroupsIDs != null && !(this.replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList);
    }

    public final List<String> replicationServersSecurityGroupsIDs() {
        return this.replicationServersSecurityGroupsIDs;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final String stagingAreaSubnetId() {
        return this.stagingAreaSubnetId;
    }

    public final boolean hasStagingAreaTags() {
        return this.stagingAreaTags != null && !(this.stagingAreaTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> stagingAreaTags() {
        return this.stagingAreaTags;
    }

    public final Boolean useDedicatedReplicationServer() {
        return this.useDedicatedReplicationServer;
    }

    public final Boolean useFipsEndpoint() {
        return this.useFipsEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.associateDefaultSecurityGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidthThrottling());
        hashCode = 31 * hashCode + Objects.hashCode(this.createPublicIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPlaneRoutingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultLargeStagingDiskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEncryptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsEncryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicatedDisks() ? this.replicatedDisks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationServerInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationServersSecurityGroupsIDs() ? this.replicationServersSecurityGroupsIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.stagingAreaSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStagingAreaTags() ? this.stagingAreaTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDedicatedReplicationServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.useFipsEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReplicationConfigurationResponse)) {
            return false;
        }
        GetReplicationConfigurationResponse other = (GetReplicationConfigurationResponse)((Object)obj);
        return Objects.equals(this.associateDefaultSecurityGroup(), other.associateDefaultSecurityGroup()) && Objects.equals(this.bandwidthThrottling(), other.bandwidthThrottling()) && Objects.equals(this.createPublicIP(), other.createPublicIP()) && Objects.equals(this.dataPlaneRoutingAsString(), other.dataPlaneRoutingAsString()) && Objects.equals(this.defaultLargeStagingDiskTypeAsString(), other.defaultLargeStagingDiskTypeAsString()) && Objects.equals(this.ebsEncryptionAsString(), other.ebsEncryptionAsString()) && Objects.equals(this.ebsEncryptionKeyArn(), other.ebsEncryptionKeyArn()) && Objects.equals(this.name(), other.name()) && this.hasReplicatedDisks() == other.hasReplicatedDisks() && Objects.equals(this.replicatedDisks(), other.replicatedDisks()) && Objects.equals(this.replicationServerInstanceType(), other.replicationServerInstanceType()) && this.hasReplicationServersSecurityGroupsIDs() == other.hasReplicationServersSecurityGroupsIDs() && Objects.equals(this.replicationServersSecurityGroupsIDs(), other.replicationServersSecurityGroupsIDs()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && Objects.equals(this.stagingAreaSubnetId(), other.stagingAreaSubnetId()) && this.hasStagingAreaTags() == other.hasStagingAreaTags() && Objects.equals(this.stagingAreaTags(), other.stagingAreaTags()) && Objects.equals(this.useDedicatedReplicationServer(), other.useDedicatedReplicationServer()) && Objects.equals(this.useFipsEndpoint(), other.useFipsEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"GetReplicationConfigurationResponse").add("AssociateDefaultSecurityGroup", (Object)this.associateDefaultSecurityGroup()).add("BandwidthThrottling", (Object)this.bandwidthThrottling()).add("CreatePublicIP", (Object)this.createPublicIP()).add("DataPlaneRouting", (Object)this.dataPlaneRoutingAsString()).add("DefaultLargeStagingDiskType", (Object)this.defaultLargeStagingDiskTypeAsString()).add("EbsEncryption", (Object)this.ebsEncryptionAsString()).add("EbsEncryptionKeyArn", (Object)this.ebsEncryptionKeyArn()).add("Name", (Object)this.name()).add("ReplicatedDisks", this.hasReplicatedDisks() ? this.replicatedDisks() : null).add("ReplicationServerInstanceType", (Object)this.replicationServerInstanceType()).add("ReplicationServersSecurityGroupsIDs", this.hasReplicationServersSecurityGroupsIDs() ? this.replicationServersSecurityGroupsIDs() : null).add("SourceServerID", (Object)this.sourceServerID()).add("StagingAreaSubnetId", (Object)this.stagingAreaSubnetId()).add("StagingAreaTags", (Object)(this.stagingAreaTags() == null ? null : "*** Sensitive Data Redacted ***")).add("UseDedicatedReplicationServer", (Object)this.useDedicatedReplicationServer()).add("UseFipsEndpoint", (Object)this.useFipsEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associateDefaultSecurityGroup": {
                return Optional.ofNullable(clazz.cast(this.associateDefaultSecurityGroup()));
            }
            case "bandwidthThrottling": {
                return Optional.ofNullable(clazz.cast(this.bandwidthThrottling()));
            }
            case "createPublicIP": {
                return Optional.ofNullable(clazz.cast(this.createPublicIP()));
            }
            case "dataPlaneRouting": {
                return Optional.ofNullable(clazz.cast(this.dataPlaneRoutingAsString()));
            }
            case "defaultLargeStagingDiskType": {
                return Optional.ofNullable(clazz.cast(this.defaultLargeStagingDiskTypeAsString()));
            }
            case "ebsEncryption": {
                return Optional.ofNullable(clazz.cast(this.ebsEncryptionAsString()));
            }
            case "ebsEncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.ebsEncryptionKeyArn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "replicatedDisks": {
                return Optional.ofNullable(clazz.cast(this.replicatedDisks()));
            }
            case "replicationServerInstanceType": {
                return Optional.ofNullable(clazz.cast(this.replicationServerInstanceType()));
            }
            case "replicationServersSecurityGroupsIDs": {
                return Optional.ofNullable(clazz.cast(this.replicationServersSecurityGroupsIDs()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "stagingAreaSubnetId": {
                return Optional.ofNullable(clazz.cast(this.stagingAreaSubnetId()));
            }
            case "stagingAreaTags": {
                return Optional.ofNullable(clazz.cast(this.stagingAreaTags()));
            }
            case "useDedicatedReplicationServer": {
                return Optional.ofNullable(clazz.cast(this.useDedicatedReplicationServer()));
            }
            case "useFipsEndpoint": {
                return Optional.ofNullable(clazz.cast(this.useFipsEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("associateDefaultSecurityGroup", ASSOCIATE_DEFAULT_SECURITY_GROUP_FIELD);
        map.put("bandwidthThrottling", BANDWIDTH_THROTTLING_FIELD);
        map.put("createPublicIP", CREATE_PUBLIC_IP_FIELD);
        map.put("dataPlaneRouting", DATA_PLANE_ROUTING_FIELD);
        map.put("defaultLargeStagingDiskType", DEFAULT_LARGE_STAGING_DISK_TYPE_FIELD);
        map.put("ebsEncryption", EBS_ENCRYPTION_FIELD);
        map.put("ebsEncryptionKeyArn", EBS_ENCRYPTION_KEY_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("replicatedDisks", REPLICATED_DISKS_FIELD);
        map.put("replicationServerInstanceType", REPLICATION_SERVER_INSTANCE_TYPE_FIELD);
        map.put("replicationServersSecurityGroupsIDs", REPLICATION_SERVERS_SECURITY_GROUPS_I_DS_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        map.put("stagingAreaSubnetId", STAGING_AREA_SUBNET_ID_FIELD);
        map.put("stagingAreaTags", STAGING_AREA_TAGS_FIELD);
        map.put("useDedicatedReplicationServer", USE_DEDICATED_REPLICATION_SERVER_FIELD);
        map.put("useFipsEndpoint", USE_FIPS_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReplicationConfigurationResponse, T> g) {
        return obj -> g.apply((GetReplicationConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private Boolean associateDefaultSecurityGroup;
        private Long bandwidthThrottling;
        private Boolean createPublicIP;
        private String dataPlaneRouting;
        private String defaultLargeStagingDiskType;
        private String ebsEncryption;
        private String ebsEncryptionKeyArn;
        private String name;
        private List<ReplicationConfigurationReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();
        private String replicationServerInstanceType;
        private List<String> replicationServersSecurityGroupsIDs = DefaultSdkAutoConstructList.getInstance();
        private String sourceServerID;
        private String stagingAreaSubnetId;
        private Map<String, String> stagingAreaTags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean useDedicatedReplicationServer;
        private Boolean useFipsEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReplicationConfigurationResponse model) {
            super(model);
            this.associateDefaultSecurityGroup(model.associateDefaultSecurityGroup);
            this.bandwidthThrottling(model.bandwidthThrottling);
            this.createPublicIP(model.createPublicIP);
            this.dataPlaneRouting(model.dataPlaneRouting);
            this.defaultLargeStagingDiskType(model.defaultLargeStagingDiskType);
            this.ebsEncryption(model.ebsEncryption);
            this.ebsEncryptionKeyArn(model.ebsEncryptionKeyArn);
            this.name(model.name);
            this.replicatedDisks(model.replicatedDisks);
            this.replicationServerInstanceType(model.replicationServerInstanceType);
            this.replicationServersSecurityGroupsIDs(model.replicationServersSecurityGroupsIDs);
            this.sourceServerID(model.sourceServerID);
            this.stagingAreaSubnetId(model.stagingAreaSubnetId);
            this.stagingAreaTags(model.stagingAreaTags);
            this.useDedicatedReplicationServer(model.useDedicatedReplicationServer);
            this.useFipsEndpoint(model.useFipsEndpoint);
        }

        public final Boolean getAssociateDefaultSecurityGroup() {
            return this.associateDefaultSecurityGroup;
        }

        public final void setAssociateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
        }

        @Override
        public final Builder associateDefaultSecurityGroup(Boolean associateDefaultSecurityGroup) {
            this.associateDefaultSecurityGroup = associateDefaultSecurityGroup;
            return this;
        }

        public final Long getBandwidthThrottling() {
            return this.bandwidthThrottling;
        }

        public final void setBandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
        }

        @Override
        public final Builder bandwidthThrottling(Long bandwidthThrottling) {
            this.bandwidthThrottling = bandwidthThrottling;
            return this;
        }

        public final Boolean getCreatePublicIP() {
            return this.createPublicIP;
        }

        public final void setCreatePublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
        }

        @Override
        public final Builder createPublicIP(Boolean createPublicIP) {
            this.createPublicIP = createPublicIP;
            return this;
        }

        public final String getDataPlaneRouting() {
            return this.dataPlaneRouting;
        }

        public final void setDataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
        }

        @Override
        public final Builder dataPlaneRouting(String dataPlaneRouting) {
            this.dataPlaneRouting = dataPlaneRouting;
            return this;
        }

        @Override
        public final Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting dataPlaneRouting) {
            this.dataPlaneRouting(dataPlaneRouting == null ? null : dataPlaneRouting.toString());
            return this;
        }

        public final String getDefaultLargeStagingDiskType() {
            return this.defaultLargeStagingDiskType;
        }

        public final void setDefaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(String defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType = defaultLargeStagingDiskType;
            return this;
        }

        @Override
        public final Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType defaultLargeStagingDiskType) {
            this.defaultLargeStagingDiskType(defaultLargeStagingDiskType == null ? null : defaultLargeStagingDiskType.toString());
            return this;
        }

        public final String getEbsEncryption() {
            return this.ebsEncryption;
        }

        public final void setEbsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
        }

        @Override
        public final Builder ebsEncryption(String ebsEncryption) {
            this.ebsEncryption = ebsEncryption;
            return this;
        }

        @Override
        public final Builder ebsEncryption(ReplicationConfigurationEbsEncryption ebsEncryption) {
            this.ebsEncryption(ebsEncryption == null ? null : ebsEncryption.toString());
            return this;
        }

        public final String getEbsEncryptionKeyArn() {
            return this.ebsEncryptionKeyArn;
        }

        public final void setEbsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
        }

        @Override
        public final Builder ebsEncryptionKeyArn(String ebsEncryptionKeyArn) {
            this.ebsEncryptionKeyArn = ebsEncryptionKeyArn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ReplicationConfigurationReplicatedDisk.Builder> getReplicatedDisks() {
            List<ReplicationConfigurationReplicatedDisk.Builder> result = ReplicationConfigurationReplicatedDisksCopier.copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicatedDisks(Collection<ReplicationConfigurationReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = ReplicationConfigurationReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        public final Builder replicatedDisks(Collection<ReplicationConfigurationReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = ReplicationConfigurationReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(ReplicationConfigurationReplicatedDisk ... replicatedDisks) {
            this.replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<ReplicationConfigurationReplicatedDisk.Builder> ... replicatedDisks) {
            this.replicatedDisks(Stream.of(replicatedDisks).map(c -> (ReplicationConfigurationReplicatedDisk)((ReplicationConfigurationReplicatedDisk.Builder)ReplicationConfigurationReplicatedDisk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getReplicationServerInstanceType() {
            return this.replicationServerInstanceType;
        }

        public final void setReplicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
        }

        @Override
        public final Builder replicationServerInstanceType(String replicationServerInstanceType) {
            this.replicationServerInstanceType = replicationServerInstanceType;
            return this;
        }

        public final Collection<String> getReplicationServersSecurityGroupsIDs() {
            if (this.replicationServersSecurityGroupsIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationServersSecurityGroupsIDs;
        }

        public final void setReplicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier.copy(replicationServersSecurityGroupsIDs);
        }

        @Override
        public final Builder replicationServersSecurityGroupsIDs(Collection<String> replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs = ReplicationServersSecurityGroupsIDsCopier.copy(replicationServersSecurityGroupsIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationServersSecurityGroupsIDs(String ... replicationServersSecurityGroupsIDs) {
            this.replicationServersSecurityGroupsIDs(Arrays.asList(replicationServersSecurityGroupsIDs));
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getStagingAreaSubnetId() {
            return this.stagingAreaSubnetId;
        }

        public final void setStagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
        }

        @Override
        public final Builder stagingAreaSubnetId(String stagingAreaSubnetId) {
            this.stagingAreaSubnetId = stagingAreaSubnetId;
            return this;
        }

        public final Map<String, String> getStagingAreaTags() {
            if (this.stagingAreaTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.stagingAreaTags;
        }

        public final void setStagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
        }

        @Override
        public final Builder stagingAreaTags(Map<String, String> stagingAreaTags) {
            this.stagingAreaTags = TagsMapCopier.copy(stagingAreaTags);
            return this;
        }

        public final Boolean getUseDedicatedReplicationServer() {
            return this.useDedicatedReplicationServer;
        }

        public final void setUseDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
        }

        @Override
        public final Builder useDedicatedReplicationServer(Boolean useDedicatedReplicationServer) {
            this.useDedicatedReplicationServer = useDedicatedReplicationServer;
            return this;
        }

        public final Boolean getUseFipsEndpoint() {
            return this.useFipsEndpoint;
        }

        public final void setUseFipsEndpoint(Boolean useFipsEndpoint) {
            this.useFipsEndpoint = useFipsEndpoint;
        }

        @Override
        public final Builder useFipsEndpoint(Boolean useFipsEndpoint) {
            this.useFipsEndpoint = useFipsEndpoint;
            return this;
        }

        @Override
        public GetReplicationConfigurationResponse build() {
            return new GetReplicationConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReplicationConfigurationResponse> {
        public Builder associateDefaultSecurityGroup(Boolean var1);

        public Builder bandwidthThrottling(Long var1);

        public Builder createPublicIP(Boolean var1);

        public Builder dataPlaneRouting(String var1);

        public Builder dataPlaneRouting(ReplicationConfigurationDataPlaneRouting var1);

        public Builder defaultLargeStagingDiskType(String var1);

        public Builder defaultLargeStagingDiskType(ReplicationConfigurationDefaultLargeStagingDiskType var1);

        public Builder ebsEncryption(String var1);

        public Builder ebsEncryption(ReplicationConfigurationEbsEncryption var1);

        public Builder ebsEncryptionKeyArn(String var1);

        public Builder name(String var1);

        public Builder replicatedDisks(Collection<ReplicationConfigurationReplicatedDisk> var1);

        public Builder replicatedDisks(ReplicationConfigurationReplicatedDisk ... var1);

        public Builder replicatedDisks(Consumer<ReplicationConfigurationReplicatedDisk.Builder> ... var1);

        public Builder replicationServerInstanceType(String var1);

        public Builder replicationServersSecurityGroupsIDs(Collection<String> var1);

        public Builder replicationServersSecurityGroupsIDs(String ... var1);

        public Builder sourceServerID(String var1);

        public Builder stagingAreaSubnetId(String var1);

        public Builder stagingAreaTags(Map<String, String> var1);

        public Builder useDedicatedReplicationServer(Boolean var1);

        public Builder useFipsEndpoint(Boolean var1);
    }
}

