/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateConnectorResponse extends MgnResponse implements
        ToCopyableBuilder<UpdateConnectorResponse.Builder, UpdateConnectorResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateConnectorResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectorID").getter(getter(UpdateConnectorResponse::connectorID)).setter(setter(Builder::connectorID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorID").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateConnectorResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ConnectorSsmCommandConfig> SSM_COMMAND_CONFIG_FIELD = SdkField
            .<ConnectorSsmCommandConfig> builder(MarshallingType.SDK_POJO).memberName("ssmCommandConfig")
            .getter(getter(UpdateConnectorResponse::ssmCommandConfig)).setter(setter(Builder::ssmCommandConfig))
            .constructor(ConnectorSsmCommandConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmCommandConfig").build()).build();

    private static final SdkField<String> SSM_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssmInstanceID").getter(getter(UpdateConnectorResponse::ssmInstanceID))
            .setter(setter(Builder::ssmInstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmInstanceID").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(UpdateConnectorResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONNECTOR_ID_FIELD,
            NAME_FIELD, SSM_COMMAND_CONFIG_FIELD, SSM_INSTANCE_ID_FIELD, TAGS_FIELD));

    private final String arn;

    private final String connectorID;

    private final String name;

    private final ConnectorSsmCommandConfig ssmCommandConfig;

    private final String ssmInstanceID;

    private final Map<String, String> tags;

    private UpdateConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.connectorID = builder.connectorID;
        this.name = builder.name;
        this.ssmCommandConfig = builder.ssmCommandConfig;
        this.ssmInstanceID = builder.ssmInstanceID;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Connector arn.
     * </p>
     * 
     * @return Connector arn.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Connector ID.
     * </p>
     * 
     * @return Connector ID.
     */
    public final String connectorID() {
        return connectorID;
    }

    /**
     * <p>
     * Connector name.
     * </p>
     * 
     * @return Connector name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Connector SSM command config.
     * </p>
     * 
     * @return Connector SSM command config.
     */
    public final ConnectorSsmCommandConfig ssmCommandConfig() {
        return ssmCommandConfig;
    }

    /**
     * <p>
     * Connector SSM instance ID.
     * </p>
     * 
     * @return Connector SSM instance ID.
     */
    public final String ssmInstanceID() {
        return ssmInstanceID;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Connector tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Connector tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(connectorID());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ssmCommandConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ssmInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorResponse)) {
            return false;
        }
        UpdateConnectorResponse other = (UpdateConnectorResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(connectorID(), other.connectorID())
                && Objects.equals(name(), other.name()) && Objects.equals(ssmCommandConfig(), other.ssmCommandConfig())
                && Objects.equals(ssmInstanceID(), other.ssmInstanceID()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateConnectorResponse").add("Arn", arn()).add("ConnectorID", connectorID())
                .add("Name", name()).add("SsmCommandConfig", ssmCommandConfig()).add("SsmInstanceID", ssmInstanceID())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "connectorID":
            return Optional.ofNullable(clazz.cast(connectorID()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ssmCommandConfig":
            return Optional.ofNullable(clazz.cast(ssmCommandConfig()));
        case "ssmInstanceID":
            return Optional.ofNullable(clazz.cast(ssmInstanceID()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorResponse, T> g) {
        return obj -> g.apply((UpdateConnectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateConnectorResponse> {
        /**
         * <p>
         * Connector arn.
         * </p>
         * 
         * @param arn
         *        Connector arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Connector ID.
         * </p>
         * 
         * @param connectorID
         *        Connector ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorID(String connectorID);

        /**
         * <p>
         * Connector name.
         * </p>
         * 
         * @param name
         *        Connector name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Connector SSM command config.
         * </p>
         * 
         * @param ssmCommandConfig
         *        Connector SSM command config.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig);

        /**
         * <p>
         * Connector SSM command config.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConnectorSsmCommandConfig.Builder}
         * avoiding the need to create one manually via {@link ConnectorSsmCommandConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConnectorSsmCommandConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #ssmCommandConfig(ConnectorSsmCommandConfig)}.
         * 
         * @param ssmCommandConfig
         *        a consumer that will call methods on {@link ConnectorSsmCommandConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ssmCommandConfig(ConnectorSsmCommandConfig)
         */
        default Builder ssmCommandConfig(Consumer<ConnectorSsmCommandConfig.Builder> ssmCommandConfig) {
            return ssmCommandConfig(ConnectorSsmCommandConfig.builder().applyMutation(ssmCommandConfig).build());
        }

        /**
         * <p>
         * Connector SSM instance ID.
         * </p>
         * 
         * @param ssmInstanceID
         *        Connector SSM instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmInstanceID(String ssmInstanceID);

        /**
         * <p>
         * Connector tags.
         * </p>
         * 
         * @param tags
         *        Connector tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MgnResponse.BuilderImpl implements Builder {
        private String arn;

        private String connectorID;

        private String name;

        private ConnectorSsmCommandConfig ssmCommandConfig;

        private String ssmInstanceID;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorResponse model) {
            super(model);
            arn(model.arn);
            connectorID(model.connectorID);
            name(model.name);
            ssmCommandConfig(model.ssmCommandConfig);
            ssmInstanceID(model.ssmInstanceID);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getConnectorID() {
            return connectorID;
        }

        public final void setConnectorID(String connectorID) {
            this.connectorID = connectorID;
        }

        @Override
        public final Builder connectorID(String connectorID) {
            this.connectorID = connectorID;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectorSsmCommandConfig.Builder getSsmCommandConfig() {
            return ssmCommandConfig != null ? ssmCommandConfig.toBuilder() : null;
        }

        public final void setSsmCommandConfig(ConnectorSsmCommandConfig.BuilderImpl ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig != null ? ssmCommandConfig.build() : null;
        }

        @Override
        public final Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig;
            return this;
        }

        public final String getSsmInstanceID() {
            return ssmInstanceID;
        }

        public final void setSsmInstanceID(String ssmInstanceID) {
            this.ssmInstanceID = ssmInstanceID;
        }

        @Override
        public final Builder ssmInstanceID(String ssmInstanceID) {
            this.ssmInstanceID = ssmInstanceID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateConnectorResponse build() {
            return new UpdateConnectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
