/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Status of the Post Launch Actions running on the Test or Cutover instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostLaunchActionsStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<PostLaunchActionsStatus.Builder, PostLaunchActionsStatus> {
    private static final SdkField<List<JobPostLaunchActionsLaunchStatus>> POST_LAUNCH_ACTIONS_LAUNCH_STATUS_LIST_FIELD = SdkField
            .<List<JobPostLaunchActionsLaunchStatus>> builder(MarshallingType.LIST)
            .memberName("postLaunchActionsLaunchStatusList")
            .getter(getter(PostLaunchActionsStatus::postLaunchActionsLaunchStatusList))
            .setter(setter(Builder::postLaunchActionsLaunchStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActionsLaunchStatusList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<JobPostLaunchActionsLaunchStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(JobPostLaunchActionsLaunchStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SSM_AGENT_DISCOVERY_DATETIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ssmAgentDiscoveryDatetime").getter(getter(PostLaunchActionsStatus::ssmAgentDiscoveryDatetime))
            .setter(setter(Builder::ssmAgentDiscoveryDatetime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmAgentDiscoveryDatetime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            POST_LAUNCH_ACTIONS_LAUNCH_STATUS_LIST_FIELD, SSM_AGENT_DISCOVERY_DATETIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<JobPostLaunchActionsLaunchStatus> postLaunchActionsLaunchStatusList;

    private final String ssmAgentDiscoveryDatetime;

    private PostLaunchActionsStatus(BuilderImpl builder) {
        this.postLaunchActionsLaunchStatusList = builder.postLaunchActionsLaunchStatusList;
        this.ssmAgentDiscoveryDatetime = builder.ssmAgentDiscoveryDatetime;
    }

    /**
     * For responses, this returns true if the service returned a value for the PostLaunchActionsLaunchStatusList
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasPostLaunchActionsLaunchStatusList() {
        return postLaunchActionsLaunchStatusList != null && !(postLaunchActionsLaunchStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Post Launch Action status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPostLaunchActionsLaunchStatusList}
     * method.
     * </p>
     * 
     * @return List of Post Launch Action status.
     */
    public final List<JobPostLaunchActionsLaunchStatus> postLaunchActionsLaunchStatusList() {
        return postLaunchActionsLaunchStatusList;
    }

    /**
     * <p>
     * Time where the AWS Systems Manager was detected as running on the Test or Cutover instance.
     * </p>
     * 
     * @return Time where the AWS Systems Manager was detected as running on the Test or Cutover instance.
     */
    public final String ssmAgentDiscoveryDatetime() {
        return ssmAgentDiscoveryDatetime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasPostLaunchActionsLaunchStatusList() ? postLaunchActionsLaunchStatusList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ssmAgentDiscoveryDatetime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostLaunchActionsStatus)) {
            return false;
        }
        PostLaunchActionsStatus other = (PostLaunchActionsStatus) obj;
        return hasPostLaunchActionsLaunchStatusList() == other.hasPostLaunchActionsLaunchStatusList()
                && Objects.equals(postLaunchActionsLaunchStatusList(), other.postLaunchActionsLaunchStatusList())
                && Objects.equals(ssmAgentDiscoveryDatetime(), other.ssmAgentDiscoveryDatetime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("PostLaunchActionsStatus")
                .add("PostLaunchActionsLaunchStatusList",
                        hasPostLaunchActionsLaunchStatusList() ? postLaunchActionsLaunchStatusList() : null)
                .add("SsmAgentDiscoveryDatetime", ssmAgentDiscoveryDatetime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "postLaunchActionsLaunchStatusList":
            return Optional.ofNullable(clazz.cast(postLaunchActionsLaunchStatusList()));
        case "ssmAgentDiscoveryDatetime":
            return Optional.ofNullable(clazz.cast(ssmAgentDiscoveryDatetime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostLaunchActionsStatus, T> g) {
        return obj -> g.apply((PostLaunchActionsStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostLaunchActionsStatus> {
        /**
         * <p>
         * List of Post Launch Action status.
         * </p>
         * 
         * @param postLaunchActionsLaunchStatusList
         *        List of Post Launch Action status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchActionsLaunchStatusList(Collection<JobPostLaunchActionsLaunchStatus> postLaunchActionsLaunchStatusList);

        /**
         * <p>
         * List of Post Launch Action status.
         * </p>
         * 
         * @param postLaunchActionsLaunchStatusList
         *        List of Post Launch Action status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postLaunchActionsLaunchStatusList(JobPostLaunchActionsLaunchStatus... postLaunchActionsLaunchStatusList);

        /**
         * <p>
         * List of Post Launch Action status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #postLaunchActionsLaunchStatusList(List<JobPostLaunchActionsLaunchStatus>)}.
         * 
         * @param postLaunchActionsLaunchStatusList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mgn.model.JobPostLaunchActionsLaunchStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #postLaunchActionsLaunchStatusList(java.util.Collection<JobPostLaunchActionsLaunchStatus>)
         */
        Builder postLaunchActionsLaunchStatusList(
                Consumer<JobPostLaunchActionsLaunchStatus.Builder>... postLaunchActionsLaunchStatusList);

        /**
         * <p>
         * Time where the AWS Systems Manager was detected as running on the Test or Cutover instance.
         * </p>
         * 
         * @param ssmAgentDiscoveryDatetime
         *        Time where the AWS Systems Manager was detected as running on the Test or Cutover instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ssmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime);
    }

    static final class BuilderImpl implements Builder {
        private List<JobPostLaunchActionsLaunchStatus> postLaunchActionsLaunchStatusList = DefaultSdkAutoConstructList
                .getInstance();

        private String ssmAgentDiscoveryDatetime;

        private BuilderImpl() {
        }

        private BuilderImpl(PostLaunchActionsStatus model) {
            postLaunchActionsLaunchStatusList(model.postLaunchActionsLaunchStatusList);
            ssmAgentDiscoveryDatetime(model.ssmAgentDiscoveryDatetime);
        }

        public final List<JobPostLaunchActionsLaunchStatus.Builder> getPostLaunchActionsLaunchStatusList() {
            List<JobPostLaunchActionsLaunchStatus.Builder> result = PostLaunchActionsLaunchStatusListCopier
                    .copyToBuilder(this.postLaunchActionsLaunchStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPostLaunchActionsLaunchStatusList(
                Collection<JobPostLaunchActionsLaunchStatus.BuilderImpl> postLaunchActionsLaunchStatusList) {
            this.postLaunchActionsLaunchStatusList = PostLaunchActionsLaunchStatusListCopier
                    .copyFromBuilder(postLaunchActionsLaunchStatusList);
        }

        @Override
        public final Builder postLaunchActionsLaunchStatusList(
                Collection<JobPostLaunchActionsLaunchStatus> postLaunchActionsLaunchStatusList) {
            this.postLaunchActionsLaunchStatusList = PostLaunchActionsLaunchStatusListCopier
                    .copy(postLaunchActionsLaunchStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postLaunchActionsLaunchStatusList(
                JobPostLaunchActionsLaunchStatus... postLaunchActionsLaunchStatusList) {
            postLaunchActionsLaunchStatusList(Arrays.asList(postLaunchActionsLaunchStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder postLaunchActionsLaunchStatusList(
                Consumer<JobPostLaunchActionsLaunchStatus.Builder>... postLaunchActionsLaunchStatusList) {
            postLaunchActionsLaunchStatusList(Stream.of(postLaunchActionsLaunchStatusList)
                    .map(c -> JobPostLaunchActionsLaunchStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSsmAgentDiscoveryDatetime() {
            return ssmAgentDiscoveryDatetime;
        }

        public final void setSsmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
            this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
        }

        @Override
        public final Builder ssmAgentDiscoveryDatetime(String ssmAgentDiscoveryDatetime) {
            this.ssmAgentDiscoveryDatetime = ssmAgentDiscoveryDatetime;
            return this;
        }

        @Override
        public PostLaunchActionsStatus build() {
            return new PostLaunchActionsStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
