/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ExportTask;
import software.amazon.awssdk.services.mgn.model.ListExportsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportsResponse;

public class ListExportsPublisher
implements SdkPublisher<ListExportsResponse> {
    private final MgnAsyncClient client;
    private final ListExportsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListExportsPublisher(MgnAsyncClient client, ListExportsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListExportsPublisher(MgnAsyncClient client, ListExportsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListExportsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ExportTask> items() {
        Function<ListExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListExportsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListExportsResponseFetcher
    implements AsyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListExportsResponse> nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsPublisher.this.client.listExports(ListExportsPublisher.this.firstRequest);
            }
            return ListExportsPublisher.this.client.listExports((ListExportsRequest)((Object)ListExportsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

