/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ExportTaskError;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse;

public class ListExportErrorsIterable
implements SdkIterable<ListExportErrorsResponse> {
    private final MgnClient client;
    private final ListExportErrorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportErrorsIterable(MgnClient client, ListExportErrorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListExportErrorsResponseFetcher();
    }

    public Iterator<ListExportErrorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportTaskError> items() {
        Function<ListExportErrorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExportErrorsResponseFetcher
    implements SyncPageFetcher<ListExportErrorsResponse> {
        private ListExportErrorsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportErrorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExportErrorsResponse nextPage(ListExportErrorsResponse previousPage) {
            if (previousPage == null) {
                return ListExportErrorsIterable.this.client.listExportErrors(ListExportErrorsIterable.this.firstRequest);
            }
            return ListExportErrorsIterable.this.client.listExportErrors((ListExportErrorsRequest)((Object)ListExportErrorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

