/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mgn.DefaultMgnBaseClientBuilder;
import software.amazon.awssdk.services.mgn.DefaultMgnClient;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.MgnClientBuilder;
import software.amazon.awssdk.services.mgn.MgnServiceClientConfiguration;
import software.amazon.awssdk.services.mgn.endpoints.MgnEndpointProvider;

@SdkInternalApi
final class DefaultMgnClientBuilder
extends DefaultMgnBaseClientBuilder<MgnClientBuilder, MgnClient>
implements MgnClientBuilder {
    DefaultMgnClientBuilder() {
    }

    @Override
    public DefaultMgnClientBuilder endpointProvider(MgnEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MgnClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMgnClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MgnServiceClientConfiguration serviceClientConfiguration = MgnServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMgnClient(serviceClientConfiguration, clientConfiguration);
    }
}

