/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.MgnServiceClientConfiguration;
import software.amazon.awssdk.services.mgn.model.AccessDeniedException;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateResponse;
import software.amazon.awssdk.services.mgn.model.ConflictException;
import software.amazon.awssdk.services.mgn.model.CreateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.CreateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateWaveRequest;
import software.amazon.awssdk.services.mgn.model.CreateWaveResponse;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.mgn.model.DeleteJobRequest;
import software.amazon.awssdk.services.mgn.model.DeleteJobResponse;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientResponse;
import software.amazon.awssdk.services.mgn.model.DeleteWaveRequest;
import software.amazon.awssdk.services.mgn.model.DeleteWaveResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceResponse;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverResponse;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.InitializeServiceRequest;
import software.amazon.awssdk.services.mgn.model.InitializeServiceResponse;
import software.amazon.awssdk.services.mgn.model.InternalServerException;
import software.amazon.awssdk.services.mgn.model.ListApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.ListApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportsResponse;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListWavesRequest;
import software.amazon.awssdk.services.mgn.model.ListWavesResponse;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedResponse;
import software.amazon.awssdk.services.mgn.model.MgnException;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.mgn.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.mgn.model.StartCutoverRequest;
import software.amazon.awssdk.services.mgn.model.StartCutoverResponse;
import software.amazon.awssdk.services.mgn.model.StartExportRequest;
import software.amazon.awssdk.services.mgn.model.StartExportResponse;
import software.amazon.awssdk.services.mgn.model.StartImportRequest;
import software.amazon.awssdk.services.mgn.model.StartImportResponse;
import software.amazon.awssdk.services.mgn.model.StartReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StartReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartTestRequest;
import software.amazon.awssdk.services.mgn.model.StartTestResponse;
import software.amazon.awssdk.services.mgn.model.TagResourceRequest;
import software.amazon.awssdk.services.mgn.model.TagResourceResponse;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse;
import software.amazon.awssdk.services.mgn.model.ThrottlingException;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.UninitializedAccountException;
import software.amazon.awssdk.services.mgn.model.UntagResourceRequest;
import software.amazon.awssdk.services.mgn.model.UntagResourceResponse;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeResponse;
import software.amazon.awssdk.services.mgn.model.UpdateWaveRequest;
import software.amazon.awssdk.services.mgn.model.UpdateWaveResponse;
import software.amazon.awssdk.services.mgn.model.ValidationException;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListExportsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListImportsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListWavesIterable;
import software.amazon.awssdk.services.mgn.transform.ArchiveApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ArchiveWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.AssociateApplicationsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.AssociateSourceServersRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ChangeServerLifeCycleStateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.CreateWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteSourceServerRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteVcenterClientRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DeleteWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeJobLogItemsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeJobsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeLaunchConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeReplicationConfigurationTemplatesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeSourceServersRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DescribeVcenterClientsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DisassociateApplicationsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DisassociateSourceServersRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.DisconnectFromServiceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.FinalizeCutoverRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.GetLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.GetReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.InitializeServiceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListExportErrorsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListImportErrorsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListSourceServerActionsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListTemplateActionsRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.ListWavesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.MarkAsArchivedRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.PutSourceServerActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.PutTemplateActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.RemoveSourceServerActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.RemoveTemplateActionRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.RetryDataReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartCutoverRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartExportRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartReplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.StartTestRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.TerminateTargetInstancesRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UnarchiveApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UnarchiveWaveRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateLaunchConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateLaunchConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateReplicationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateReplicationConfigurationTemplateRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateSourceServerReplicationTypeRequestMarshaller;
import software.amazon.awssdk.services.mgn.transform.UpdateWaveRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMgnClient
implements MgnClient {
    private static final Logger log = Logger.loggerFor(DefaultMgnClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final MgnServiceClientConfiguration serviceClientConfiguration;

    protected DefaultMgnClient(MgnServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveApplicationResponse archiveApplication(ArchiveApplicationRequest archiveApplicationRequest) throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ArchiveApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, archiveApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ArchiveApplication");
            ArchiveApplicationResponse archiveApplicationResponse = (ArchiveApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ArchiveApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)archiveApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ArchiveApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return archiveApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$archiveApplication$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArchiveWaveResponse archiveWave(ArchiveWaveRequest archiveWaveRequest) throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ArchiveWaveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, archiveWaveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ArchiveWave");
            ArchiveWaveResponse archiveWaveResponse = (ArchiveWaveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ArchiveWave").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)archiveWaveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ArchiveWaveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return archiveWaveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$archiveWave$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateApplicationsResponse associateApplications(AssociateApplicationsRequest associateApplicationsRequest) throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, associateApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateApplications");
            AssociateApplicationsResponse associateApplicationsResponse = (AssociateApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$associateApplications$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateSourceServersResponse associateSourceServers(AssociateSourceServersRequest associateSourceServersRequest) throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateSourceServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, associateSourceServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateSourceServers");
            AssociateSourceServersResponse associateSourceServersResponse = (AssociateSourceServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateSourceServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateSourceServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateSourceServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateSourceServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$associateSourceServers$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeServerLifeCycleStateResponse changeServerLifeCycleState(ChangeServerLifeCycleStateRequest changeServerLifeCycleStateRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ChangeServerLifeCycleStateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, changeServerLifeCycleStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeServerLifeCycleState");
            ChangeServerLifeCycleStateResponse changeServerLifeCycleStateResponse = (ChangeServerLifeCycleStateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeServerLifeCycleState").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)changeServerLifeCycleStateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ChangeServerLifeCycleStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return changeServerLifeCycleStateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$changeServerLifeCycleState$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws UninitializedAccountException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateApplication");
            CreateApplicationResponse createApplicationResponse = (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$createApplication$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplate(CreateLaunchConfigurationTemplateRequest createLaunchConfigurationTemplateRequest) throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLaunchConfigurationTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, createLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLaunchConfigurationTemplate");
            CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplateResponse = (CreateLaunchConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLaunchConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLaunchConfigurationTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLaunchConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createLaunchConfigurationTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$createLaunchConfigurationTemplate$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest) throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReplicationConfigurationTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, createReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReplicationConfigurationTemplate");
            CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplateResponse = (CreateReplicationConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReplicationConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createReplicationConfigurationTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReplicationConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReplicationConfigurationTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$createReplicationConfigurationTemplate$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWaveResponse createWave(CreateWaveRequest createWaveRequest) throws UninitializedAccountException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWaveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, createWaveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWave");
            CreateWaveResponse createWaveResponse = (CreateWaveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWave").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createWaveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWaveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWaveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$createWave$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteApplication");
            DeleteApplicationResponse deleteApplicationResponse = (DeleteApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteApplication$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteJob");
            DeleteJobResponse deleteJobResponse = (DeleteJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteJob$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplate(DeleteLaunchConfigurationTemplateRequest deleteLaunchConfigurationTemplateRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLaunchConfigurationTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLaunchConfigurationTemplate");
            DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplateResponse = (DeleteLaunchConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLaunchConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLaunchConfigurationTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLaunchConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteLaunchConfigurationTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteLaunchConfigurationTemplate$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReplicationConfigurationTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReplicationConfigurationTemplate");
            DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplateResponse = (DeleteReplicationConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReplicationConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteReplicationConfigurationTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReplicationConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReplicationConfigurationTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteReplicationConfigurationTemplate$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSourceServerResponse deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSourceServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteSourceServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSourceServer");
            DeleteSourceServerResponse deleteSourceServerResponse = (DeleteSourceServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSourceServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSourceServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSourceServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSourceServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteSourceServer$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVcenterClientResponse deleteVcenterClient(DeleteVcenterClientRequest deleteVcenterClientRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVcenterClientResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteVcenterClientRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVcenterClient");
            DeleteVcenterClientResponse deleteVcenterClientResponse = (DeleteVcenterClientResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVcenterClient").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteVcenterClientRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVcenterClientRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVcenterClientResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteVcenterClient$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWaveResponse deleteWave(DeleteWaveRequest deleteWaveRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWaveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, deleteWaveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWave");
            DeleteWaveResponse deleteWaveResponse = (DeleteWaveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWave").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteWaveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWaveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWaveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$deleteWave$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobLogItemsResponse describeJobLogItems(DescribeJobLogItemsRequest describeJobLogItemsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobLogItemsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, describeJobLogItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobLogItems");
            DescribeJobLogItemsResponse describeJobLogItemsResponse = (DescribeJobLogItemsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobLogItems").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobLogItemsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobLogItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobLogItemsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$describeJobLogItems$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeJobLogItemsIterable describeJobLogItemsPaginator(DescribeJobLogItemsRequest describeJobLogItemsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeJobLogItemsIterable(this, this.applyPaginatorUserAgent(describeJobLogItemsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobsResponse describeJobs(DescribeJobsRequest describeJobsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, describeJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobs");
            DescribeJobsResponse describeJobsResponse = (DescribeJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$describeJobs$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeJobsIterable describeJobsPaginator(DescribeJobsRequest describeJobsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeJobsIterable(this, this.applyPaginatorUserAgent(describeJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLaunchConfigurationTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, describeLaunchConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLaunchConfigurationTemplates");
            DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplatesResponse = (DescribeLaunchConfigurationTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLaunchConfigurationTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLaunchConfigurationTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLaunchConfigurationTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeLaunchConfigurationTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$describeLaunchConfigurationTemplates$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeLaunchConfigurationTemplatesIterable describeLaunchConfigurationTemplatesPaginator(DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeLaunchConfigurationTemplatesIterable(this, this.applyPaginatorUserAgent(describeLaunchConfigurationTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReplicationConfigurationTemplatesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, describeReplicationConfigurationTemplatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReplicationConfigurationTemplates");
            DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplatesResponse = (DescribeReplicationConfigurationTemplatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReplicationConfigurationTemplates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeReplicationConfigurationTemplatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeReplicationConfigurationTemplatesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeReplicationConfigurationTemplatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$describeReplicationConfigurationTemplates$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeReplicationConfigurationTemplatesIterable describeReplicationConfigurationTemplatesPaginator(DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeReplicationConfigurationTemplatesIterable(this, this.applyPaginatorUserAgent(describeReplicationConfigurationTemplatesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSourceServersResponse describeSourceServers(DescribeSourceServersRequest describeSourceServersRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSourceServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, describeSourceServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSourceServers");
            DescribeSourceServersResponse describeSourceServersResponse = (DescribeSourceServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSourceServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSourceServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSourceServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeSourceServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$describeSourceServers$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeSourceServersIterable describeSourceServersPaginator(DescribeSourceServersRequest describeSourceServersRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeSourceServersIterable(this, this.applyPaginatorUserAgent(describeSourceServersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVcenterClientsResponse describeVcenterClients(DescribeVcenterClientsRequest describeVcenterClientsRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeVcenterClientsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, describeVcenterClientsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeVcenterClients");
            DescribeVcenterClientsResponse describeVcenterClientsResponse = (DescribeVcenterClientsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeVcenterClients").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeVcenterClientsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeVcenterClientsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeVcenterClientsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$describeVcenterClients$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeVcenterClientsIterable describeVcenterClientsPaginator(DescribeVcenterClientsRequest describeVcenterClientsRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeVcenterClientsIterable(this, this.applyPaginatorUserAgent(describeVcenterClientsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateApplicationsResponse disassociateApplications(DisassociateApplicationsRequest disassociateApplicationsRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, disassociateApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateApplications");
            DisassociateApplicationsResponse disassociateApplicationsResponse = (DisassociateApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$disassociateApplications$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateSourceServersResponse disassociateSourceServers(DisassociateSourceServersRequest disassociateSourceServersRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateSourceServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, disassociateSourceServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateSourceServers");
            DisassociateSourceServersResponse disassociateSourceServersResponse = (DisassociateSourceServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateSourceServers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateSourceServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateSourceServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateSourceServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$disassociateSourceServers$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisconnectFromServiceResponse disconnectFromService(DisconnectFromServiceRequest disconnectFromServiceRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectFromServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, disconnectFromServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectFromService");
            DisconnectFromServiceResponse disconnectFromServiceResponse = (DisconnectFromServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectFromService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disconnectFromServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisconnectFromServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disconnectFromServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$disconnectFromService$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FinalizeCutoverResponse finalizeCutover(FinalizeCutoverRequest finalizeCutoverRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, FinalizeCutoverResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, finalizeCutoverRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"FinalizeCutover");
            FinalizeCutoverResponse finalizeCutoverResponse = (FinalizeCutoverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("FinalizeCutover").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)finalizeCutoverRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new FinalizeCutoverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return finalizeCutoverResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$finalizeCutover$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLaunchConfigurationResponse getLaunchConfiguration(GetLaunchConfigurationRequest getLaunchConfigurationRequest) throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLaunchConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, getLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLaunchConfiguration");
            GetLaunchConfigurationResponse getLaunchConfigurationResponse = (GetLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$getLaunchConfiguration$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReplicationConfigurationResponse getReplicationConfiguration(GetReplicationConfigurationRequest getReplicationConfigurationRequest) throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, getReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReplicationConfiguration");
            GetReplicationConfigurationResponse getReplicationConfigurationResponse = (GetReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$getReplicationConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitializeServiceResponse initializeService(InitializeServiceRequest initializeServiceRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, InitializeServiceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, initializeServiceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"InitializeService");
            InitializeServiceResponse initializeServiceResponse = (InitializeServiceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("InitializeService").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)initializeServiceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new InitializeServiceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return initializeServiceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$initializeService$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listApplicationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplications");
            ListApplicationsResponse listApplicationsResponse = (ListApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listApplicationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listApplications$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return new ListApplicationsIterable(this, this.applyPaginatorUserAgent(listApplicationsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExportErrorsResponse listExportErrors(ListExportErrorsRequest listExportErrorsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportErrorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listExportErrorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExportErrors");
            ListExportErrorsResponse listExportErrorsResponse = (ListExportErrorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExportErrors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExportErrorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExportErrorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExportErrorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listExportErrors$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExportErrorsIterable listExportErrorsPaginator(ListExportErrorsRequest listExportErrorsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListExportErrorsIterable(this, this.applyPaginatorUserAgent(listExportErrorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExports");
            ListExportsResponse listExportsResponse = (ListExportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listExportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listExportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listExports$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return new ListExportsIterable(this, this.applyPaginatorUserAgent(listExportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportErrorsResponse listImportErrors(ListImportErrorsRequest listImportErrorsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportErrorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listImportErrorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportErrors");
            ListImportErrorsResponse listImportErrorsResponse = (ListImportErrorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportErrors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listImportErrorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportErrorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportErrorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listImportErrors$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListImportErrorsIterable listImportErrorsPaginator(ListImportErrorsRequest listImportErrorsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListImportErrorsIterable(this, this.applyPaginatorUserAgent(listImportErrorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            ListImportsResponse listImportsResponse = (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listImportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listImports$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListImportsIterable(this, this.applyPaginatorUserAgent(listImportsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSourceServerActionsResponse listSourceServerActions(ListSourceServerActionsRequest listSourceServerActionsRequest) throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSourceServerActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listSourceServerActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSourceServerActions");
            ListSourceServerActionsResponse listSourceServerActionsResponse = (ListSourceServerActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSourceServerActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listSourceServerActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSourceServerActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSourceServerActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listSourceServerActions$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSourceServerActionsIterable listSourceServerActionsPaginator(ListSourceServerActionsRequest listSourceServerActionsRequest) throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        return new ListSourceServerActionsIterable(this, this.applyPaginatorUserAgent(listSourceServerActionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listTagsForResource$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTemplateActionsResponse listTemplateActions(ListTemplateActionsRequest listTemplateActionsRequest) throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTemplateActionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listTemplateActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTemplateActions");
            ListTemplateActionsResponse listTemplateActionsResponse = (ListTemplateActionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTemplateActions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTemplateActionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTemplateActionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTemplateActionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listTemplateActions$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListTemplateActionsIterable listTemplateActionsPaginator(ListTemplateActionsRequest listTemplateActionsRequest) throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        return new ListTemplateActionsIterable(this, this.applyPaginatorUserAgent(listTemplateActionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWavesResponse listWaves(ListWavesRequest listWavesRequest) throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWavesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, listWavesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWaves");
            ListWavesResponse listWavesResponse = (ListWavesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWaves").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listWavesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWavesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWavesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$listWaves$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWavesIterable listWavesPaginator(ListWavesRequest listWavesRequest) throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return new ListWavesIterable(this, this.applyPaginatorUserAgent(listWavesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MarkAsArchivedResponse markAsArchived(MarkAsArchivedRequest markAsArchivedRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, MarkAsArchivedResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, markAsArchivedRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"MarkAsArchived");
            MarkAsArchivedResponse markAsArchivedResponse = (MarkAsArchivedResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("MarkAsArchived").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)markAsArchivedRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new MarkAsArchivedRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return markAsArchivedResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$markAsArchived$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutSourceServerActionResponse putSourceServerAction(PutSourceServerActionRequest putSourceServerActionRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutSourceServerActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, putSourceServerActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutSourceServerAction");
            PutSourceServerActionResponse putSourceServerActionResponse = (PutSourceServerActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutSourceServerAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putSourceServerActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutSourceServerActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putSourceServerActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$putSourceServerAction$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutTemplateActionResponse putTemplateAction(PutTemplateActionRequest putTemplateActionRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutTemplateActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, putTemplateActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutTemplateAction");
            PutTemplateActionResponse putTemplateActionResponse = (PutTemplateActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutTemplateAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putTemplateActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutTemplateActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putTemplateActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$putTemplateAction$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveSourceServerActionResponse removeSourceServerAction(RemoveSourceServerActionRequest removeSourceServerActionRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveSourceServerActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, removeSourceServerActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveSourceServerAction");
            RemoveSourceServerActionResponse removeSourceServerActionResponse = (RemoveSourceServerActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveSourceServerAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeSourceServerActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveSourceServerActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeSourceServerActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$removeSourceServerAction$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTemplateActionResponse removeTemplateAction(RemoveTemplateActionRequest removeTemplateActionRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveTemplateActionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, removeTemplateActionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTemplateAction");
            RemoveTemplateActionResponse removeTemplateActionResponse = (RemoveTemplateActionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTemplateAction").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTemplateActionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTemplateActionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return removeTemplateActionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$removeTemplateAction$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetryDataReplicationResponse retryDataReplication(RetryDataReplicationRequest retryDataReplicationRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetryDataReplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, retryDataReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RetryDataReplication");
            RetryDataReplicationResponse retryDataReplicationResponse = (RetryDataReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetryDataReplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retryDataReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RetryDataReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return retryDataReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$retryDataReplication$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartCutoverResponse startCutover(StartCutoverRequest startCutoverRequest) throws UninitializedAccountException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCutoverResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, startCutoverRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCutover");
            StartCutoverResponse startCutoverResponse = (StartCutoverResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCutover").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startCutoverRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartCutoverRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startCutoverResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$startCutover$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartExportResponse startExport(StartExportRequest startExportRequest) throws UninitializedAccountException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartExportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, startExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartExport");
            StartExportResponse startExportResponse = (StartExportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartExport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startExportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startExportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$startExport$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartImportResponse startImport(StartImportRequest startImportRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartImportResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, startImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartImport");
            StartImportResponse startImportResponse = (StartImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartImport").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$startImport$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReplicationResponse startReplication(StartReplicationRequest startReplicationRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, startReplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReplication");
            StartReplicationResponse startReplicationResponse = (StartReplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startReplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$startReplication$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartTestResponse startTest(StartTestRequest startTestRequest) throws UninitializedAccountException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartTestResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, startTestRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartTest");
            StartTestResponse startTestResponse = (StartTestResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartTest").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startTestRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartTestRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startTestResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$startTest$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$tagResource$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateTargetInstancesResponse terminateTargetInstances(TerminateTargetInstancesRequest terminateTargetInstancesRequest) throws UninitializedAccountException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TerminateTargetInstancesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, terminateTargetInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TerminateTargetInstances");
            TerminateTargetInstancesResponse terminateTargetInstancesResponse = (TerminateTargetInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TerminateTargetInstances").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateTargetInstancesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TerminateTargetInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return terminateTargetInstancesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$terminateTargetInstances$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnarchiveApplicationResponse unarchiveApplication(UnarchiveApplicationRequest unarchiveApplicationRequest) throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnarchiveApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, unarchiveApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnarchiveApplication");
            UnarchiveApplicationResponse unarchiveApplicationResponse = (UnarchiveApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnarchiveApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unarchiveApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnarchiveApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unarchiveApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$unarchiveApplication$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnarchiveWaveResponse unarchiveWave(UnarchiveWaveRequest unarchiveWaveRequest) throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UnarchiveWaveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, unarchiveWaveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UnarchiveWave");
            UnarchiveWaveResponse unarchiveWaveResponse = (UnarchiveWaveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UnarchiveWave").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)unarchiveWaveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UnarchiveWaveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return unarchiveWaveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$unarchiveWave$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$untagResource$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplication");
            UpdateApplicationResponse updateApplicationResponse = (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateApplicationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApplicationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApplicationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateApplication$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLaunchConfigurationResponse updateLaunchConfiguration(UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLaunchConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateLaunchConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLaunchConfiguration");
            UpdateLaunchConfigurationResponse updateLaunchConfigurationResponse = (UpdateLaunchConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLaunchConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLaunchConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLaunchConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLaunchConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateLaunchConfiguration$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplate(UpdateLaunchConfigurationTemplateRequest updateLaunchConfigurationTemplateRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLaunchConfigurationTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateLaunchConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLaunchConfigurationTemplate");
            UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplateResponse = (UpdateLaunchConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLaunchConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateLaunchConfigurationTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateLaunchConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateLaunchConfigurationTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateLaunchConfigurationTemplate$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReplicationConfigurationResponse updateReplicationConfiguration(UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateReplicationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationConfiguration");
            UpdateReplicationConfigurationResponse updateReplicationConfigurationResponse = (UpdateReplicationConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReplicationConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReplicationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReplicationConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateReplicationConfiguration$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateReplicationConfigurationTemplateResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateReplicationConfigurationTemplateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateReplicationConfigurationTemplate");
            UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplateResponse = (UpdateReplicationConfigurationTemplateResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateReplicationConfigurationTemplate").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateReplicationConfigurationTemplateRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateReplicationConfigurationTemplateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateReplicationConfigurationTemplateResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateReplicationConfigurationTemplate$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSourceServerReplicationTypeResponse updateSourceServerReplicationType(UpdateSourceServerReplicationTypeRequest updateSourceServerReplicationTypeRequest) throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSourceServerReplicationTypeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateSourceServerReplicationTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSourceServerReplicationType");
            UpdateSourceServerReplicationTypeResponse updateSourceServerReplicationTypeResponse = (UpdateSourceServerReplicationTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSourceServerReplicationType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateSourceServerReplicationTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateSourceServerReplicationTypeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateSourceServerReplicationTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateSourceServerReplicationType$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWaveResponse updateWave(UpdateWaveRequest updateWaveRequest) throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWaveResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultMgnClient.resolveMetricPublishers(this.clientConfiguration, updateWaveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"mgn");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWave");
            UpdateWaveResponse updateWaveResponse = (UpdateWaveResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWave").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateWaveRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWaveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWaveResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMgnClient.lambda$updateWave$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends MgnRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.40").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MgnRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "mgn";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MgnException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UninitializedAccountException").exceptionBuilderSupplier(UninitializedAccountException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    @Override
    public final MgnServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateWave$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSourceServerReplicationType$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReplicationConfigurationTemplate$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateReplicationConfiguration$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLaunchConfigurationTemplate$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLaunchConfiguration$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplication$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unarchiveWave$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$unarchiveApplication$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$terminateTargetInstances$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startTest$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReplication$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startImport$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startExport$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCutover$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$retryDataReplication$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTemplateAction$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeSourceServerAction$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putTemplateAction$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putSourceServerAction$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$markAsArchived$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWaves$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTemplateActions$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSourceServerActions$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImports$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImportErrors$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExports$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExportErrors$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplications$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$initializeService$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReplicationConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLaunchConfiguration$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$finalizeCutover$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectFromService$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateSourceServers$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateApplications$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeVcenterClients$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSourceServers$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReplicationConfigurationTemplates$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLaunchConfigurationTemplates$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobs$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobLogItems$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWave$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVcenterClient$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSourceServer$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReplicationConfigurationTemplate$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLaunchConfigurationTemplate$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteJob$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteApplication$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWave$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReplicationConfigurationTemplate$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLaunchConfigurationTemplate$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createApplication$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$changeServerLifeCycleState$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateSourceServers$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateApplications$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$archiveWave$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$archiveApplication$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

