/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Validate exception.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends MgnException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(ValidationException::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<List<ValidationExceptionField>> FIELD_LIST_FIELD = SdkField
            .<List<ValidationExceptionField>> builder(MarshallingType.LIST)
            .memberName("fieldList")
            .getter(getter(ValidationException::fieldList))
            .setter(setter(Builder::fieldList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationExceptionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationExceptionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ValidationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, FIELD_LIST_FIELD,
            REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final List<ValidationExceptionField> fieldList;

    private final String reason;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.fieldList = builder.fieldList;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Code property for this object.
     * 
     * @return The value of the Code property for this object.
     */
    public String code() {
        return code;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public boolean hasFieldList() {
        return fieldList != null && !(fieldList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Validate exception field list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldList} method.
     * </p>
     * 
     * @return Validate exception field list.
     */
    public List<ValidationExceptionField> fieldList() {
        return fieldList;
    }

    /**
     * <p>
     * Validate exception reason.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Validate exception reason.
     * @see ValidationExceptionReason
     */
    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * Validate exception reason.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Validate exception reason.
     * @see ValidationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, MgnException.Builder {
        /**
         * Sets the value of the Code property for this object.
         *
         * @param code
         *        The new value for the Code property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Validate exception field list.
         * </p>
         * 
         * @param fieldList
         *        Validate exception field list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldList(Collection<ValidationExceptionField> fieldList);

        /**
         * <p>
         * Validate exception field list.
         * </p>
         * 
         * @param fieldList
         *        Validate exception field list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldList(ValidationExceptionField... fieldList);

        /**
         * <p>
         * Validate exception field list.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ValidationExceptionField>.Builder}
         * avoiding the need to create one manually via {@link List<ValidationExceptionField>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationExceptionField>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldList(List<ValidationExceptionField>)}.
         * 
         * @param fieldList
         *        a consumer that will call methods on {@link List<ValidationExceptionField>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldList(List<ValidationExceptionField>)
         */
        Builder fieldList(Consumer<ValidationExceptionField.Builder>... fieldList);

        /**
         * <p>
         * Validate exception reason.
         * </p>
         * 
         * @param reason
         *        Validate exception reason.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Validate exception reason.
         * </p>
         * 
         * @param reason
         *        Validate exception reason.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(ValidationExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends MgnException.BuilderImpl implements Builder {
        private String code;

        private List<ValidationExceptionField> fieldList = DefaultSdkAutoConstructList.getInstance();

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            code(model.code);
            fieldList(model.fieldList);
            reason(model.reason);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final List<ValidationExceptionField.Builder> getFieldList() {
            List<ValidationExceptionField.Builder> result = ValidationExceptionFieldListCopier.copyToBuilder(this.fieldList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFieldList(Collection<ValidationExceptionField.BuilderImpl> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copyFromBuilder(fieldList);
        }

        @Override
        public final Builder fieldList(Collection<ValidationExceptionField> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copy(fieldList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(ValidationExceptionField... fieldList) {
            fieldList(Arrays.asList(fieldList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(Consumer<ValidationExceptionField.Builder>... fieldList) {
            fieldList(Stream.of(fieldList).map(c -> ValidationExceptionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
