/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Server participating in Job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParticipatingServer implements SdkPojo, Serializable,
        ToCopyableBuilder<ParticipatingServer.Builder, ParticipatingServer> {
    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchStatus").getter(getter(ParticipatingServer::launchStatusAsString))
            .setter(setter(Builder::launchStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(ParticipatingServer::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_STATUS_FIELD,
            SOURCE_SERVER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String launchStatus;

    private final String sourceServerID;

    private ParticipatingServer(BuilderImpl builder) {
        this.launchStatus = builder.launchStatus;
        this.sourceServerID = builder.sourceServerID;
    }

    /**
     * <p>
     * Participating server launch status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link LaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return Participating server launch status.
     * @see LaunchStatus
     */
    public final LaunchStatus launchStatus() {
        return LaunchStatus.fromValue(launchStatus);
    }

    /**
     * <p>
     * Participating server launch status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchStatus} will
     * return {@link LaunchStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #launchStatusAsString}.
     * </p>
     * 
     * @return Participating server launch status.
     * @see LaunchStatus
     */
    public final String launchStatusAsString() {
        return launchStatus;
    }

    /**
     * <p>
     * Participating server Source Server ID.
     * </p>
     * 
     * @return Participating server Source Server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingServer)) {
            return false;
        }
        ParticipatingServer other = (ParticipatingServer) obj;
        return Objects.equals(launchStatusAsString(), other.launchStatusAsString())
                && Objects.equals(sourceServerID(), other.sourceServerID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParticipatingServer").add("LaunchStatus", launchStatusAsString())
                .add("SourceServerID", sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "launchStatus":
            return Optional.ofNullable(clazz.cast(launchStatusAsString()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingServer, T> g) {
        return obj -> g.apply((ParticipatingServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParticipatingServer> {
        /**
         * <p>
         * Participating server launch status.
         * </p>
         * 
         * @param launchStatus
         *        Participating server launch status.
         * @see LaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStatus
         */
        Builder launchStatus(String launchStatus);

        /**
         * <p>
         * Participating server launch status.
         * </p>
         * 
         * @param launchStatus
         *        Participating server launch status.
         * @see LaunchStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchStatus
         */
        Builder launchStatus(LaunchStatus launchStatus);

        /**
         * <p>
         * Participating server Source Server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Participating server Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);
    }

    static final class BuilderImpl implements Builder {
        private String launchStatus;

        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingServer model) {
            launchStatus(model.launchStatus);
            sourceServerID(model.sourceServerID);
        }

        public final String getLaunchStatus() {
            return launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(LaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        @Override
        public ParticipatingServer build() {
            return new ParticipatingServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
