/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Job log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobLog implements SdkPojo, Serializable, ToCopyableBuilder<JobLog.Builder, JobLog> {
    private static final SdkField<String> EVENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("event")
            .getter(getter(JobLog::eventAsString)).setter(setter(Builder::event))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<JobLogEventData> EVENT_DATA_FIELD = SdkField
            .<JobLogEventData> builder(MarshallingType.SDK_POJO).memberName("eventData").getter(getter(JobLog::eventData))
            .setter(setter(Builder::eventData)).constructor(JobLogEventData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventData").build()).build();

    private static final SdkField<String> LOG_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logDateTime").getter(getter(JobLog::logDateTime)).setter(setter(Builder::logDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, EVENT_DATA_FIELD,
            LOG_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String event;

    private final JobLogEventData eventData;

    private final String logDateTime;

    private JobLog(BuilderImpl builder) {
        this.event = builder.event;
        this.eventData = builder.eventData;
        this.logDateTime = builder.logDateTime;
    }

    /**
     * <p>
     * Job log event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link JobLogEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return Job log event.
     * @see JobLogEvent
     */
    public final JobLogEvent event() {
        return JobLogEvent.fromValue(event);
    }

    /**
     * <p>
     * Job log event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #event} will return
     * {@link JobLogEvent#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #eventAsString}.
     * </p>
     * 
     * @return Job log event.
     * @see JobLogEvent
     */
    public final String eventAsString() {
        return event;
    }

    /**
     * <p>
     * Job event data
     * </p>
     * 
     * @return Job event data
     */
    public final JobLogEventData eventData() {
        return eventData;
    }

    /**
     * <p>
     * Job log event date and time.
     * </p>
     * 
     * @return Job log event date and time.
     */
    public final String logDateTime() {
        return logDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eventAsString());
        hashCode = 31 * hashCode + Objects.hashCode(eventData());
        hashCode = 31 * hashCode + Objects.hashCode(logDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLog)) {
            return false;
        }
        JobLog other = (JobLog) obj;
        return Objects.equals(eventAsString(), other.eventAsString()) && Objects.equals(eventData(), other.eventData())
                && Objects.equals(logDateTime(), other.logDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobLog").add("Event", eventAsString()).add("EventData", eventData())
                .add("LogDateTime", logDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "event":
            return Optional.ofNullable(clazz.cast(eventAsString()));
        case "eventData":
            return Optional.ofNullable(clazz.cast(eventData()));
        case "logDateTime":
            return Optional.ofNullable(clazz.cast(logDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobLog, T> g) {
        return obj -> g.apply((JobLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobLog> {
        /**
         * <p>
         * Job log event.
         * </p>
         * 
         * @param event
         *        Job log event.
         * @see JobLogEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobLogEvent
         */
        Builder event(String event);

        /**
         * <p>
         * Job log event.
         * </p>
         * 
         * @param event
         *        Job log event.
         * @see JobLogEvent
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobLogEvent
         */
        Builder event(JobLogEvent event);

        /**
         * <p>
         * Job event data
         * </p>
         * 
         * @param eventData
         *        Job event data
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventData(JobLogEventData eventData);

        /**
         * <p>
         * Job event data
         * </p>
         * This is a convenience method that creates an instance of the {@link JobLogEventData.Builder} avoiding the
         * need to create one manually via {@link JobLogEventData#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobLogEventData.Builder#build()} is called immediately and its
         * result is passed to {@link #eventData(JobLogEventData)}.
         * 
         * @param eventData
         *        a consumer that will call methods on {@link JobLogEventData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventData(JobLogEventData)
         */
        default Builder eventData(Consumer<JobLogEventData.Builder> eventData) {
            return eventData(JobLogEventData.builder().applyMutation(eventData).build());
        }

        /**
         * <p>
         * Job log event date and time.
         * </p>
         * 
         * @param logDateTime
         *        Job log event date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logDateTime(String logDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String event;

        private JobLogEventData eventData;

        private String logDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLog model) {
            event(model.event);
            eventData(model.eventData);
            logDateTime(model.logDateTime);
        }

        public final String getEvent() {
            return event;
        }

        public final void setEvent(String event) {
            this.event = event;
        }

        @Override
        public final Builder event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public final Builder event(JobLogEvent event) {
            this.event(event == null ? null : event.toString());
            return this;
        }

        public final JobLogEventData.Builder getEventData() {
            return eventData != null ? eventData.toBuilder() : null;
        }

        public final void setEventData(JobLogEventData.BuilderImpl eventData) {
            this.eventData = eventData != null ? eventData.build() : null;
        }

        @Override
        public final Builder eventData(JobLogEventData eventData) {
            this.eventData = eventData;
            return this;
        }

        public final String getLogDateTime() {
            return logDateTime;
        }

        public final void setLogDateTime(String logDateTime) {
            this.logDateTime = logDateTime;
        }

        @Override
        public final Builder logDateTime(String logDateTime) {
            this.logDateTime = logDateTime;
            return this;
        }

        @Override
        public JobLog build() {
            return new JobLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
