/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchConfigurationResponse extends MgnResponse implements
        ToCopyableBuilder<GetLaunchConfigurationResponse.Builder, GetLaunchConfigurationResponse> {
    private static final SdkField<String> BOOT_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("bootMode").getter(getter(GetLaunchConfigurationResponse::bootModeAsString))
            .setter(setter(Builder::bootMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bootMode").build()).build();

    private static final SdkField<Boolean> COPY_PRIVATE_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyPrivateIp").getter(getter(GetLaunchConfigurationResponse::copyPrivateIp))
            .setter(setter(Builder::copyPrivateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyPrivateIp").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("copyTags").getter(getter(GetLaunchConfigurationResponse::copyTags)).setter(setter(Builder::copyTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyTags").build()).build();

    private static final SdkField<String> EC2_LAUNCH_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2LaunchTemplateID").getter(getter(GetLaunchConfigurationResponse::ec2LaunchTemplateID))
            .setter(setter(Builder::ec2LaunchTemplateID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2LaunchTemplateID").build())
            .build();

    private static final SdkField<String> LAUNCH_DISPOSITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchDisposition").getter(getter(GetLaunchConfigurationResponse::launchDispositionAsString))
            .setter(setter(Builder::launchDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchDisposition").build()).build();

    private static final SdkField<Licensing> LICENSING_FIELD = SdkField.<Licensing> builder(MarshallingType.SDK_POJO)
            .memberName("licensing").getter(getter(GetLaunchConfigurationResponse::licensing)).setter(setter(Builder::licensing))
            .constructor(Licensing::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licensing").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetLaunchConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(GetLaunchConfigurationResponse::sourceServerID))
            .setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceTypeRightSizingMethod")
            .getter(getter(GetLaunchConfigurationResponse::targetInstanceTypeRightSizingMethodAsString))
            .setter(setter(Builder::targetInstanceTypeRightSizingMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("targetInstanceTypeRightSizingMethod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOT_MODE_FIELD,
            COPY_PRIVATE_IP_FIELD, COPY_TAGS_FIELD, EC2_LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_DISPOSITION_FIELD, LICENSING_FIELD,
            NAME_FIELD, SOURCE_SERVER_ID_FIELD, TARGET_INSTANCE_TYPE_RIGHT_SIZING_METHOD_FIELD));

    private final String bootMode;

    private final Boolean copyPrivateIp;

    private final Boolean copyTags;

    private final String ec2LaunchTemplateID;

    private final String launchDisposition;

    private final Licensing licensing;

    private final String name;

    private final String sourceServerID;

    private final String targetInstanceTypeRightSizingMethod;

    private GetLaunchConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.bootMode = builder.bootMode;
        this.copyPrivateIp = builder.copyPrivateIp;
        this.copyTags = builder.copyTags;
        this.ec2LaunchTemplateID = builder.ec2LaunchTemplateID;
        this.launchDisposition = builder.launchDisposition;
        this.licensing = builder.licensing;
        this.name = builder.name;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceTypeRightSizingMethod = builder.targetInstanceTypeRightSizingMethod;
    }

    /**
     * <p>
     * Launch configuration boot mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Launch configuration boot mode.
     * @see BootMode
     */
    public final BootMode bootMode() {
        return BootMode.fromValue(bootMode);
    }

    /**
     * <p>
     * Launch configuration boot mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #bootMode} will
     * return {@link BootMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #bootModeAsString}.
     * </p>
     * 
     * @return Launch configuration boot mode.
     * @see BootMode
     */
    public final String bootModeAsString() {
        return bootMode;
    }

    /**
     * <p>
     * Copy Private IP during Launch Configuration.
     * </p>
     * 
     * @return Copy Private IP during Launch Configuration.
     */
    public final Boolean copyPrivateIp() {
        return copyPrivateIp;
    }

    /**
     * <p>
     * Copy Tags during Launch Configuration.
     * </p>
     * 
     * @return Copy Tags during Launch Configuration.
     */
    public final Boolean copyTags() {
        return copyTags;
    }

    /**
     * <p>
     * Launch configuration EC2 Launch template ID.
     * </p>
     * 
     * @return Launch configuration EC2 Launch template ID.
     */
    public final String ec2LaunchTemplateID() {
        return ec2LaunchTemplateID;
    }

    /**
     * <p>
     * Launch disposition for launch configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition for launch configuration.
     * @see LaunchDisposition
     */
    public final LaunchDisposition launchDisposition() {
        return LaunchDisposition.fromValue(launchDisposition);
    }

    /**
     * <p>
     * Launch disposition for launch configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #launchDisposition}
     * will return {@link LaunchDisposition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #launchDispositionAsString}.
     * </p>
     * 
     * @return Launch disposition for launch configuration.
     * @see LaunchDisposition
     */
    public final String launchDispositionAsString() {
        return launchDisposition;
    }

    /**
     * <p>
     * Launch configuration OS licensing.
     * </p>
     * 
     * @return Launch configuration OS licensing.
     */
    public final Licensing licensing() {
        return licensing;
    }

    /**
     * <p>
     * Launch configuration name.
     * </p>
     * 
     * @return Launch configuration name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Launch configuration Source Server ID.
     * </p>
     * 
     * @return Launch configuration Source Server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * Launch configuration Target instance type right sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Launch configuration Target instance type right sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod() {
        return TargetInstanceTypeRightSizingMethod.fromValue(targetInstanceTypeRightSizingMethod);
    }

    /**
     * <p>
     * Launch configuration Target instance type right sizing method.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetInstanceTypeRightSizingMethod} will return
     * {@link TargetInstanceTypeRightSizingMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetInstanceTypeRightSizingMethodAsString}.
     * </p>
     * 
     * @return Launch configuration Target instance type right sizing method.
     * @see TargetInstanceTypeRightSizingMethod
     */
    public final String targetInstanceTypeRightSizingMethodAsString() {
        return targetInstanceTypeRightSizingMethod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bootModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(copyPrivateIp());
        hashCode = 31 * hashCode + Objects.hashCode(copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(ec2LaunchTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(launchDispositionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(licensing());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceTypeRightSizingMethodAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchConfigurationResponse)) {
            return false;
        }
        GetLaunchConfigurationResponse other = (GetLaunchConfigurationResponse) obj;
        return Objects.equals(bootModeAsString(), other.bootModeAsString())
                && Objects.equals(copyPrivateIp(), other.copyPrivateIp())
                && Objects.equals(copyTags(), other.copyTags())
                && Objects.equals(ec2LaunchTemplateID(), other.ec2LaunchTemplateID())
                && Objects.equals(launchDispositionAsString(), other.launchDispositionAsString())
                && Objects.equals(licensing(), other.licensing())
                && Objects.equals(name(), other.name())
                && Objects.equals(sourceServerID(), other.sourceServerID())
                && Objects.equals(targetInstanceTypeRightSizingMethodAsString(),
                        other.targetInstanceTypeRightSizingMethodAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLaunchConfigurationResponse").add("BootMode", bootModeAsString())
                .add("CopyPrivateIp", copyPrivateIp()).add("CopyTags", copyTags())
                .add("Ec2LaunchTemplateID", ec2LaunchTemplateID()).add("LaunchDisposition", launchDispositionAsString())
                .add("Licensing", licensing()).add("Name", name()).add("SourceServerID", sourceServerID())
                .add("TargetInstanceTypeRightSizingMethod", targetInstanceTypeRightSizingMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "bootMode":
            return Optional.ofNullable(clazz.cast(bootModeAsString()));
        case "copyPrivateIp":
            return Optional.ofNullable(clazz.cast(copyPrivateIp()));
        case "copyTags":
            return Optional.ofNullable(clazz.cast(copyTags()));
        case "ec2LaunchTemplateID":
            return Optional.ofNullable(clazz.cast(ec2LaunchTemplateID()));
        case "launchDisposition":
            return Optional.ofNullable(clazz.cast(launchDispositionAsString()));
        case "licensing":
            return Optional.ofNullable(clazz.cast(licensing()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "targetInstanceTypeRightSizingMethod":
            return Optional.ofNullable(clazz.cast(targetInstanceTypeRightSizingMethodAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchConfigurationResponse, T> g) {
        return obj -> g.apply((GetLaunchConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MgnResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLaunchConfigurationResponse> {
        /**
         * <p>
         * Launch configuration boot mode.
         * </p>
         * 
         * @param bootMode
         *        Launch configuration boot mode.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(String bootMode);

        /**
         * <p>
         * Launch configuration boot mode.
         * </p>
         * 
         * @param bootMode
         *        Launch configuration boot mode.
         * @see BootMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BootMode
         */
        Builder bootMode(BootMode bootMode);

        /**
         * <p>
         * Copy Private IP during Launch Configuration.
         * </p>
         * 
         * @param copyPrivateIp
         *        Copy Private IP during Launch Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyPrivateIp(Boolean copyPrivateIp);

        /**
         * <p>
         * Copy Tags during Launch Configuration.
         * </p>
         * 
         * @param copyTags
         *        Copy Tags during Launch Configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTags(Boolean copyTags);

        /**
         * <p>
         * Launch configuration EC2 Launch template ID.
         * </p>
         * 
         * @param ec2LaunchTemplateID
         *        Launch configuration EC2 Launch template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2LaunchTemplateID(String ec2LaunchTemplateID);

        /**
         * <p>
         * Launch disposition for launch configuration.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition for launch configuration.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(String launchDisposition);

        /**
         * <p>
         * Launch disposition for launch configuration.
         * </p>
         * 
         * @param launchDisposition
         *        Launch disposition for launch configuration.
         * @see LaunchDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LaunchDisposition
         */
        Builder launchDisposition(LaunchDisposition launchDisposition);

        /**
         * <p>
         * Launch configuration OS licensing.
         * </p>
         * 
         * @param licensing
         *        Launch configuration OS licensing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licensing(Licensing licensing);

        /**
         * <p>
         * Launch configuration OS licensing.
         * </p>
         * This is a convenience method that creates an instance of the {@link Licensing.Builder} avoiding the need to
         * create one manually via {@link Licensing#builder()}.
         *
         * When the {@link Consumer} completes, {@link Licensing.Builder#build()} is called immediately and its result
         * is passed to {@link #licensing(Licensing)}.
         * 
         * @param licensing
         *        a consumer that will call methods on {@link Licensing.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #licensing(Licensing)
         */
        default Builder licensing(Consumer<Licensing.Builder> licensing) {
            return licensing(Licensing.builder().applyMutation(licensing).build());
        }

        /**
         * <p>
         * Launch configuration name.
         * </p>
         * 
         * @param name
         *        Launch configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Launch configuration Source Server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Launch configuration Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Launch configuration Target instance type right sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Launch configuration Target instance type right sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod);

        /**
         * <p>
         * Launch configuration Target instance type right sizing method.
         * </p>
         * 
         * @param targetInstanceTypeRightSizingMethod
         *        Launch configuration Target instance type right sizing method.
         * @see TargetInstanceTypeRightSizingMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetInstanceTypeRightSizingMethod
         */
        Builder targetInstanceTypeRightSizingMethod(TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod);
    }

    static final class BuilderImpl extends MgnResponse.BuilderImpl implements Builder {
        private String bootMode;

        private Boolean copyPrivateIp;

        private Boolean copyTags;

        private String ec2LaunchTemplateID;

        private String launchDisposition;

        private Licensing licensing;

        private String name;

        private String sourceServerID;

        private String targetInstanceTypeRightSizingMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchConfigurationResponse model) {
            super(model);
            bootMode(model.bootMode);
            copyPrivateIp(model.copyPrivateIp);
            copyTags(model.copyTags);
            ec2LaunchTemplateID(model.ec2LaunchTemplateID);
            launchDisposition(model.launchDisposition);
            licensing(model.licensing);
            name(model.name);
            sourceServerID(model.sourceServerID);
            targetInstanceTypeRightSizingMethod(model.targetInstanceTypeRightSizingMethod);
        }

        public final String getBootMode() {
            return bootMode;
        }

        public final void setBootMode(String bootMode) {
            this.bootMode = bootMode;
        }

        @Override
        public final Builder bootMode(String bootMode) {
            this.bootMode = bootMode;
            return this;
        }

        @Override
        public final Builder bootMode(BootMode bootMode) {
            this.bootMode(bootMode == null ? null : bootMode.toString());
            return this;
        }

        public final Boolean getCopyPrivateIp() {
            return copyPrivateIp;
        }

        public final void setCopyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
        }

        @Override
        public final Builder copyPrivateIp(Boolean copyPrivateIp) {
            this.copyPrivateIp = copyPrivateIp;
            return this;
        }

        public final Boolean getCopyTags() {
            return copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final String getEc2LaunchTemplateID() {
            return ec2LaunchTemplateID;
        }

        public final void setEc2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
        }

        @Override
        public final Builder ec2LaunchTemplateID(String ec2LaunchTemplateID) {
            this.ec2LaunchTemplateID = ec2LaunchTemplateID;
            return this;
        }

        public final String getLaunchDisposition() {
            return launchDisposition;
        }

        public final void setLaunchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
        }

        @Override
        public final Builder launchDisposition(String launchDisposition) {
            this.launchDisposition = launchDisposition;
            return this;
        }

        @Override
        public final Builder launchDisposition(LaunchDisposition launchDisposition) {
            this.launchDisposition(launchDisposition == null ? null : launchDisposition.toString());
            return this;
        }

        public final Licensing.Builder getLicensing() {
            return licensing != null ? licensing.toBuilder() : null;
        }

        public final void setLicensing(Licensing.BuilderImpl licensing) {
            this.licensing = licensing != null ? licensing.build() : null;
        }

        @Override
        public final Builder licensing(Licensing licensing) {
            this.licensing = licensing;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceTypeRightSizingMethod() {
            return targetInstanceTypeRightSizingMethod;
        }

        public final void setTargetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(String targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod;
            return this;
        }

        @Override
        public final Builder targetInstanceTypeRightSizingMethod(
                TargetInstanceTypeRightSizingMethod targetInstanceTypeRightSizingMethod) {
            this.targetInstanceTypeRightSizingMethod(targetInstanceTypeRightSizingMethod == null ? null
                    : targetInstanceTypeRightSizingMethod.toString());
            return this;
        }

        @Override
        public GetLaunchConfigurationResponse build() {
            return new GetLaunchConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
