/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Request to describe Job log filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobsRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<DescribeJobsRequestFilters.Builder, DescribeJobsRequestFilters> {
    private static final SdkField<String> FROM_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fromDate").getter(getter(DescribeJobsRequestFilters::fromDate)).setter(setter(Builder::fromDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromDate").build()).build();

    private static final SdkField<List<String>> JOB_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("jobIDs")
            .getter(getter(DescribeJobsRequestFilters::jobIDs))
            .setter(setter(Builder::jobIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TO_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("toDate")
            .getter(getter(DescribeJobsRequestFilters::toDate)).setter(setter(Builder::toDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_DATE_FIELD,
            JOB_I_DS_FIELD, TO_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fromDate;

    private final List<String> jobIDs;

    private final String toDate;

    private DescribeJobsRequestFilters(BuilderImpl builder) {
        this.fromDate = builder.fromDate;
        this.jobIDs = builder.jobIDs;
        this.toDate = builder.toDate;
    }

    /**
     * <p>
     * Request to describe Job log filters by date.
     * </p>
     * 
     * @return Request to describe Job log filters by date.
     */
    public final String fromDate() {
        return fromDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobIDs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasJobIDs() {
        return jobIDs != null && !(jobIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to describe Job log filters by job ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobIDs} method.
     * </p>
     * 
     * @return Request to describe Job log filters by job ID.
     */
    public final List<String> jobIDs() {
        return jobIDs;
    }

    /**
     * <p>
     * Request to describe job log items by last date.
     * </p>
     * 
     * @return Request to describe job log items by last date.
     */
    public final String toDate() {
        return toDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fromDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasJobIDs() ? jobIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(toDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsRequestFilters)) {
            return false;
        }
        DescribeJobsRequestFilters other = (DescribeJobsRequestFilters) obj;
        return Objects.equals(fromDate(), other.fromDate()) && hasJobIDs() == other.hasJobIDs()
                && Objects.equals(jobIDs(), other.jobIDs()) && Objects.equals(toDate(), other.toDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobsRequestFilters").add("FromDate", fromDate())
                .add("JobIDs", hasJobIDs() ? jobIDs() : null).add("ToDate", toDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fromDate":
            return Optional.ofNullable(clazz.cast(fromDate()));
        case "jobIDs":
            return Optional.ofNullable(clazz.cast(jobIDs()));
        case "toDate":
            return Optional.ofNullable(clazz.cast(toDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobsRequestFilters, T> g) {
        return obj -> g.apply((DescribeJobsRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribeJobsRequestFilters> {
        /**
         * <p>
         * Request to describe Job log filters by date.
         * </p>
         * 
         * @param fromDate
         *        Request to describe Job log filters by date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromDate(String fromDate);

        /**
         * <p>
         * Request to describe Job log filters by job ID.
         * </p>
         * 
         * @param jobIDs
         *        Request to describe Job log filters by job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIDs(Collection<String> jobIDs);

        /**
         * <p>
         * Request to describe Job log filters by job ID.
         * </p>
         * 
         * @param jobIDs
         *        Request to describe Job log filters by job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobIDs(String... jobIDs);

        /**
         * <p>
         * Request to describe job log items by last date.
         * </p>
         * 
         * @param toDate
         *        Request to describe job log items by last date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toDate(String toDate);
    }

    static final class BuilderImpl implements Builder {
        private String fromDate;

        private List<String> jobIDs = DefaultSdkAutoConstructList.getInstance();

        private String toDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsRequestFilters model) {
            fromDate(model.fromDate);
            jobIDs(model.jobIDs);
            toDate(model.toDate);
        }

        public final String getFromDate() {
            return fromDate;
        }

        public final void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        @Override
        public final Builder fromDate(String fromDate) {
            this.fromDate = fromDate;
            return this;
        }

        public final Collection<String> getJobIDs() {
            if (jobIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return jobIDs;
        }

        public final void setJobIDs(Collection<String> jobIDs) {
            this.jobIDs = DescribeJobsRequestFiltersJobIDsCopier.copy(jobIDs);
        }

        @Override
        public final Builder jobIDs(Collection<String> jobIDs) {
            this.jobIDs = DescribeJobsRequestFiltersJobIDsCopier.copy(jobIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobIDs(String... jobIDs) {
            jobIDs(Arrays.asList(jobIDs));
            return this;
        }

        public final String getToDate() {
            return toDate;
        }

        public final void setToDate(String toDate) {
            this.toDate = toDate;
        }

        @Override
        public final Builder toDate(String toDate) {
            this.toDate = toDate;
            return this;
        }

        @Override
        public DescribeJobsRequestFilters build() {
            return new DescribeJobsRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
