/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Data replication initiation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataReplicationInitiation implements SdkPojo, Serializable,
        ToCopyableBuilder<DataReplicationInitiation.Builder, DataReplicationInitiation> {
    private static final SdkField<String> NEXT_ATTEMPT_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextAttemptDateTime").getter(getter(DataReplicationInitiation::nextAttemptDateTime))
            .setter(setter(Builder::nextAttemptDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextAttemptDateTime").build())
            .build();

    private static final SdkField<String> START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startDateTime").getter(getter(DataReplicationInitiation::startDateTime))
            .setter(setter(Builder::startDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()).build();

    private static final SdkField<List<DataReplicationInitiationStep>> STEPS_FIELD = SdkField
            .<List<DataReplicationInitiationStep>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(DataReplicationInitiation::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataReplicationInitiationStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataReplicationInitiationStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_ATTEMPT_DATE_TIME_FIELD,
            START_DATE_TIME_FIELD, STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextAttemptDateTime;

    private final String startDateTime;

    private final List<DataReplicationInitiationStep> steps;

    private DataReplicationInitiation(BuilderImpl builder) {
        this.nextAttemptDateTime = builder.nextAttemptDateTime;
        this.startDateTime = builder.startDateTime;
        this.steps = builder.steps;
    }

    /**
     * <p>
     * Request to query next data initiation date and time.
     * </p>
     * 
     * @return Request to query next data initiation date and time.
     */
    public final String nextAttemptDateTime() {
        return nextAttemptDateTime;
    }

    /**
     * <p>
     * Request to query data initiation start date and time.
     * </p>
     * 
     * @return Request to query data initiation start date and time.
     */
    public final String startDateTime() {
        return startDateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Request to query data initiation steps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return Request to query data initiation steps.
     */
    public final List<DataReplicationInitiationStep> steps() {
        return steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextAttemptDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationInitiation)) {
            return false;
        }
        DataReplicationInitiation other = (DataReplicationInitiation) obj;
        return Objects.equals(nextAttemptDateTime(), other.nextAttemptDateTime())
                && Objects.equals(startDateTime(), other.startDateTime()) && hasSteps() == other.hasSteps()
                && Objects.equals(steps(), other.steps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataReplicationInitiation").add("NextAttemptDateTime", nextAttemptDateTime())
                .add("StartDateTime", startDateTime()).add("Steps", hasSteps() ? steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextAttemptDateTime":
            return Optional.ofNullable(clazz.cast(nextAttemptDateTime()));
        case "startDateTime":
            return Optional.ofNullable(clazz.cast(startDateTime()));
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationInitiation, T> g) {
        return obj -> g.apply((DataReplicationInitiation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataReplicationInitiation> {
        /**
         * <p>
         * Request to query next data initiation date and time.
         * </p>
         * 
         * @param nextAttemptDateTime
         *        Request to query next data initiation date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextAttemptDateTime(String nextAttemptDateTime);

        /**
         * <p>
         * Request to query data initiation start date and time.
         * </p>
         * 
         * @param startDateTime
         *        Request to query data initiation start date and time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDateTime(String startDateTime);

        /**
         * <p>
         * Request to query data initiation steps.
         * </p>
         * 
         * @param steps
         *        Request to query data initiation steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<DataReplicationInitiationStep> steps);

        /**
         * <p>
         * Request to query data initiation steps.
         * </p>
         * 
         * @param steps
         *        Request to query data initiation steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(DataReplicationInitiationStep... steps);

        /**
         * <p>
         * Request to query data initiation steps.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DataReplicationInitiationStep>.Builder} avoiding the need to create one manually via {@link List
         * <DataReplicationInitiationStep>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataReplicationInitiationStep>.Builder#build()} is called
         * immediately and its result is passed to {@link #steps(List<DataReplicationInitiationStep>)}.
         * 
         * @param steps
         *        a consumer that will call methods on {@link List<DataReplicationInitiationStep>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(List<DataReplicationInitiationStep>)
         */
        Builder steps(Consumer<DataReplicationInitiationStep.Builder>... steps);
    }

    static final class BuilderImpl implements Builder {
        private String nextAttemptDateTime;

        private String startDateTime;

        private List<DataReplicationInitiationStep> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationInitiation model) {
            nextAttemptDateTime(model.nextAttemptDateTime);
            startDateTime(model.startDateTime);
            steps(model.steps);
        }

        public final String getNextAttemptDateTime() {
            return nextAttemptDateTime;
        }

        public final void setNextAttemptDateTime(String nextAttemptDateTime) {
            this.nextAttemptDateTime = nextAttemptDateTime;
        }

        @Override
        public final Builder nextAttemptDateTime(String nextAttemptDateTime) {
            this.nextAttemptDateTime = nextAttemptDateTime;
            return this;
        }

        public final String getStartDateTime() {
            return startDateTime;
        }

        public final void setStartDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(String startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final List<DataReplicationInitiationStep.Builder> getSteps() {
            List<DataReplicationInitiationStep.Builder> result = DataReplicationInitiationStepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<DataReplicationInitiationStep.BuilderImpl> steps) {
            this.steps = DataReplicationInitiationStepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<DataReplicationInitiationStep> steps) {
            this.steps = DataReplicationInitiationStepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(DataReplicationInitiationStep... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<DataReplicationInitiationStep.Builder>... steps) {
            steps(Stream.of(steps).map(c -> DataReplicationInitiationStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DataReplicationInitiation build() {
            return new DataReplicationInitiation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
