/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateResponse;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteJobRequest;
import software.amazon.awssdk.services.mgn.model.DeleteJobResponse;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceResponse;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverResponse;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.InitializeServiceRequest;
import software.amazon.awssdk.services.mgn.model.InitializeServiceResponse;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedResponse;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartCutoverRequest;
import software.amazon.awssdk.services.mgn.model.StartCutoverResponse;
import software.amazon.awssdk.services.mgn.model.StartReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StartReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartTestRequest;
import software.amazon.awssdk.services.mgn.model.StartTestResponse;
import software.amazon.awssdk.services.mgn.model.TagResourceRequest;
import software.amazon.awssdk.services.mgn.model.TagResourceResponse;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse;
import software.amazon.awssdk.services.mgn.model.UntagResourceRequest;
import software.amazon.awssdk.services.mgn.model.UntagResourceResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeResponse;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher;

/**
 * Service client for accessing mgn asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Application Migration Service service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MgnAsyncClient extends SdkClient {
    String SERVICE_NAME = "mgn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mgn";

    /**
     * Create a {@link MgnAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MgnAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MgnAsyncClient}.
     */
    static MgnAsyncClientBuilder builder() {
        return new DefaultMgnAsyncClientBuilder();
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     * @return A Java Future containing the result of the ChangeServerLifeCycleState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ChangeServerLifeCycleStateResponse> changeServerLifeCycleState(
            ChangeServerLifeCycleStateRequest changeServerLifeCycleStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangeServerLifeCycleStateRequest.Builder} avoiding
     * the need to create one manually via {@link ChangeServerLifeCycleStateRequest#builder()}
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     *        A {@link Consumer} that will call methods on {@link ChangeServerLifeCycleStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ChangeServerLifeCycleState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ChangeServerLifeCycleStateResponse> changeServerLifeCycleState(
            Consumer<ChangeServerLifeCycleStateRequest.Builder> changeServerLifeCycleStateRequest) {
        return changeServerLifeCycleState(ChangeServerLifeCycleStateRequest.builder()
                .applyMutation(changeServerLifeCycleStateRequest).build());
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     * @return A Java Future containing the result of the CreateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationConfigurationTemplateResponse> createReplicationConfigurationTemplate(
            CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationConfigurationTemplateResponse> createReplicationConfigurationTemplate(
            Consumer<CreateReplicationConfigurationTemplateRequest.Builder> createReplicationConfigurationTemplateRequest) {
        return createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(createReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     *
     * @param deleteJobRequest
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     * @return A Java Future containing the result of the DeleteReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationConfigurationTemplateResponse> deleteReplicationConfigurationTemplate(
            DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationConfigurationTemplateResponse> deleteReplicationConfigurationTemplate(
            Consumer<DeleteReplicationConfigurationTemplateRequest.Builder> deleteReplicationConfigurationTemplateRequest) {
        return deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest.builder()
                .applyMutation(deleteReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     *
     * @param deleteSourceServerRequest
     * @return A Java Future containing the result of the DeleteSourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSourceServerResponse> deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSourceServerRequest#builder()}
     * </p>
     *
     * @param deleteSourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSourceServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSourceServerResponse> deleteSourceServer(
            Consumer<DeleteSourceServerRequest.Builder> deleteSourceServerRequest) {
        return deleteSourceServer(DeleteSourceServerRequest.builder().applyMutation(deleteSourceServerRequest).build());
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     *
     * @param deleteVcenterClientRequest
     * @return A Java Future containing the result of the DeleteVcenterClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVcenterClientResponse> deleteVcenterClient(
            DeleteVcenterClientRequest deleteVcenterClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVcenterClientRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVcenterClientRequest#builder()}
     * </p>
     *
     * @param deleteVcenterClientRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVcenterClientRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVcenterClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVcenterClientResponse> deleteVcenterClient(
            Consumer<DeleteVcenterClientRequest.Builder> deleteVcenterClientRequest) {
        return deleteVcenterClient(DeleteVcenterClientRequest.builder().applyMutation(deleteVcenterClientRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return A Java Future containing the result of the DescribeJobLogItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobLogItemsResponse> describeJobLogItems(
            DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeJobLogItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobLogItemsResponse> describeJobLogItems(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) {
        return describeJobLogItems(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsPublisher describeJobLogItemsPaginator(DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsPublisher describeJobLogItemsPaginator(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) {
        return describeJobLogItemsPaginator(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     *
     * @param describeJobsRequest
     * @return A Java Future containing the result of the DescribeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobsResponse> describeJobs(DescribeJobsRequest describeJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobsResponse> describeJobs(Consumer<DescribeJobsRequest.Builder> describeJobsRequest) {
        return describeJobs(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsPublisher describeJobsPaginator(DescribeJobsRequest describeJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsPublisher describeJobsPaginator(Consumer<DescribeJobsRequest.Builder> describeJobsRequest) {
        return describeJobsPaginator(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return A Java Future containing the result of the DescribeReplicationConfigurationTemplates operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationConfigurationTemplatesResponse> describeReplicationConfigurationTemplates(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeReplicationConfigurationTemplates operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationConfigurationTemplatesResponse> describeReplicationConfigurationTemplates(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest) {
        return describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesPublisher describeReplicationConfigurationTemplatesPaginator(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesPublisher describeReplicationConfigurationTemplatesPaginator(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest) {
        return describeReplicationConfigurationTemplatesPaginator(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     *
     * @param describeSourceServersRequest
     * @return A Java Future containing the result of the DescribeSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSourceServersResponse> describeSourceServers(
            DescribeSourceServersRequest describeSourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSourceServersResponse> describeSourceServers(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) {
        return describeSourceServers(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest).build());
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSourceServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersPublisher describeSourceServersPaginator(
            DescribeSourceServersRequest describeSourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersPublisher describeSourceServersPaginator(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) {
        return describeSourceServersPaginator(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return A Java Future containing the result of the DescribeVcenterClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVcenterClientsResponse> describeVcenterClients(
            DescribeVcenterClientsRequest describeVcenterClientsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVcenterClientsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVcenterClientsRequest#builder()}
     * </p>
     *
     * @param describeVcenterClientsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVcenterClientsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVcenterClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVcenterClientsResponse> describeVcenterClients(
            Consumer<DescribeVcenterClientsRequest.Builder> describeVcenterClientsRequest) {
        return describeVcenterClients(DescribeVcenterClientsRequest.builder().applyMutation(describeVcenterClientsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsPublisher describeVcenterClientsPaginator(
            DescribeVcenterClientsRequest describeVcenterClientsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVcenterClientsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVcenterClientsRequest#builder()}
     * </p>
     *
     * @param describeVcenterClientsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVcenterClientsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsPublisher describeVcenterClientsPaginator(
            Consumer<DescribeVcenterClientsRequest.Builder> describeVcenterClientsRequest) {
        return describeVcenterClientsPaginator(DescribeVcenterClientsRequest.builder()
                .applyMutation(describeVcenterClientsRequest).build());
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param disconnectFromServiceRequest
     * @return A Java Future containing the result of the DisconnectFromService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisconnectFromServiceResponse> disconnectFromService(
            DisconnectFromServiceRequest disconnectFromServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectFromServiceRequest.Builder} avoiding the
     * need to create one manually via {@link DisconnectFromServiceRequest#builder()}
     * </p>
     *
     * @param disconnectFromServiceRequest
     *        A {@link Consumer} that will call methods on {@link DisconnectFromServiceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisconnectFromService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisconnectFromServiceResponse> disconnectFromService(
            Consumer<DisconnectFromServiceRequest.Builder> disconnectFromServiceRequest) {
        return disconnectFromService(DisconnectFromServiceRequest.builder().applyMutation(disconnectFromServiceRequest).build());
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param finalizeCutoverRequest
     * @return A Java Future containing the result of the FinalizeCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FinalizeCutoverResponse> finalizeCutover(FinalizeCutoverRequest finalizeCutoverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FinalizeCutoverRequest.Builder} avoiding the need
     * to create one manually via {@link FinalizeCutoverRequest#builder()}
     * </p>
     *
     * @param finalizeCutoverRequest
     *        A {@link Consumer} that will call methods on {@link FinalizeCutoverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the FinalizeCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FinalizeCutoverResponse> finalizeCutover(
            Consumer<FinalizeCutoverRequest.Builder> finalizeCutoverRequest) {
        return finalizeCutover(FinalizeCutoverRequest.builder().applyMutation(finalizeCutoverRequest).build());
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     *
     * @param getLaunchConfigurationRequest
     * @return A Java Future containing the result of the GetLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLaunchConfigurationResponse> getLaunchConfiguration(
            GetLaunchConfigurationRequest getLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param getLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLaunchConfigurationResponse> getLaunchConfiguration(
            Consumer<GetLaunchConfigurationRequest.Builder> getLaunchConfigurationRequest) {
        return getLaunchConfiguration(GetLaunchConfigurationRequest.builder().applyMutation(getLaunchConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     *
     * @param getReplicationConfigurationRequest
     * @return A Java Future containing the result of the GetReplicationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReplicationConfigurationResponse> getReplicationConfiguration(
            GetReplicationConfigurationRequest getReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetReplicationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReplicationConfigurationResponse> getReplicationConfiguration(
            Consumer<GetReplicationConfigurationRequest.Builder> getReplicationConfigurationRequest) {
        return getReplicationConfiguration(GetReplicationConfigurationRequest.builder()
                .applyMutation(getReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     *
     * @param initializeServiceRequest
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitializeServiceResponse> initializeService(InitializeServiceRequest initializeServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitializeServiceRequest.Builder} avoiding the need
     * to create one manually via {@link InitializeServiceRequest#builder()}
     * </p>
     *
     * @param initializeServiceRequest
     *        A {@link Consumer} that will call methods on {@link InitializeServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitializeServiceResponse> initializeService(
            Consumer<InitializeServiceRequest.Builder> initializeServiceRequest) {
        return initializeService(InitializeServiceRequest.builder().applyMutation(initializeServiceRequest).build());
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     *
     * @param markAsArchivedRequest
     * @return A Java Future containing the result of the MarkAsArchived operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MarkAsArchivedResponse> markAsArchived(MarkAsArchivedRequest markAsArchivedRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MarkAsArchivedRequest.Builder} avoiding the need to
     * create one manually via {@link MarkAsArchivedRequest#builder()}
     * </p>
     *
     * @param markAsArchivedRequest
     *        A {@link Consumer} that will call methods on {@link MarkAsArchivedRequest.Builder} to create a request.
     * @return A Java Future containing the result of the MarkAsArchived operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MarkAsArchivedResponse> markAsArchived(Consumer<MarkAsArchivedRequest.Builder> markAsArchivedRequest) {
        return markAsArchived(MarkAsArchivedRequest.builder().applyMutation(markAsArchivedRequest).build());
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     *
     * @param retryDataReplicationRequest
     * @return A Java Future containing the result of the RetryDataReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryDataReplicationResponse> retryDataReplication(
            RetryDataReplicationRequest retryDataReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryDataReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RetryDataReplicationRequest#builder()}
     * </p>
     *
     * @param retryDataReplicationRequest
     *        A {@link Consumer} that will call methods on {@link RetryDataReplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RetryDataReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryDataReplicationResponse> retryDataReplication(
            Consumer<RetryDataReplicationRequest.Builder> retryDataReplicationRequest) {
        return retryDataReplication(RetryDataReplicationRequest.builder().applyMutation(retryDataReplicationRequest).build());
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     *
     * @param startCutoverRequest
     * @return A Java Future containing the result of the StartCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartCutoverResponse> startCutover(StartCutoverRequest startCutoverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCutoverRequest.Builder} avoiding the need to
     * create one manually via {@link StartCutoverRequest#builder()}
     * </p>
     *
     * @param startCutoverRequest
     *        A {@link Consumer} that will call methods on {@link StartCutoverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartCutoverResponse> startCutover(Consumer<StartCutoverRequest.Builder> startCutoverRequest) {
        return startCutover(StartCutoverRequest.builder().applyMutation(startCutoverRequest).build());
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     *
     * @param startReplicationRequest
     * @return A Java Future containing the result of the StartReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationResponse> startReplication(StartReplicationRequest startReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartReplicationRequest#builder()}
     * </p>
     *
     * @param startReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationResponse> startReplication(
            Consumer<StartReplicationRequest.Builder> startReplicationRequest) {
        return startReplication(StartReplicationRequest.builder().applyMutation(startReplicationRequest).build());
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     *
     * @param startTestRequest
     * @return A Java Future containing the result of the StartTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTestResponse> startTest(StartTestRequest startTestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTestRequest.Builder} avoiding the need to
     * create one manually via {@link StartTestRequest#builder()}
     * </p>
     *
     * @param startTestRequest
     *        A {@link Consumer} that will call methods on {@link StartTestRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTestResponse> startTest(Consumer<StartTestRequest.Builder> startTestRequest) {
        return startTest(StartTestRequest.builder().applyMutation(startTestRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     *
     * @param terminateTargetInstancesRequest
     * @return A Java Future containing the result of the TerminateTargetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TerminateTargetInstancesResponse> terminateTargetInstances(
            TerminateTargetInstancesRequest terminateTargetInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateTargetInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link TerminateTargetInstancesRequest#builder()}
     * </p>
     *
     * @param terminateTargetInstancesRequest
     *        A {@link Consumer} that will call methods on {@link TerminateTargetInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TerminateTargetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TerminateTargetInstancesResponse> terminateTargetInstances(
            Consumer<TerminateTargetInstancesRequest.Builder> terminateTargetInstancesRequest) {
        return terminateTargetInstances(TerminateTargetInstancesRequest.builder().applyMutation(terminateTargetInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     * @return A Java Future containing the result of the UpdateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchConfigurationResponse> updateLaunchConfiguration(
            UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchConfigurationResponse> updateLaunchConfiguration(
            Consumer<UpdateLaunchConfigurationRequest.Builder> updateLaunchConfigurationRequest) {
        return updateLaunchConfiguration(UpdateLaunchConfigurationRequest.builder()
                .applyMutation(updateLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     * @return A Java Future containing the result of the UpdateReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationResponse> updateReplicationConfiguration(
            UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationResponse> updateReplicationConfiguration(
            Consumer<UpdateReplicationConfigurationRequest.Builder> updateReplicationConfigurationRequest) {
        return updateReplicationConfiguration(UpdateReplicationConfigurationRequest.builder()
                .applyMutation(updateReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     * @return A Java Future containing the result of the UpdateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationTemplateResponse> updateReplicationConfigurationTemplate(
            UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationTemplateResponse> updateReplicationConfigurationTemplate(
            Consumer<UpdateReplicationConfigurationTemplateRequest.Builder> updateReplicationConfigurationTemplateRequest) {
        return updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(updateReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     * @return A Java Future containing the result of the UpdateSourceServerReplicationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSourceServerReplicationTypeResponse> updateSourceServerReplicationType(
            UpdateSourceServerReplicationTypeRequest updateSourceServerReplicationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSourceServerReplicationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSourceServerReplicationTypeRequest#builder()}
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSourceServerReplicationTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSourceServerReplicationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSourceServerReplicationTypeResponse> updateSourceServerReplicationType(
            Consumer<UpdateSourceServerReplicationTypeRequest.Builder> updateSourceServerReplicationTypeRequest) {
        return updateSourceServerReplicationType(UpdateSourceServerReplicationTypeRequest.builder()
                .applyMutation(updateSourceServerReplicationTypeRequest).build());
    }
}
