/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.memorydb.DefaultMemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.DefaultMemoryDbBaseClientBuilder;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClientBuilder;
import software.amazon.awssdk.services.memorydb.MemoryDbServiceClientConfiguration;
import software.amazon.awssdk.services.memorydb.endpoints.MemoryDbEndpointProvider;

@SdkInternalApi
final class DefaultMemoryDbAsyncClientBuilder
extends DefaultMemoryDbBaseClientBuilder<MemoryDbAsyncClientBuilder, MemoryDbAsyncClient>
implements MemoryDbAsyncClientBuilder {
    DefaultMemoryDbAsyncClientBuilder() {
    }

    @Override
    public DefaultMemoryDbAsyncClientBuilder endpointProvider(MemoryDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MemoryDbAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMemoryDbAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MemoryDbServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMemoryDbAsyncClient client = new DefaultMemoryDbAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MemoryDbServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MemoryDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

