/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediapackagevod.model.EgressAccessLogs;
import software.amazon.awssdk.services.mediapackagevod.model.MediaPackageVodRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigureLogsRequest
extends MediaPackageVodRequest
implements ToCopyableBuilder<Builder, ConfigureLogsRequest> {
    private static final SdkField<EgressAccessLogs> EGRESS_ACCESS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EgressAccessLogs").getter(ConfigureLogsRequest.getter(ConfigureLogsRequest::egressAccessLogs)).setter(ConfigureLogsRequest.setter(Builder::egressAccessLogs)).constructor(EgressAccessLogs::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("egressAccessLogs").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ConfigureLogsRequest.getter(ConfigureLogsRequest::id)).setter(ConfigureLogsRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EGRESS_ACCESS_LOGS_FIELD, ID_FIELD));
    private final EgressAccessLogs egressAccessLogs;
    private final String id;

    private ConfigureLogsRequest(BuilderImpl builder) {
        super(builder);
        this.egressAccessLogs = builder.egressAccessLogs;
        this.id = builder.id;
    }

    public final EgressAccessLogs egressAccessLogs() {
        return this.egressAccessLogs;
    }

    public final String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.egressAccessLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsRequest)) {
            return false;
        }
        ConfigureLogsRequest other = (ConfigureLogsRequest)((Object)obj);
        return Objects.equals(this.egressAccessLogs(), other.egressAccessLogs()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigureLogsRequest").add("EgressAccessLogs", (Object)this.egressAccessLogs()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EgressAccessLogs": {
                return Optional.ofNullable(clazz.cast(this.egressAccessLogs()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsRequest, T> g) {
        return obj -> g.apply((ConfigureLogsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaPackageVodRequest.BuilderImpl
    implements Builder {
        private EgressAccessLogs egressAccessLogs;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsRequest model) {
            super(model);
            this.egressAccessLogs(model.egressAccessLogs);
            this.id(model.id);
        }

        public final EgressAccessLogs.Builder getEgressAccessLogs() {
            return this.egressAccessLogs != null ? this.egressAccessLogs.toBuilder() : null;
        }

        public final void setEgressAccessLogs(EgressAccessLogs.BuilderImpl egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs != null ? egressAccessLogs.build() : null;
        }

        @Override
        public final Builder egressAccessLogs(EgressAccessLogs egressAccessLogs) {
            this.egressAccessLogs = egressAccessLogs;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ConfigureLogsRequest build() {
            return new ConfigureLogsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaPackageVodRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ConfigureLogsRequest> {
        public Builder egressAccessLogs(EgressAccessLogs var1);

        default public Builder egressAccessLogs(Consumer<EgressAccessLogs.Builder> egressAccessLogs) {
            return this.egressAccessLogs((EgressAccessLogs)((EgressAccessLogs.Builder)EgressAccessLogs.builder().applyMutation(egressAccessLogs)).build());
        }

        public Builder id(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

