/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackagevod.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediapackagevod.model.HlsEncryption;
import software.amazon.awssdk.services.mediapackagevod.model.HlsManifest;
import software.amazon.awssdk.services.mediapackagevod.model.___listOfHlsManifestCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsPackage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsPackage> {
    private static final SdkField<HlsEncryption> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(HlsPackage.getter(HlsPackage::encryption)).setter(HlsPackage.setter(Builder::encryption)).constructor(HlsEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<List<HlsManifest>> HLS_MANIFESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HlsManifests").getter(HlsPackage.getter(HlsPackage::hlsManifests)).setter(HlsPackage.setter(Builder::hlsManifests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsManifests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HlsManifest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> SEGMENT_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SegmentDurationSeconds").getter(HlsPackage.getter(HlsPackage::segmentDurationSeconds)).setter(HlsPackage.setter(Builder::segmentDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentDurationSeconds").build()}).build();
    private static final SdkField<Boolean> USE_AUDIO_RENDITION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseAudioRenditionGroup").getter(HlsPackage.getter(HlsPackage::useAudioRenditionGroup)).setter(HlsPackage.setter(Builder::useAudioRenditionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("useAudioRenditionGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD, HLS_MANIFESTS_FIELD, SEGMENT_DURATION_SECONDS_FIELD, USE_AUDIO_RENDITION_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final HlsEncryption encryption;
    private final List<HlsManifest> hlsManifests;
    private final Integer segmentDurationSeconds;
    private final Boolean useAudioRenditionGroup;

    private HlsPackage(BuilderImpl builder) {
        this.encryption = builder.encryption;
        this.hlsManifests = builder.hlsManifests;
        this.segmentDurationSeconds = builder.segmentDurationSeconds;
        this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
    }

    public final HlsEncryption encryption() {
        return this.encryption;
    }

    public final boolean hasHlsManifests() {
        return this.hlsManifests != null && !(this.hlsManifests instanceof SdkAutoConstructList);
    }

    public final List<HlsManifest> hlsManifests() {
        return this.hlsManifests;
    }

    public final Integer segmentDurationSeconds() {
        return this.segmentDurationSeconds;
    }

    public final Boolean useAudioRenditionGroup() {
        return this.useAudioRenditionGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHlsManifests() ? this.hlsManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.useAudioRenditionGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPackage)) {
            return false;
        }
        HlsPackage other = (HlsPackage)obj;
        return Objects.equals(this.encryption(), other.encryption()) && this.hasHlsManifests() == other.hasHlsManifests() && Objects.equals(this.hlsManifests(), other.hlsManifests()) && Objects.equals(this.segmentDurationSeconds(), other.segmentDurationSeconds()) && Objects.equals(this.useAudioRenditionGroup(), other.useAudioRenditionGroup());
    }

    public final String toString() {
        return ToString.builder((String)"HlsPackage").add("Encryption", (Object)this.encryption()).add("HlsManifests", this.hasHlsManifests() ? this.hlsManifests() : null).add("SegmentDurationSeconds", (Object)this.segmentDurationSeconds()).add("UseAudioRenditionGroup", (Object)this.useAudioRenditionGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "HlsManifests": {
                return Optional.ofNullable(clazz.cast(this.hlsManifests()));
            }
            case "SegmentDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.segmentDurationSeconds()));
            }
            case "UseAudioRenditionGroup": {
                return Optional.ofNullable(clazz.cast(this.useAudioRenditionGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsPackage, T> g) {
        return obj -> g.apply((HlsPackage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private HlsEncryption encryption;
        private List<HlsManifest> hlsManifests = DefaultSdkAutoConstructList.getInstance();
        private Integer segmentDurationSeconds;
        private Boolean useAudioRenditionGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPackage model) {
            this.encryption(model.encryption);
            this.hlsManifests(model.hlsManifests);
            this.segmentDurationSeconds(model.segmentDurationSeconds);
            this.useAudioRenditionGroup(model.useAudioRenditionGroup);
        }

        public final HlsEncryption.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(HlsEncryption encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(HlsEncryption.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final List<HlsManifest.Builder> getHlsManifests() {
            List<HlsManifest.Builder> result = ___listOfHlsManifestCopier.copyToBuilder(this.hlsManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder hlsManifests(Collection<HlsManifest> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copy(hlsManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(HlsManifest ... hlsManifests) {
            this.hlsManifests(Arrays.asList(hlsManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hlsManifests(Consumer<HlsManifest.Builder> ... hlsManifests) {
            this.hlsManifests(Stream.of(hlsManifests).map(c -> (HlsManifest)((HlsManifest.Builder)HlsManifest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHlsManifests(Collection<HlsManifest.BuilderImpl> hlsManifests) {
            this.hlsManifests = ___listOfHlsManifestCopier.copyFromBuilder(hlsManifests);
        }

        public final Integer getSegmentDurationSeconds() {
            return this.segmentDurationSeconds;
        }

        @Override
        public final Builder segmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
            return this;
        }

        public final void setSegmentDurationSeconds(Integer segmentDurationSeconds) {
            this.segmentDurationSeconds = segmentDurationSeconds;
        }

        public final Boolean getUseAudioRenditionGroup() {
            return this.useAudioRenditionGroup;
        }

        @Override
        public final Builder useAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
            return this;
        }

        public final void setUseAudioRenditionGroup(Boolean useAudioRenditionGroup) {
            this.useAudioRenditionGroup = useAudioRenditionGroup;
        }

        public HlsPackage build() {
            return new HlsPackage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsPackage> {
        public Builder encryption(HlsEncryption var1);

        default public Builder encryption(Consumer<HlsEncryption.Builder> encryption) {
            return this.encryption((HlsEncryption)((HlsEncryption.Builder)HlsEncryption.builder().applyMutation(encryption)).build());
        }

        public Builder hlsManifests(Collection<HlsManifest> var1);

        public Builder hlsManifests(HlsManifest ... var1);

        public Builder hlsManifests(Consumer<HlsManifest.Builder> ... var1);

        public Builder segmentDurationSeconds(Integer var1);

        public Builder useAudioRenditionGroup(Boolean var1);
    }
}

