/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties of the member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberConfiguration.Builder, MemberConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MemberConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<MemberFrameworkConfiguration> FRAMEWORK_CONFIGURATION_FIELD = SdkField
            .<MemberFrameworkConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(MemberConfiguration::frameworkConfiguration)).setter(setter(Builder::frameworkConfiguration))
            .constructor(MemberFrameworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            FRAMEWORK_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final MemberFrameworkConfiguration frameworkConfiguration;

    private MemberConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.frameworkConfiguration = builder.frameworkConfiguration;
    }

    /**
     * <p>
     * The name of the member.
     * </p>
     * 
     * @return The name of the member.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An optional description of the member.
     * </p>
     * 
     * @return An optional description of the member.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * Configuration properties of the blockchain framework relevant to the member.
     * </p>
     * 
     * @return Configuration properties of the blockchain framework relevant to the member.
     */
    public MemberFrameworkConfiguration frameworkConfiguration() {
        return frameworkConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberConfiguration)) {
            return false;
        }
        MemberConfiguration other = (MemberConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(frameworkConfiguration(), other.frameworkConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MemberConfiguration").add("Name", name()).add("Description", description())
                .add("FrameworkConfiguration", frameworkConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FrameworkConfiguration":
            return Optional.ofNullable(clazz.cast(frameworkConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberConfiguration, T> g) {
        return obj -> g.apply((MemberConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberConfiguration> {
        /**
         * <p>
         * The name of the member.
         * </p>
         * 
         * @param name
         *        The name of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description of the member.
         * </p>
         * 
         * @param description
         *        An optional description of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configuration properties of the blockchain framework relevant to the member.
         * </p>
         * 
         * @param frameworkConfiguration
         *        Configuration properties of the blockchain framework relevant to the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkConfiguration(MemberFrameworkConfiguration frameworkConfiguration);

        /**
         * <p>
         * Configuration properties of the blockchain framework relevant to the member.
         * </p>
         * This is a convenience that creates an instance of the {@link MemberFrameworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link MemberFrameworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemberFrameworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #frameworkConfiguration(MemberFrameworkConfiguration)}.
         * 
         * @param frameworkConfiguration
         *        a consumer that will call methods on {@link MemberFrameworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkConfiguration(MemberFrameworkConfiguration)
         */
        default Builder frameworkConfiguration(Consumer<MemberFrameworkConfiguration.Builder> frameworkConfiguration) {
            return frameworkConfiguration(MemberFrameworkConfiguration.builder().applyMutation(frameworkConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private MemberFrameworkConfiguration frameworkConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberConfiguration model) {
            name(model.name);
            description(model.description);
            frameworkConfiguration(model.frameworkConfiguration);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final MemberFrameworkConfiguration.Builder getFrameworkConfiguration() {
            return frameworkConfiguration != null ? frameworkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder frameworkConfiguration(MemberFrameworkConfiguration frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration;
            return this;
        }

        public final void setFrameworkConfiguration(MemberFrameworkConfiguration.BuilderImpl frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration != null ? frameworkConfiguration.build() : null;
        }

        @Override
        public MemberConfiguration build() {
            return new MemberConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
