/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProposalVotesResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<ListProposalVotesResponse.Builder, ListProposalVotesResponse> {
    private static final SdkField<List<VoteSummary>> PROPOSAL_VOTES_FIELD = SdkField
            .<List<VoteSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListProposalVotesResponse::proposalVotes))
            .setter(setter(Builder::proposalVotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalVotes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VoteSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(VoteSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProposalVotesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_VOTES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<VoteSummary> proposalVotes;

    private final String nextToken;

    private ListProposalVotesResponse(BuilderImpl builder) {
        super(builder);
        this.proposalVotes = builder.proposalVotes;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The listing of votes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The listing of votes.
     */
    public List<VoteSummary> proposalVotes() {
        return proposalVotes;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proposalVotes());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProposalVotesResponse)) {
            return false;
        }
        ListProposalVotesResponse other = (ListProposalVotesResponse) obj;
        return Objects.equals(proposalVotes(), other.proposalVotes()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProposalVotesResponse").add("ProposalVotes", proposalVotes()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProposalVotes":
            return Optional.ofNullable(clazz.cast(proposalVotes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProposalVotesResponse, T> g) {
        return obj -> g.apply((ListProposalVotesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListProposalVotesResponse> {
        /**
         * <p>
         * The listing of votes.
         * </p>
         * 
         * @param proposalVotes
         *        The listing of votes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalVotes(Collection<VoteSummary> proposalVotes);

        /**
         * <p>
         * The listing of votes.
         * </p>
         * 
         * @param proposalVotes
         *        The listing of votes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalVotes(VoteSummary... proposalVotes);

        /**
         * <p>
         * The listing of votes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VoteSummary>.Builder} avoiding the need to
         * create one manually via {@link List<VoteSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VoteSummary>.Builder#build()} is called immediately and its
         * result is passed to {@link #proposalVotes(List<VoteSummary>)}.
         * 
         * @param proposalVotes
         *        a consumer that will call methods on {@link List<VoteSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposalVotes(List<VoteSummary>)
         */
        Builder proposalVotes(Consumer<VoteSummary.Builder>... proposalVotes);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private List<VoteSummary> proposalVotes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProposalVotesResponse model) {
            super(model);
            proposalVotes(model.proposalVotes);
            nextToken(model.nextToken);
        }

        public final Collection<VoteSummary.Builder> getProposalVotes() {
            return proposalVotes != null ? proposalVotes.stream().map(VoteSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder proposalVotes(Collection<VoteSummary> proposalVotes) {
            this.proposalVotes = ProposalVoteListCopier.copy(proposalVotes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposalVotes(VoteSummary... proposalVotes) {
            proposalVotes(Arrays.asList(proposalVotes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposalVotes(Consumer<VoteSummary.Builder>... proposalVotes) {
            proposalVotes(Stream.of(proposalVotes).map(c -> VoteSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProposalVotes(Collection<VoteSummary.BuilderImpl> proposalVotes) {
            this.proposalVotes = ProposalVoteListCopier.copyFromBuilder(proposalVotes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProposalVotesResponse build() {
            return new ListProposalVotesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
