/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AccessorNetworkType {
    ETHEREUM_GOERLI("ETHEREUM_GOERLI"),
    ETHEREUM_MAINNET("ETHEREUM_MAINNET"),
    ETHEREUM_MAINNET_AND_GOERLI("ETHEREUM_MAINNET_AND_GOERLI"),
    POLYGON_MAINNET("POLYGON_MAINNET"),
    POLYGON_MUMBAI("POLYGON_MUMBAI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AccessorNetworkType> VALUE_MAP;
    private final String value;

    private AccessorNetworkType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessorNetworkType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessorNetworkType> knownValues() {
        EnumSet<AccessorNetworkType> knownValues = EnumSet.allOf(AccessorNetworkType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AccessorNetworkType.class, AccessorNetworkType::toString);
    }
}

