/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse;

public class ListProposalsIterable
implements SdkIterable<ListProposalsResponse> {
    private final ManagedBlockchainClient client;
    private final ListProposalsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProposalsIterable(ManagedBlockchainClient client, ListProposalsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProposalsResponseFetcher();
    }

    public Iterator<ListProposalsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProposalsResponseFetcher
    implements SyncPageFetcher<ListProposalsResponse> {
        private ListProposalsResponseFetcher() {
        }

        public boolean hasNextPage(ListProposalsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProposalsResponse nextPage(ListProposalsResponse previousPage) {
            if (previousPage == null) {
                return ListProposalsIterable.this.client.listProposals(ListProposalsIterable.this.firstRequest);
            }
            return ListProposalsIterable.this.client.listProposals((ListProposalsRequest)((Object)ListProposalsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

