/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse;

public class ListProposalVotesIterable
implements SdkIterable<ListProposalVotesResponse> {
    private final ManagedBlockchainClient client;
    private final ListProposalVotesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListProposalVotesIterable(ManagedBlockchainClient client, ListProposalVotesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListProposalVotesResponseFetcher();
    }

    public Iterator<ListProposalVotesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListProposalVotesResponseFetcher
    implements SyncPageFetcher<ListProposalVotesResponse> {
        private ListProposalVotesResponseFetcher() {
        }

        public boolean hasNextPage(ListProposalVotesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListProposalVotesResponse nextPage(ListProposalVotesResponse previousPage) {
            if (previousPage == null) {
                return ListProposalVotesIterable.this.client.listProposalVotes(ListProposalVotesIterable.this.firstRequest);
            }
            return ListProposalVotesIterable.this.client.listProposalVotes((ListProposalVotesRequest)((Object)ListProposalVotesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

