/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessorResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<CreateAccessorResponse.Builder, CreateAccessorResponse> {
    private static final SdkField<String> ACCESSOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessorId").getter(getter(CreateAccessorResponse::accessorId)).setter(setter(Builder::accessorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessorId").build()).build();

    private static final SdkField<String> BILLING_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BillingToken").getter(getter(CreateAccessorResponse::billingToken))
            .setter(setter(Builder::billingToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_ID_FIELD,
            BILLING_TOKEN_FIELD));

    private final String accessorId;

    private final String billingToken;

    private CreateAccessorResponse(BuilderImpl builder) {
        super(builder);
        this.accessorId = builder.accessorId;
        this.billingToken = builder.billingToken;
    }

    /**
     * <p>
     * The unique identifier of the accessor.
     * </p>
     * 
     * @return The unique identifier of the accessor.
     */
    public final String accessorId() {
        return accessorId;
    }

    /**
     * <p>
     * The billing token is a property of the Accessor. Use this token to make Ethereum API calls to your Ethereum node.
     * The billing token is used to track your accessor object for billing Ethereum API requests made to your Ethereum
     * nodes.
     * </p>
     * 
     * @return The billing token is a property of the Accessor. Use this token to make Ethereum API calls to your
     *         Ethereum node. The billing token is used to track your accessor object for billing Ethereum API requests
     *         made to your Ethereum nodes.
     */
    public final String billingToken() {
        return billingToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessorId());
        hashCode = 31 * hashCode + Objects.hashCode(billingToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessorResponse)) {
            return false;
        }
        CreateAccessorResponse other = (CreateAccessorResponse) obj;
        return Objects.equals(accessorId(), other.accessorId()) && Objects.equals(billingToken(), other.billingToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessorResponse").add("AccessorId", accessorId()).add("BillingToken", billingToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessorId":
            return Optional.ofNullable(clazz.cast(accessorId()));
        case "BillingToken":
            return Optional.ofNullable(clazz.cast(billingToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessorResponse, T> g) {
        return obj -> g.apply((CreateAccessorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessorResponse> {
        /**
         * <p>
         * The unique identifier of the accessor.
         * </p>
         * 
         * @param accessorId
         *        The unique identifier of the accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessorId(String accessorId);

        /**
         * <p>
         * The billing token is a property of the Accessor. Use this token to make Ethereum API calls to your Ethereum
         * node. The billing token is used to track your accessor object for billing Ethereum API requests made to your
         * Ethereum nodes.
         * </p>
         * 
         * @param billingToken
         *        The billing token is a property of the Accessor. Use this token to make Ethereum API calls to your
         *        Ethereum node. The billing token is used to track your accessor object for billing Ethereum API
         *        requests made to your Ethereum nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingToken(String billingToken);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private String accessorId;

        private String billingToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessorResponse model) {
            super(model);
            accessorId(model.accessorId);
            billingToken(model.billingToken);
        }

        public final String getAccessorId() {
            return accessorId;
        }

        public final void setAccessorId(String accessorId) {
            this.accessorId = accessorId;
        }

        @Override
        public final Builder accessorId(String accessorId) {
            this.accessorId = accessorId;
            return this;
        }

        public final String getBillingToken() {
            return billingToken;
        }

        public final void setBillingToken(String billingToken) {
            this.billingToken = billingToken;
        }

        @Override
        public final Builder billingToken(String billingToken) {
            this.billingToken = billingToken;
            return this;
        }

        @Override
        public CreateAccessorResponse build() {
            return new CreateAccessorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
