/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNetworksRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<ListNetworksRequest.Builder, ListNetworksRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ListNetworksRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framework").getter(getter(ListNetworksRequest::frameworkAsString)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("framework").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListNetworksRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListNetworksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNetworksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FRAMEWORK_FIELD,
            STATUS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String name;

    private final String framework;

    private final String status;

    private final Integer maxResults;

    private final String nextToken;

    private ListNetworksRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.framework = builder.framework;
        this.status = builder.status;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the network.
     * </p>
     * 
     * @return The name of the network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional framework specifier. If provided, only networks of this framework type are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return An optional framework specifier. If provided, only networks of this framework type are listed.
     * @see Framework
     */
    public final Framework framework() {
        return Framework.fromValue(framework);
    }

    /**
     * <p>
     * An optional framework specifier. If provided, only networks of this framework type are listed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return An optional framework specifier. If provided, only networks of this framework type are listed.
     * @see Framework
     */
    public final String frameworkAsString() {
        return framework;
    }

    /**
     * <p>
     * An optional status specifier. If provided, only networks currently in this status are listed.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An optional status specifier. If provided, only networks currently in this status are listed.</p>
     *         <p>
     *         Applies only to Hyperledger Fabric.
     * @see NetworkStatus
     */
    public final NetworkStatus status() {
        return NetworkStatus.fromValue(status);
    }

    /**
     * <p>
     * An optional status specifier. If provided, only networks currently in this status are listed.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return An optional status specifier. If provided, only networks currently in this status are listed.</p>
     *         <p>
     *         Applies only to Hyperledger Fabric.
     * @see NetworkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The maximum number of networks to list.
     * </p>
     * 
     * @return The maximum number of networks to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworksRequest)) {
            return false;
        }
        ListNetworksRequest other = (ListNetworksRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(frameworkAsString(), other.frameworkAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNetworksRequest").add("Name", name()).add("Framework", frameworkAsString())
                .add("Status", statusAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(frameworkAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworksRequest, T> g) {
        return obj -> g.apply((ListNetworksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListNetworksRequest> {
        /**
         * <p>
         * The name of the network.
         * </p>
         * 
         * @param name
         *        The name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional framework specifier. If provided, only networks of this framework type are listed.
         * </p>
         * 
         * @param framework
         *        An optional framework specifier. If provided, only networks of this framework type are listed.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(String framework);

        /**
         * <p>
         * An optional framework specifier. If provided, only networks of this framework type are listed.
         * </p>
         * 
         * @param framework
         *        An optional framework specifier. If provided, only networks of this framework type are listed.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(Framework framework);

        /**
         * <p>
         * An optional status specifier. If provided, only networks currently in this status are listed.
         * </p>
         * <p>
         * Applies only to Hyperledger Fabric.
         * </p>
         * 
         * @param status
         *        An optional status specifier. If provided, only networks currently in this status are listed.</p>
         *        <p>
         *        Applies only to Hyperledger Fabric.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * An optional status specifier. If provided, only networks currently in this status are listed.
         * </p>
         * <p>
         * Applies only to Hyperledger Fabric.
         * </p>
         * 
         * @param status
         *        An optional status specifier. If provided, only networks currently in this status are listed.</p>
         *        <p>
         *        Applies only to Hyperledger Fabric.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(NetworkStatus status);

        /**
         * <p>
         * The maximum number of networks to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of networks to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String name;

        private String framework;

        private String status;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworksRequest model) {
            super(model);
            name(model.name);
            framework(model.framework);
            status(model.status);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNetworksRequest build() {
            return new ListNetworksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
