/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <important>
 * <p>
 * The token based access feature is in preview release for Ethereum on Amazon Managed Blockchain and is subject to
 * change. We recommend that you use this feature only with test scenarios, and not in production environments.
 * </p>
 * </important>
 * <p>
 * A summary of accessor properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessorSummary implements SdkPojo, Serializable, ToCopyableBuilder<AccessorSummary.Builder, AccessorSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AccessorSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AccessorSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AccessorSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(AccessorSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AccessorSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            STATUS_FIELD, CREATION_DATE_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String status;

    private final Instant creationDate;

    private final String arn;

    private AccessorSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The unique identifier of the accessor.
     * </p>
     * 
     * @return The unique identifier of the accessor.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the accessor.
     * </p>
     * <note>
     * <p>
     * Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the accessor.</p> <note>
     *         <p>
     *         Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
     *         </p>
     * @see AccessorType
     */
    public final AccessorType type() {
        return AccessorType.fromValue(type);
    }

    /**
     * <p>
     * The type of the accessor.
     * </p>
     * <note>
     * <p>
     * Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AccessorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the accessor.</p> <note>
     *         <p>
     *         Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
     *         </p>
     * @see AccessorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The current status of the accessor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the accessor.
     * @see AccessorStatus
     */
    public final AccessorStatus status() {
        return AccessorStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the accessor.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AccessorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the accessor.
     * @see AccessorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation date and time of the accessor.
     * </p>
     * 
     * @return The creation date and time of the accessor.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessorSummary)) {
            return false;
        }
        AccessorSummary other = (AccessorSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessorSummary").add("Id", id()).add("Type", typeAsString()).add("Status", statusAsString())
                .add("CreationDate", creationDate()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessorSummary, T> g) {
        return obj -> g.apply((AccessorSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessorSummary> {
        /**
         * <p>
         * The unique identifier of the accessor.
         * </p>
         * 
         * @param id
         *        The unique identifier of the accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the accessor.
         * </p>
         * <note>
         * <p>
         * Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of the accessor.</p> <note>
         *        <p>
         *        Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
         *        </p>
         * @see AccessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the accessor.
         * </p>
         * <note>
         * <p>
         * Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
         * </p>
         * </note>
         * 
         * @param type
         *        The type of the accessor.</p> <note>
         *        <p>
         *        Currently accessor type is restricted to <code>BILLING_TOKEN</code>.
         *        </p>
         * @see AccessorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorType
         */
        Builder type(AccessorType type);

        /**
         * <p>
         * The current status of the accessor.
         * </p>
         * 
         * @param status
         *        The current status of the accessor.
         * @see AccessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the accessor.
         * </p>
         * 
         * @param status
         *        The current status of the accessor.
         * @see AccessorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessorStatus
         */
        Builder status(AccessorStatus status);

        /**
         * <p>
         * The creation date and time of the accessor.
         * </p>
         * 
         * @param creationDate
         *        The creation date and time of the accessor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see
         *        <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String status;

        private Instant creationDate;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessorSummary model) {
            id(model.id);
            type(model.type);
            status(model.status);
            creationDate(model.creationDate);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AccessorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AccessorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public AccessorSummary build() {
            return new AccessorSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
