/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed
 * Blockchain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeLogPublishingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeLogPublishingConfiguration.Builder, NodeLogPublishingConfiguration> {
    private static final SdkField<NodeFabricLogPublishingConfiguration> FABRIC_FIELD = SdkField
            .<NodeFabricLogPublishingConfiguration> builder(MarshallingType.SDK_POJO).memberName("Fabric")
            .getter(getter(NodeLogPublishingConfiguration::fabric)).setter(setter(Builder::fabric))
            .constructor(NodeFabricLogPublishingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final NodeFabricLogPublishingConfiguration fabric;

    private NodeLogPublishingConfiguration(BuilderImpl builder) {
        this.fabric = builder.fabric;
    }

    /**
     * <p>
     * Configuration properties for logging events associated with a node that is owned by a member of a Managed
     * Blockchain network using the Hyperledger Fabric framework.
     * </p>
     * 
     * @return Configuration properties for logging events associated with a node that is owned by a member of a Managed
     *         Blockchain network using the Hyperledger Fabric framework.
     */
    public final NodeFabricLogPublishingConfiguration fabric() {
        return fabric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fabric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeLogPublishingConfiguration)) {
            return false;
        }
        NodeLogPublishingConfiguration other = (NodeLogPublishingConfiguration) obj;
        return Objects.equals(fabric(), other.fabric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeLogPublishingConfiguration").add("Fabric", fabric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fabric":
            return Optional.ofNullable(clazz.cast(fabric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeLogPublishingConfiguration, T> g) {
        return obj -> g.apply((NodeLogPublishingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeLogPublishingConfiguration> {
        /**
         * <p>
         * Configuration properties for logging events associated with a node that is owned by a member of a Managed
         * Blockchain network using the Hyperledger Fabric framework.
         * </p>
         * 
         * @param fabric
         *        Configuration properties for logging events associated with a node that is owned by a member of a
         *        Managed Blockchain network using the Hyperledger Fabric framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fabric(NodeFabricLogPublishingConfiguration fabric);

        /**
         * <p>
         * Configuration properties for logging events associated with a node that is owned by a member of a Managed
         * Blockchain network using the Hyperledger Fabric framework.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link NodeFabricLogPublishingConfiguration.Builder} avoiding the need to create one manually via
         * {@link NodeFabricLogPublishingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeFabricLogPublishingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #fabric(NodeFabricLogPublishingConfiguration)}.
         * 
         * @param fabric
         *        a consumer that will call methods on {@link NodeFabricLogPublishingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fabric(NodeFabricLogPublishingConfiguration)
         */
        default Builder fabric(Consumer<NodeFabricLogPublishingConfiguration.Builder> fabric) {
            return fabric(NodeFabricLogPublishingConfiguration.builder().applyMutation(fabric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NodeFabricLogPublishingConfiguration fabric;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeLogPublishingConfiguration model) {
            fabric(model.fabric);
        }

        public final NodeFabricLogPublishingConfiguration.Builder getFabric() {
            return fabric != null ? fabric.toBuilder() : null;
        }

        public final void setFabric(NodeFabricLogPublishingConfiguration.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        @Override
        public final Builder fabric(NodeFabricLogPublishingConfiguration fabric) {
            this.fabric = fabric;
            return this;
        }

        @Override
        public NodeLogPublishingConfiguration build() {
            return new NodeLogPublishingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
