/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNetworksResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<ListNetworksResponse.Builder, ListNetworksResponse> {
    private static final SdkField<List<NetworkSummary>> NETWORKS_FIELD = SdkField
            .<List<NetworkSummary>> builder(MarshallingType.LIST)
            .memberName("Networks")
            .getter(getter(ListNetworksResponse::networks))
            .setter(setter(Builder::networks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Networks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNetworksResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORKS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NetworkSummary> networks;

    private final String nextToken;

    private ListNetworksResponse(BuilderImpl builder) {
        super(builder);
        this.networks = builder.networks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Networks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNetworks() {
        return networks != null && !(networks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworks} method.
     * </p>
     * 
     * @return An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.
     */
    public final List<NetworkSummary> networks() {
        return networks;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworks() ? networks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworksResponse)) {
            return false;
        }
        ListNetworksResponse other = (ListNetworksResponse) obj;
        return hasNetworks() == other.hasNetworks() && Objects.equals(networks(), other.networks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNetworksResponse").add("Networks", hasNetworks() ? networks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Networks":
            return Optional.ofNullable(clazz.cast(networks()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworksResponse, T> g) {
        return obj -> g.apply((ListNetworksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNetworksResponse> {
        /**
         * <p>
         * An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.
         * </p>
         * 
         * @param networks
         *        An array of <code>NetworkSummary</code> objects that contain configuration properties for each
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(Collection<NetworkSummary> networks);

        /**
         * <p>
         * An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.
         * </p>
         * 
         * @param networks
         *        An array of <code>NetworkSummary</code> objects that contain configuration properties for each
         *        network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networks(NetworkSummary... networks);

        /**
         * <p>
         * An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NetworkSummary>.Builder} avoiding
         * the need to create one manually via {@link List<NetworkSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #networks(List<NetworkSummary>)}.
         * 
         * @param networks
         *        a consumer that will call methods on {@link List<NetworkSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networks(List<NetworkSummary>)
         */
        Builder networks(Consumer<NetworkSummary.Builder>... networks);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private List<NetworkSummary> networks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworksResponse model) {
            super(model);
            networks(model.networks);
            nextToken(model.nextToken);
        }

        public final List<NetworkSummary.Builder> getNetworks() {
            List<NetworkSummary.Builder> result = NetworkSummaryListCopier.copyToBuilder(this.networks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworks(Collection<NetworkSummary.BuilderImpl> networks) {
            this.networks = NetworkSummaryListCopier.copyFromBuilder(networks);
        }

        @Override
        public final Builder networks(Collection<NetworkSummary> networks) {
            this.networks = NetworkSummaryListCopier.copy(networks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(NetworkSummary... networks) {
            networks(Arrays.asList(networks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networks(Consumer<NetworkSummary.Builder>... networks) {
            networks(Stream.of(networks).map(c -> NetworkSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworksResponse build() {
            return new ListNetworksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
