/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<CreateNetworkRequest.Builder, CreateNetworkRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateNetworkRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateNetworkRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateNetworkRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framework").getter(getter(CreateNetworkRequest::frameworkAsString)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkVersion").getter(getter(CreateNetworkRequest::frameworkVersion))
            .setter(setter(Builder::frameworkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()).build();

    private static final SdkField<NetworkFrameworkConfiguration> FRAMEWORK_CONFIGURATION_FIELD = SdkField
            .<NetworkFrameworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("FrameworkConfiguration")
            .getter(getter(CreateNetworkRequest::frameworkConfiguration)).setter(setter(Builder::frameworkConfiguration))
            .constructor(NetworkFrameworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkConfiguration").build())
            .build();

    private static final SdkField<VotingPolicy> VOTING_POLICY_FIELD = SdkField.<VotingPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("VotingPolicy").getter(getter(CreateNetworkRequest::votingPolicy)).setter(setter(Builder::votingPolicy))
            .constructor(VotingPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VotingPolicy").build()).build();

    private static final SdkField<MemberConfiguration> MEMBER_CONFIGURATION_FIELD = SdkField
            .<MemberConfiguration> builder(MarshallingType.SDK_POJO).memberName("MemberConfiguration")
            .getter(getter(CreateNetworkRequest::memberConfiguration)).setter(setter(Builder::memberConfiguration))
            .constructor(MemberConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateNetworkRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, FRAMEWORK_CONFIGURATION_FIELD,
            VOTING_POLICY_FIELD, MEMBER_CONFIGURATION_FIELD, TAGS_FIELD));

    private final String clientRequestToken;

    private final String name;

    private final String description;

    private final String framework;

    private final String frameworkVersion;

    private final NetworkFrameworkConfiguration frameworkConfiguration;

    private final VotingPolicy votingPolicy;

    private final MemberConfiguration memberConfiguration;

    private final Map<String, String> tags;

    private CreateNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.description = builder.description;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.frameworkConfiguration = builder.frameworkConfiguration;
        this.votingPolicy = builder.votingPolicy;
        this.memberConfiguration = builder.memberConfiguration;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent
     * operation completes no more than one time. This identifier is required only if you make a service request
     * directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
     *         idempotent operation completes no more than one time. This identifier is required only if you make a
     *         service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the
     *         AWS CLI.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The name of the network.
     * </p>
     * 
     * @return The name of the network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the network.
     * </p>
     * 
     * @return An optional description for the network.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The blockchain framework that the network uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return The blockchain framework that the network uses.
     * @see Framework
     */
    public final Framework framework() {
        return Framework.fromValue(framework);
    }

    /**
     * <p>
     * The blockchain framework that the network uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return The blockchain framework that the network uses.
     * @see Framework
     */
    public final String frameworkAsString() {
        return framework;
    }

    /**
     * <p>
     * The version of the blockchain framework that the network uses.
     * </p>
     * 
     * @return The version of the blockchain framework that the network uses.
     */
    public final String frameworkVersion() {
        return frameworkVersion;
    }

    /**
     * <p>
     * Configuration properties of the blockchain framework relevant to the network configuration.
     * </p>
     * 
     * @return Configuration properties of the blockchain framework relevant to the network configuration.
     */
    public final NetworkFrameworkConfiguration frameworkConfiguration() {
        return frameworkConfiguration;
    }

    /**
     * <p>
     * The voting rules used by the network to determine if a proposal is approved.
     * </p>
     * 
     * @return The voting rules used by the network to determine if a proposal is approved.
     */
    public final VotingPolicy votingPolicy() {
        return votingPolicy;
    }

    /**
     * <p>
     * Configuration properties for the first member within the network.
     * </p>
     * 
     * @return Configuration properties for the first member within the network.
     */
    public final MemberConfiguration memberConfiguration() {
        return memberConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to assign to the network. Each tag consists of a key and optional value.
     * </p>
     * <p>
     * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an
     * overall maximum of 50 tags added to each resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to assign to the network. Each tag consists of a key and optional value.</p>
     *         <p>
     *         When specifying tags during creation, you can specify multiple key-value pairs in a single request, with
     *         an overall maximum of 50 tags added to each resource.
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     *         Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
     *         "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     *         >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(votingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(memberConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkRequest)) {
            return false;
        }
        CreateNetworkRequest other = (CreateNetworkRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(frameworkAsString(), other.frameworkAsString())
                && Objects.equals(frameworkVersion(), other.frameworkVersion())
                && Objects.equals(frameworkConfiguration(), other.frameworkConfiguration())
                && Objects.equals(votingPolicy(), other.votingPolicy())
                && Objects.equals(memberConfiguration(), other.memberConfiguration()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateNetworkRequest").add("ClientRequestToken", clientRequestToken()).add("Name", name())
                .add("Description", description()).add("Framework", frameworkAsString())
                .add("FrameworkVersion", frameworkVersion()).add("FrameworkConfiguration", frameworkConfiguration())
                .add("VotingPolicy", votingPolicy()).add("MemberConfiguration", memberConfiguration())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(frameworkAsString()));
        case "FrameworkVersion":
            return Optional.ofNullable(clazz.cast(frameworkVersion()));
        case "FrameworkConfiguration":
            return Optional.ofNullable(clazz.cast(frameworkConfiguration()));
        case "VotingPolicy":
            return Optional.ofNullable(clazz.cast(votingPolicy()));
        case "MemberConfiguration":
            return Optional.ofNullable(clazz.cast(memberConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkRequest, T> g) {
        return obj -> g.apply((CreateNetworkRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         * idempotent operation completes no more than one time. This identifier is required only if you make a service
         * request directly using an HTTP client. It is generated automatically if you use an AWS SDK or the AWS CLI.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An
         *        idempotent operation completes no more than one time. This identifier is required only if you make a
         *        service request directly using an HTTP client. It is generated automatically if you use an AWS SDK or
         *        the AWS CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The name of the network.
         * </p>
         * 
         * @param name
         *        The name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the network.
         * </p>
         * 
         * @param description
         *        An optional description for the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The blockchain framework that the network uses.
         * </p>
         * 
         * @param framework
         *        The blockchain framework that the network uses.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(String framework);

        /**
         * <p>
         * The blockchain framework that the network uses.
         * </p>
         * 
         * @param framework
         *        The blockchain framework that the network uses.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(Framework framework);

        /**
         * <p>
         * The version of the blockchain framework that the network uses.
         * </p>
         * 
         * @param frameworkVersion
         *        The version of the blockchain framework that the network uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkVersion(String frameworkVersion);

        /**
         * <p>
         * Configuration properties of the blockchain framework relevant to the network configuration.
         * </p>
         * 
         * @param frameworkConfiguration
         *        Configuration properties of the blockchain framework relevant to the network configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkConfiguration(NetworkFrameworkConfiguration frameworkConfiguration);

        /**
         * <p>
         * Configuration properties of the blockchain framework relevant to the network configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkFrameworkConfiguration.Builder}
         * avoiding the need to create one manually via {@link NetworkFrameworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFrameworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #frameworkConfiguration(NetworkFrameworkConfiguration)}.
         * 
         * @param frameworkConfiguration
         *        a consumer that will call methods on {@link NetworkFrameworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkConfiguration(NetworkFrameworkConfiguration)
         */
        default Builder frameworkConfiguration(Consumer<NetworkFrameworkConfiguration.Builder> frameworkConfiguration) {
            return frameworkConfiguration(NetworkFrameworkConfiguration.builder().applyMutation(frameworkConfiguration).build());
        }

        /**
         * <p>
         * The voting rules used by the network to determine if a proposal is approved.
         * </p>
         * 
         * @param votingPolicy
         *        The voting rules used by the network to determine if a proposal is approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder votingPolicy(VotingPolicy votingPolicy);

        /**
         * <p>
         * The voting rules used by the network to determine if a proposal is approved.
         * </p>
         * This is a convenience method that creates an instance of the {@link VotingPolicy.Builder} avoiding the need
         * to create one manually via {@link VotingPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link VotingPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #votingPolicy(VotingPolicy)}.
         * 
         * @param votingPolicy
         *        a consumer that will call methods on {@link VotingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #votingPolicy(VotingPolicy)
         */
        default Builder votingPolicy(Consumer<VotingPolicy.Builder> votingPolicy) {
            return votingPolicy(VotingPolicy.builder().applyMutation(votingPolicy).build());
        }

        /**
         * <p>
         * Configuration properties for the first member within the network.
         * </p>
         * 
         * @param memberConfiguration
         *        Configuration properties for the first member within the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberConfiguration(MemberConfiguration memberConfiguration);

        /**
         * <p>
         * Configuration properties for the first member within the network.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemberConfiguration.Builder} avoiding the
         * need to create one manually via {@link MemberConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemberConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #memberConfiguration(MemberConfiguration)}.
         * 
         * @param memberConfiguration
         *        a consumer that will call methods on {@link MemberConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memberConfiguration(MemberConfiguration)
         */
        default Builder memberConfiguration(Consumer<MemberConfiguration.Builder> memberConfiguration) {
            return memberConfiguration(MemberConfiguration.builder().applyMutation(memberConfiguration).build());
        }

        /**
         * <p>
         * Tags to assign to the network. Each tag consists of a key and optional value.
         * </p>
         * <p>
         * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an
         * overall maximum of 50 tags added to each resource.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
         * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        Tags to assign to the network. Each tag consists of a key and optional value.</p>
         *        <p>
         *        When specifying tags during creation, you can specify multiple key-value pairs in a single request,
         *        with an overall maximum of 50 tags added to each resource.
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href=
         *        "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String name;

        private String description;

        private String framework;

        private String frameworkVersion;

        private NetworkFrameworkConfiguration frameworkConfiguration;

        private VotingPolicy votingPolicy;

        private MemberConfiguration memberConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            name(model.name);
            description(model.description);
            framework(model.framework);
            frameworkVersion(model.frameworkVersion);
            frameworkConfiguration(model.frameworkConfiguration);
            votingPolicy(model.votingPolicy);
            memberConfiguration(model.memberConfiguration);
            tags(model.tags);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final String getFrameworkVersion() {
            return frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final NetworkFrameworkConfiguration.Builder getFrameworkConfiguration() {
            return frameworkConfiguration != null ? frameworkConfiguration.toBuilder() : null;
        }

        public final void setFrameworkConfiguration(NetworkFrameworkConfiguration.BuilderImpl frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration != null ? frameworkConfiguration.build() : null;
        }

        @Override
        public final Builder frameworkConfiguration(NetworkFrameworkConfiguration frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration;
            return this;
        }

        public final VotingPolicy.Builder getVotingPolicy() {
            return votingPolicy != null ? votingPolicy.toBuilder() : null;
        }

        public final void setVotingPolicy(VotingPolicy.BuilderImpl votingPolicy) {
            this.votingPolicy = votingPolicy != null ? votingPolicy.build() : null;
        }

        @Override
        public final Builder votingPolicy(VotingPolicy votingPolicy) {
            this.votingPolicy = votingPolicy;
            return this;
        }

        public final MemberConfiguration.Builder getMemberConfiguration() {
            return memberConfiguration != null ? memberConfiguration.toBuilder() : null;
        }

        public final void setMemberConfiguration(MemberConfiguration.BuilderImpl memberConfiguration) {
            this.memberConfiguration = memberConfiguration != null ? memberConfiguration.build() : null;
        }

        @Override
        public final Builder memberConfiguration(MemberConfiguration memberConfiguration) {
            this.memberConfiguration = memberConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkRequest build() {
            return new CreateNetworkRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
