/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes relevant to a node on a Managed Blockchain network for the blockchain framework that the network uses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeFrameworkAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeFrameworkAttributes.Builder, NodeFrameworkAttributes> {
    private static final SdkField<NodeFabricAttributes> FABRIC_FIELD = SdkField
            .<NodeFabricAttributes> builder(MarshallingType.SDK_POJO).memberName("Fabric")
            .getter(getter(NodeFrameworkAttributes::fabric)).setter(setter(Builder::fabric))
            .constructor(NodeFabricAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()).build();

    private static final SdkField<NodeEthereumAttributes> ETHEREUM_FIELD = SdkField
            .<NodeEthereumAttributes> builder(MarshallingType.SDK_POJO).memberName("Ethereum")
            .getter(getter(NodeFrameworkAttributes::ethereum)).setter(setter(Builder::ethereum))
            .constructor(NodeEthereumAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ethereum").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD, ETHEREUM_FIELD));

    private static final long serialVersionUID = 1L;

    private final NodeFabricAttributes fabric;

    private final NodeEthereumAttributes ethereum;

    private NodeFrameworkAttributes(BuilderImpl builder) {
        this.fabric = builder.fabric;
        this.ethereum = builder.ethereum;
    }

    /**
     * <p>
     * Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger Fabric.
     * </p>
     * 
     * @return Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger
     *         Fabric.
     */
    public final NodeFabricAttributes fabric() {
        return fabric;
    }

    /**
     * <p>
     * Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum.
     * </p>
     * 
     * @return Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum.
     */
    public final NodeEthereumAttributes ethereum() {
        return ethereum;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fabric());
        hashCode = 31 * hashCode + Objects.hashCode(ethereum());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeFrameworkAttributes)) {
            return false;
        }
        NodeFrameworkAttributes other = (NodeFrameworkAttributes) obj;
        return Objects.equals(fabric(), other.fabric()) && Objects.equals(ethereum(), other.ethereum());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeFrameworkAttributes").add("Fabric", fabric()).add("Ethereum", ethereum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fabric":
            return Optional.ofNullable(clazz.cast(fabric()));
        case "Ethereum":
            return Optional.ofNullable(clazz.cast(ethereum()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeFrameworkAttributes, T> g) {
        return obj -> g.apply((NodeFrameworkAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeFrameworkAttributes> {
        /**
         * <p>
         * Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger
         * Fabric.
         * </p>
         * 
         * @param fabric
         *        Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger
         *        Fabric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fabric(NodeFabricAttributes fabric);

        /**
         * <p>
         * Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger
         * Fabric.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeFabricAttributes.Builder} avoiding the need
         * to create one manually via {@link NodeFabricAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeFabricAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #fabric(NodeFabricAttributes)}.
         * 
         * @param fabric
         *        a consumer that will call methods on {@link NodeFabricAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fabric(NodeFabricAttributes)
         */
        default Builder fabric(Consumer<NodeFabricAttributes.Builder> fabric) {
            return fabric(NodeFabricAttributes.builder().applyMutation(fabric).build());
        }

        /**
         * <p>
         * Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum.
         * </p>
         * 
         * @param ethereum
         *        Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ethereum(NodeEthereumAttributes ethereum);

        /**
         * <p>
         * Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeEthereumAttributes.Builder} avoiding the
         * need to create one manually via {@link NodeEthereumAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeEthereumAttributes.Builder#build()} is called immediately and
         * its result is passed to {@link #ethereum(NodeEthereumAttributes)}.
         * 
         * @param ethereum
         *        a consumer that will call methods on {@link NodeEthereumAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ethereum(NodeEthereumAttributes)
         */
        default Builder ethereum(Consumer<NodeEthereumAttributes.Builder> ethereum) {
            return ethereum(NodeEthereumAttributes.builder().applyMutation(ethereum).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NodeFabricAttributes fabric;

        private NodeEthereumAttributes ethereum;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeFrameworkAttributes model) {
            fabric(model.fabric);
            ethereum(model.ethereum);
        }

        public final NodeFabricAttributes.Builder getFabric() {
            return fabric != null ? fabric.toBuilder() : null;
        }

        public final void setFabric(NodeFabricAttributes.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        @Override
        @Transient
        public final Builder fabric(NodeFabricAttributes fabric) {
            this.fabric = fabric;
            return this;
        }

        public final NodeEthereumAttributes.Builder getEthereum() {
            return ethereum != null ? ethereum.toBuilder() : null;
        }

        public final void setEthereum(NodeEthereumAttributes.BuilderImpl ethereum) {
            this.ethereum = ethereum != null ? ethereum.build() : null;
        }

        @Override
        @Transient
        public final Builder ethereum(NodeEthereumAttributes ethereum) {
            this.ethereum = ethereum;
            return this;
        }

        @Override
        public NodeFrameworkAttributes build() {
            return new NodeFrameworkAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
