/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of network configuration properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkSummary implements SdkPojo, Serializable, ToCopyableBuilder<NetworkSummary.Builder, NetworkSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(NetworkSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(NetworkSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(NetworkSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Framework").getter(getter(NetworkSummary::frameworkAsString)).setter(setter(Builder::framework))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()).build();

    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FrameworkVersion").getter(getter(NetworkSummary::frameworkVersion))
            .setter(setter(Builder::frameworkVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NetworkSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(NetworkSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(NetworkSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String framework;

    private final String frameworkVersion;

    private final String status;

    private final Instant creationDate;

    private final String arn;

    private NetworkSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The unique identifier of the network.
     * </p>
     * 
     * @return The unique identifier of the network.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the network.
     * </p>
     * 
     * @return The name of the network.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description of the network.
     * </p>
     * 
     * @return An optional description of the network.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The blockchain framework that the network uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return The blockchain framework that the network uses.
     * @see Framework
     */
    public final Framework framework() {
        return Framework.fromValue(framework);
    }

    /**
     * <p>
     * The blockchain framework that the network uses.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #framework} will
     * return {@link Framework#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frameworkAsString}.
     * </p>
     * 
     * @return The blockchain framework that the network uses.
     * @see Framework
     */
    public final String frameworkAsString() {
        return framework;
    }

    /**
     * <p>
     * The version of the blockchain framework that the network uses.
     * </p>
     * 
     * @return The version of the blockchain framework that the network uses.
     */
    public final String frameworkVersion() {
        return frameworkVersion;
    }

    /**
     * <p>
     * The current status of the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the network.
     * @see NetworkStatus
     */
    public final NetworkStatus status() {
        return NetworkStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the network.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NetworkStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the network.
     * @see NetworkStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the network was created.
     * </p>
     * 
     * @return The date and time that the network was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>AWS General Reference</i>.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkSummary)) {
            return false;
        }
        NetworkSummary other = (NetworkSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(frameworkAsString(), other.frameworkAsString())
                && Objects.equals(frameworkVersion(), other.frameworkVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkSummary").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Framework", frameworkAsString()).add("FrameworkVersion", frameworkVersion())
                .add("Status", statusAsString()).add("CreationDate", creationDate()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Framework":
            return Optional.ofNullable(clazz.cast(frameworkAsString()));
        case "FrameworkVersion":
            return Optional.ofNullable(clazz.cast(frameworkVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkSummary, T> g) {
        return obj -> g.apply((NetworkSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkSummary> {
        /**
         * <p>
         * The unique identifier of the network.
         * </p>
         * 
         * @param id
         *        The unique identifier of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the network.
         * </p>
         * 
         * @param name
         *        The name of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description of the network.
         * </p>
         * 
         * @param description
         *        An optional description of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The blockchain framework that the network uses.
         * </p>
         * 
         * @param framework
         *        The blockchain framework that the network uses.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(String framework);

        /**
         * <p>
         * The blockchain framework that the network uses.
         * </p>
         * 
         * @param framework
         *        The blockchain framework that the network uses.
         * @see Framework
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Framework
         */
        Builder framework(Framework framework);

        /**
         * <p>
         * The version of the blockchain framework that the network uses.
         * </p>
         * 
         * @param frameworkVersion
         *        The version of the blockchain framework that the network uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkVersion(String frameworkVersion);

        /**
         * <p>
         * The current status of the network.
         * </p>
         * 
         * @param status
         *        The current status of the network.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the network.
         * </p>
         * 
         * @param status
         *        The current status of the network.
         * @see NetworkStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkStatus
         */
        Builder status(NetworkStatus status);

        /**
         * <p>
         * The date and time that the network was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time that the network was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs)</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see
         *        <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs)</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String framework;

        private String frameworkVersion;

        private String status;

        private Instant creationDate;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkSummary model) {
            id(model.id);
            name(model.name);
            description(model.description);
            framework(model.framework);
            frameworkVersion(model.frameworkVersion);
            status(model.status);
            creationDate(model.creationDate);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFramework() {
            return framework;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        @Override
        @Transient
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        @Transient
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final String getFrameworkVersion() {
            return frameworkVersion;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        @Override
        @Transient
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(NetworkStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public NetworkSummary build() {
            return new NetworkSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
