/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.managedblockchain.model.CreateMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateNetworkRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateNetworkResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.CreateProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.CreateProposalResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.DeleteNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.DeleteNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetNetworkRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetNetworkResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.GetProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.GetProposalResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse;
import software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.managedblockchain.model.RejectInvitationRequest;
import software.amazon.awssdk.services.managedblockchain.model.RejectInvitationResponse;
import software.amazon.awssdk.services.managedblockchain.model.TagResourceRequest;
import software.amazon.awssdk.services.managedblockchain.model.TagResourceResponse;
import software.amazon.awssdk.services.managedblockchain.model.UntagResourceRequest;
import software.amazon.awssdk.services.managedblockchain.model.UntagResourceResponse;
import software.amazon.awssdk.services.managedblockchain.model.UpdateMemberRequest;
import software.amazon.awssdk.services.managedblockchain.model.UpdateMemberResponse;
import software.amazon.awssdk.services.managedblockchain.model.UpdateNodeRequest;
import software.amazon.awssdk.services.managedblockchain.model.UpdateNodeResponse;
import software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalRequest;
import software.amazon.awssdk.services.managedblockchain.model.VoteOnProposalResponse;
import software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsPublisher;
import software.amazon.awssdk.services.managedblockchain.paginators.ListMembersPublisher;
import software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksPublisher;
import software.amazon.awssdk.services.managedblockchain.paginators.ListNodesPublisher;
import software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesPublisher;
import software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsPublisher;

/**
 * Service client for accessing ManagedBlockchain asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p/>
 * <p>
 * Amazon Managed Blockchain is a fully managed service for creating and managing blockchain networks using open-source
 * frameworks. Blockchain allows you to build applications where multiple parties can securely and transparently run
 * transactions and share data without the need for a trusted, central authority.
 * </p>
 * <p>
 * Managed Blockchain supports the Hyperledger Fabric and Ethereum open-source frameworks. Because of fundamental
 * differences between the frameworks, some API actions or data types may only apply in the context of one framework and
 * not the other. For example, actions related to Hyperledger Fabric network members such as <code>CreateMember</code>
 * and <code>DeleteMember</code> do not apply to Ethereum.
 * </p>
 * <p>
 * The description for each action indicates the framework or frameworks to which it applies. Data types and properties
 * that apply only in the context of a particular framework are similarly indicated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ManagedBlockchainAsyncClient extends SdkClient {
    String SERVICE_NAME = "managedblockchain";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "managedblockchain";

    /**
     * Create a {@link ManagedBlockchainAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ManagedBlockchainAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ManagedBlockchainAsyncClient}.
     */
    static ManagedBlockchainAsyncClientBuilder builder() {
        return new DefaultManagedBlockchainAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a member within a Managed Blockchain network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param createMemberRequest
     * @return A Java Future containing the result of the CreateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceAlreadyExistsException A resource request is issued for a resource that already exists.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMemberResponse> createMember(CreateMemberRequest createMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a member within a Managed Blockchain network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMemberRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMemberRequest#builder()}
     * </p>
     *
     * @param createMemberRequest
     *        A {@link Consumer} that will call methods on {@link CreateMemberInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceAlreadyExistsException A resource request is issued for a resource that already exists.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMemberResponse> createMember(Consumer<CreateMemberRequest.Builder> createMemberRequest) {
        return createMember(CreateMemberRequest.builder().applyMutation(createMemberRequest).build());
    }

    /**
     * <p>
     * Creates a new blockchain network using Amazon Managed Blockchain.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param createNetworkRequest
     * @return A Java Future containing the result of the CreateNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceAlreadyExistsException A resource request is issued for a resource that already exists.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkResponse> createNetwork(CreateNetworkRequest createNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new blockchain network using Amazon Managed Blockchain.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNetworkRequest#builder()}
     * </p>
     *
     * @param createNetworkRequest
     *        A {@link Consumer} that will call methods on {@link CreateNetworkInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceAlreadyExistsException A resource request is issued for a resource that already exists.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNetwork"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkResponse> createNetwork(Consumer<CreateNetworkRequest.Builder> createNetworkRequest) {
        return createNetwork(CreateNetworkRequest.builder().applyMutation(createNetworkRequest).build());
    }

    /**
     * <p>
     * Creates a node on the specified blockchain network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param createNodeRequest
     * @return A Java Future containing the result of the CreateNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceAlreadyExistsException A resource request is issued for a resource that already exists.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNodeResponse> createNode(CreateNodeRequest createNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a node on the specified blockchain network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateNodeRequest#builder()}
     * </p>
     *
     * @param createNodeRequest
     *        A {@link Consumer} that will call methods on {@link CreateNodeInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceAlreadyExistsException A resource request is issued for a resource that already exists.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateNodeResponse> createNode(Consumer<CreateNodeRequest.Builder> createNodeRequest) {
        return createNode(CreateNodeRequest.builder().applyMutation(createNodeRequest).build());
    }

    /**
     * <p>
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a
     * proposal to add a new member to the network. Any member can create a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param createProposalRequest
     * @return A Java Future containing the result of the CreateProposal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProposalResponse> createProposal(CreateProposalRequest createProposalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a proposal for a change to the network that other members of the network can vote on, for example, a
     * proposal to add a new member to the network. Any member can create a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProposalRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProposalRequest#builder()}
     * </p>
     *
     * @param createProposalRequest
     *        A {@link Consumer} that will call methods on {@link CreateProposalInput.Builder} to create a request.
     * @return A Java Future containing the result of the CreateProposal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>TooManyTagsException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.CreateProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProposalResponse> createProposal(Consumer<CreateProposalRequest.Builder> createProposalRequest) {
        return createProposal(CreateProposalRequest.builder().applyMutation(createProposalRequest).build());
    }

    /**
     * <p>
     * Deletes a member. Deleting a member removes the member and all associated resources from the network.
     * <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing
     * the action is associated with the AWS account that owns the member. In all other cases, the
     * <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If
     * <code>MemberId</code> is the last member in a network specified by the last AWS account, the network is deleted
     * also.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param deleteMemberRequest
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMemberResponse> deleteMember(DeleteMemberRequest deleteMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a member. Deleting a member removes the member and all associated resources from the network.
     * <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing
     * the action is associated with the AWS account that owns the member. In all other cases, the
     * <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If
     * <code>MemberId</code> is the last member in a network specified by the last AWS account, the network is deleted
     * also.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMemberRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMemberRequest#builder()}
     * </p>
     *
     * @param deleteMemberRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMemberInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.DeleteMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteMemberResponse> deleteMember(Consumer<DeleteMemberRequest.Builder> deleteMemberRequest) {
        return deleteMember(DeleteMemberRequest.builder().applyMutation(deleteMemberRequest).build());
    }

    /**
     * <p>
     * Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param deleteNodeRequest
     * @return A Java Future containing the result of the DeleteNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNodeResponse> deleteNode(DeleteNodeRequest deleteNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a node that your AWS account owns. All data on the node is lost and cannot be recovered.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNodeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteNodeRequest#builder()}
     * </p>
     *
     * @param deleteNodeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNodeInput.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.DeleteNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/DeleteNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteNodeResponse> deleteNode(Consumer<DeleteNodeRequest.Builder> deleteNodeRequest) {
        return deleteNode(DeleteNodeRequest.builder().applyMutation(deleteNodeRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a member.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param getMemberRequest
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMemberResponse> getMember(GetMemberRequest getMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a member.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMemberRequest.Builder} avoiding the need to
     * create one manually via {@link GetMemberRequest#builder()}
     * </p>
     *
     * @param getMemberRequest
     *        A {@link Consumer} that will call methods on {@link GetMemberInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetMember" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMemberResponse> getMember(Consumer<GetMemberRequest.Builder> getMemberRequest) {
        return getMember(GetMemberRequest.builder().applyMutation(getMemberRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param getNetworkRequest
     * @return A Java Future containing the result of the GetNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNetworkResponse> getNetwork(GetNetworkRequest getNetworkRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkRequest.Builder} avoiding the need to
     * create one manually via {@link GetNetworkRequest#builder()}
     * </p>
     *
     * @param getNetworkRequest
     *        A {@link Consumer} that will call methods on {@link GetNetworkInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetNetwork operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetNetwork
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNetwork" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNetworkResponse> getNetwork(Consumer<GetNetworkRequest.Builder> getNetworkRequest) {
        return getNetwork(GetNetworkRequest.builder().applyMutation(getNetworkRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a node.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param getNodeRequest
     * @return A Java Future containing the result of the GetNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetNodeResponse> getNode(GetNodeRequest getNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a node.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNodeRequest.Builder} avoiding the need to create
     * one manually via {@link GetNodeRequest#builder()}
     * </p>
     *
     * @param getNodeRequest
     *        A {@link Consumer} that will call methods on {@link GetNodeInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetNode" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetNodeResponse> getNode(Consumer<GetNodeRequest.Builder> getNodeRequest) {
        return getNode(GetNodeRequest.builder().applyMutation(getNodeRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param getProposalRequest
     * @return A Java Future containing the result of the GetProposal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetProposal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProposalResponse> getProposal(GetProposalRequest getProposalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about a proposal.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProposalRequest.Builder} avoiding the need to
     * create one manually via {@link GetProposalRequest#builder()}
     * </p>
     *
     * @param getProposalRequest
     *        A {@link Consumer} that will call methods on {@link GetProposalInput.Builder} to create a request.
     * @return A Java Future containing the result of the GetProposal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.GetProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/GetProposal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProposalResponse> getProposal(Consumer<GetProposalRequest.Builder> getProposalRequest) {
        return getProposal(GetProposalRequest.builder().applyMutation(getProposalRequest).build());
    }

    /**
     * <p>
     * Returns a list of all invitations for the current AWS account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listInvitationsRequest
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all invitations for the current AWS account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListInvitations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInvitationsResponse> listInvitations(
            Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all invitations for the current AWS account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all invitations for the current AWS account.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListInvitationsPublisher publisher = client.listInvitationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on {@link ListInvitationsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>ResourceLimitExceededException The maximum number of resources of that type already exist. Ensure the
     *         resources requested are within the boundaries of the service edition and your account limits.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInvitationsPublisher listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest) {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listMembersRequest
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListMembersResponse> listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(ListMembersRequest listMembersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the members in a network and properties of their configurations.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListMembersPublisher publisher = client.listMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.managedblockchain.model.ListMembersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on {@link ListMembersInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListMembers" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMembersPublisher listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest) {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Returns information about the networks in which the current AWS account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param listNetworksRequest
     * @return A Java Future containing the result of the ListNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworksResponse> listNetworks(ListNetworksRequest listNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the networks in which the current AWS account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworksInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListNetworks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworksResponse> listNetworks(Consumer<ListNetworksRequest.Builder> listNetworksRequest) {
        return listNetworks(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Returns information about the networks in which the current AWS account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation.</b>
     * </p>
     *
     * @param listNetworksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworksPublisher listNetworksPaginator(ListNetworksRequest listNetworksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the networks in which the current AWS account participates.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNetworksPublisher publisher = client.listNetworksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListNetworksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworks(software.amazon.awssdk.services.managedblockchain.model.ListNetworksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworksRequest.Builder} avoiding the need to
     * create one manually via {@link ListNetworksRequest#builder()}
     * </p>
     *
     * @param listNetworksRequest
     *        A {@link Consumer} that will call methods on {@link ListNetworksInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNetworks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNetworks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworksPublisher listNetworksPaginator(Consumer<ListNetworksRequest.Builder> listNetworksRequest) {
        return listNetworksPaginator(ListNetworksRequest.builder().applyMutation(listNetworksRequest).build());
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     *
     * @param listNodesRequest
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNodesResponse> listNodes(ListNodesRequest listNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on {@link ListNodesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListNodes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListNodesResponse> listNodes(Consumer<ListNodesRequest.Builder> listNodesRequest) {
        return listNodes(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)} operation.</b>
     * </p>
     *
     * @param listNodesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNodesPublisher listNodesPaginator(ListNodesRequest listNodesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the nodes within a network.
     * </p>
     * <p>
     * Applies to Hyperledger Fabric and Ethereum.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListNodesPublisher publisher = client.listNodesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListNodesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNodes(software.amazon.awssdk.services.managedblockchain.model.ListNodesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNodesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNodesRequest#builder()}
     * </p>
     *
     * @param listNodesRequest
     *        A {@link Consumer} that will call methods on {@link ListNodesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListNodes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListNodes" target="_top">AWS
     *      API Documentation</a>
     */
    default ListNodesPublisher listNodesPaginator(Consumer<ListNodesRequest.Builder> listNodesRequest) {
        return listNodesPaginator(ListNodesRequest.builder().applyMutation(listNodesRequest).build());
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listProposalVotesRequest
     * @return A Java Future containing the result of the ListProposalVotes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProposalVotesResponse> listProposalVotes(ListProposalVotesRequest listProposalVotesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalVotesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProposalVotesRequest#builder()}
     * </p>
     *
     * @param listProposalVotesRequest
     *        A {@link Consumer} that will call methods on {@link ListProposalVotesInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListProposalVotes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProposalVotesResponse> listProposalVotes(
            Consumer<ListProposalVotesRequest.Builder> listProposalVotesRequest) {
        return listProposalVotes(ListProposalVotesRequest.builder().applyMutation(listProposalVotesRequest).build());
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesPublisher publisher = client.listProposalVotesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesPublisher publisher = client.listProposalVotesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProposalVotesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalVotesPublisher listProposalVotesPaginator(ListProposalVotesRequest listProposalVotesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of
     * the member that cast the vote.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesPublisher publisher = client.listProposalVotesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalVotesPublisher publisher = client.listProposalVotesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposalVotes(software.amazon.awssdk.services.managedblockchain.model.ListProposalVotesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalVotesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProposalVotesRequest#builder()}
     * </p>
     *
     * @param listProposalVotesRequest
     *        A {@link Consumer} that will call methods on {@link ListProposalVotesInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposalVotes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposalVotes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalVotesPublisher listProposalVotesPaginator(
            Consumer<ListProposalVotesRequest.Builder> listProposalVotesRequest) {
        return listProposalVotesPaginator(ListProposalVotesRequest.builder().applyMutation(listProposalVotesRequest).build());
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param listProposalsRequest
     * @return A Java Future containing the result of the ListProposals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProposalsResponse> listProposals(ListProposalsRequest listProposalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProposalsRequest#builder()}
     * </p>
     *
     * @param listProposalsRequest
     *        A {@link Consumer} that will call methods on {@link ListProposalsInput.Builder} to create a request.
     * @return A Java Future containing the result of the ListProposals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProposalsResponse> listProposals(Consumer<ListProposalsRequest.Builder> listProposalsRequest) {
        return listProposals(ListProposalsRequest.builder().applyMutation(listProposalsRequest).build());
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsPublisher publisher = client.listProposalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsPublisher publisher = client.listProposalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProposalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalsPublisher listProposalsPaginator(ListProposalsRequest listProposalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of proposals for the network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsPublisher publisher = client.listProposalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchain.paginators.ListProposalsPublisher publisher = client.listProposalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchain.model.ListProposalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProposals(software.amazon.awssdk.services.managedblockchain.model.ListProposalsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProposalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProposalsRequest#builder()}
     * </p>
     *
     * @param listProposalsRequest
     *        A {@link Consumer} that will call methods on {@link ListProposalsInput.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListProposals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListProposals"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProposalsPublisher listProposalsPaginator(Consumer<ListProposalsRequest.Builder> listProposalsRequest) {
        return listProposalsPaginator(ListProposalsRequest.builder().applyMutation(listProposalsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for the specified resource. Each tag consists of a key and optional value.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has
     * received an invitation to create a member and join a network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param rejectInvitationRequest
     * @return A Java Future containing the result of the RejectInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>IllegalActionException</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.RejectInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/RejectInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectInvitationResponse> rejectInvitation(RejectInvitationRequest rejectInvitationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Rejects an invitation to join a network. This action can be called by a principal in an AWS account that has
     * received an invitation to create a member and join a network.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link RejectInvitationRequest#builder()}
     * </p>
     *
     * @param rejectInvitationRequest
     *        A {@link Consumer} that will call methods on {@link RejectInvitationInput.Builder} to create a request.
     * @return A Java Future containing the result of the RejectInvitation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>IllegalActionException</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.RejectInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/RejectInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RejectInvitationResponse> rejectInvitation(
            Consumer<RejectInvitationRequest.Builder> rejectInvitationRequest) {
        return rejectInvitation(RejectInvitationRequest.builder().applyMutation(rejectInvitationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of
     * a key and optional value.
     * </p>
     * <p>
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use
     * <code>UntagResource</code> to remove tag keys.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and
     * returns an error.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>TooManyTagsException</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of
     * a key and optional value.
     * </p>
     * <p>
     * When you specify a tag key that already exists, the tag value is overwritten with the new value. Use
     * <code>UntagResource</code> to remove tag keys.
     * </p>
     * <p>
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and
     * returns an error.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>TooManyTagsException</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the Amazon Managed Blockchain resource.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     * >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ResourceNotReadyException The requested resource exists but is not in a status that can complete the
     *         operation.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a member configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param updateMemberRequest
     * @return A Java Future containing the result of the UpdateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.UpdateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMemberResponse> updateMember(UpdateMemberRequest updateMemberRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a member configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateMemberRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateMemberRequest#builder()}
     * </p>
     *
     * @param updateMemberRequest
     *        A {@link Consumer} that will call methods on {@link UpdateMemberInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateMember operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.UpdateMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateMember"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateMemberResponse> updateMember(Consumer<UpdateMemberRequest.Builder> updateMemberRequest) {
        return updateMember(UpdateMemberRequest.builder().applyMutation(updateMemberRequest).build());
    }

    /**
     * <p>
     * Updates a node configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param updateNodeRequest
     * @return A Java Future containing the result of the UpdateNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateNodeResponse> updateNode(UpdateNodeRequest updateNodeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a node configuration with new parameters.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNodeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateNodeRequest#builder()}
     * </p>
     *
     * @param updateNodeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateNodeInput.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateNode operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.UpdateNode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/UpdateNode" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateNodeResponse> updateNode(Consumer<UpdateNodeRequest.Builder> updateNodeRequest) {
        return updateNode(UpdateNodeRequest.builder().applyMutation(updateNodeRequest).build());
    }

    /**
     * <p>
     * Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by
     * <code>VoterMemberId</code>, must be in the same AWS account as the principal that calls the action.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     *
     * @param voteOnProposalRequest
     * @return A Java Future containing the result of the VoteOnProposal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>IllegalActionException</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.VoteOnProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/VoteOnProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VoteOnProposalResponse> voteOnProposal(VoteOnProposalRequest voteOnProposalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by
     * <code>VoterMemberId</code>, must be in the same AWS account as the principal that calls the action.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link VoteOnProposalRequest.Builder} avoiding the need to
     * create one manually via {@link VoteOnProposalRequest#builder()}
     * </p>
     *
     * @param voteOnProposalRequest
     *        A {@link Consumer} that will call methods on {@link VoteOnProposalInput.Builder} to create a request.
     * @return A Java Future containing the result of the VoteOnProposal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The action or operation requested is invalid. Verify that the action is typed
     *         correctly.</li>
     *         <li>IllegalActionException</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ResourceNotFoundException A requested resource does not exist. It may have been deleted or referenced
     *         inaccurately.</li>
     *         <li>ThrottlingException The request or operation could not be performed because a service is throttling
     *         requests. The most common source of throttling errors is launching EC2 instances such that your service
     *         limit for EC2 instances is exceeded. Request a limit increase or delete unused resources if possible.</li>
     *         <li>InternalServiceErrorException The request processing has failed because of an unknown error,
     *         exception or failure.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainAsyncClient.VoteOnProposal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/VoteOnProposal"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<VoteOnProposalResponse> voteOnProposal(Consumer<VoteOnProposalRequest.Builder> voteOnProposalRequest) {
        return voteOnProposal(VoteOnProposalRequest.builder().applyMutation(voteOnProposalRequest).build());
    }
}
