/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Hyperledger Fabric configuration properties for the network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFabricConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFabricConfiguration.Builder, NetworkFabricConfiguration> {
    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(NetworkFabricConfiguration::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String edition;

    private NetworkFabricConfiguration(BuilderImpl builder) {
        this.edition = builder.edition;
    }

    /**
     * <p>
     * The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
     * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
     *         href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * @see Edition
     */
    public final Edition edition() {
        return Edition.fromValue(edition);
    }

    /**
     * <p>
     * The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
     * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
     *         href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * @see Edition
     */
    public final String editionAsString() {
        return edition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFabricConfiguration)) {
            return false;
        }
        NetworkFabricConfiguration other = (NetworkFabricConfiguration) obj;
        return Objects.equals(editionAsString(), other.editionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFabricConfiguration").add("Edition", editionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFabricConfiguration, T> g) {
        return obj -> g.apply((NetworkFabricConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFabricConfiguration> {
        /**
         * <p>
         * The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
         * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * </p>
         * 
         * @param edition
         *        The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
         *        href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
         * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * </p>
         * 
         * @param edition
         *        The edition of Amazon Managed Blockchain that the network uses. For more information, see <a
         *        href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(Edition edition);
    }

    static final class BuilderImpl implements Builder {
        private String edition;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFabricConfiguration model) {
            edition(model.edition);
        }

        public final String getEdition() {
            return edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public NetworkFabricConfiguration build() {
            return new NetworkFabricConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
