/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateNetworkResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<CreateNetworkResponse.Builder, CreateNetworkResponse> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(CreateNetworkResponse::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(CreateNetworkResponse::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            MEMBER_ID_FIELD));

    private final String networkId;

    private final String memberId;

    private CreateNetworkResponse(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
    }

    /**
     * <p>
     * The unique identifier for the network.
     * </p>
     * 
     * @return The unique identifier for the network.
     */
    public String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The unique identifier for the first member within the network.
     * </p>
     * 
     * @return The unique identifier for the first member within the network.
     */
    public String memberId() {
        return memberId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkResponse)) {
            return false;
        }
        CreateNetworkResponse other = (CreateNetworkResponse) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(memberId(), other.memberId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateNetworkResponse").add("NetworkId", networkId()).add("MemberId", memberId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkResponse, T> g) {
        return obj -> g.apply((CreateNetworkResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateNetworkResponse> {
        /**
         * <p>
         * The unique identifier for the network.
         * </p>
         * 
         * @param networkId
         *        The unique identifier for the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The unique identifier for the first member within the network.
         * </p>
         * 
         * @param memberId
         *        The unique identifier for the first member within the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private String networkId;

        private String memberId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkResponse model) {
            super(model);
            networkId(model.networkId);
            memberId(model.memberId);
        }

        public final String getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getMemberId() {
            return memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public CreateNetworkResponse build() {
            return new CreateNetworkResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
