/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of Hyperledger Fabric for a network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFabricAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFabricAttributes.Builder, NetworkFabricAttributes> {
    private static final SdkField<String> ORDERING_SERVICE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkFabricAttributes::orderingServiceEndpoint)).setter(setter(Builder::orderingServiceEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingServiceEndpoint").build())
            .build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NetworkFabricAttributes::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORDERING_SERVICE_ENDPOINT_FIELD, EDITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String orderingServiceEndpoint;

    private final String edition;

    private NetworkFabricAttributes(BuilderImpl builder) {
        this.orderingServiceEndpoint = builder.orderingServiceEndpoint;
        this.edition = builder.edition;
    }

    /**
     * <p>
     * The endpoint of the ordering service for the network.
     * </p>
     * 
     * @return The endpoint of the ordering service for the network.
     */
    public String orderingServiceEndpoint() {
        return orderingServiceEndpoint;
    }

    /**
     * <p>
     * The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
     * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
     *         href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * @see Edition
     */
    public Edition edition() {
        return Edition.fromValue(edition);
    }

    /**
     * <p>
     * The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
     * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
     *         href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
     * @see Edition
     */
    public String editionAsString() {
        return edition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(orderingServiceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFabricAttributes)) {
            return false;
        }
        NetworkFabricAttributes other = (NetworkFabricAttributes) obj;
        return Objects.equals(orderingServiceEndpoint(), other.orderingServiceEndpoint())
                && Objects.equals(editionAsString(), other.editionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NetworkFabricAttributes").add("OrderingServiceEndpoint", orderingServiceEndpoint())
                .add("Edition", editionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrderingServiceEndpoint":
            return Optional.ofNullable(clazz.cast(orderingServiceEndpoint()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFabricAttributes, T> g) {
        return obj -> g.apply((NetworkFabricAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFabricAttributes> {
        /**
         * <p>
         * The endpoint of the ordering service for the network.
         * </p>
         * 
         * @param orderingServiceEndpoint
         *        The endpoint of the ordering service for the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orderingServiceEndpoint(String orderingServiceEndpoint);

        /**
         * <p>
         * The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
         * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * </p>
         * 
         * @param edition
         *        The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
         *        href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
         * href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * </p>
         * 
         * @param edition
         *        The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a
         *        href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(Edition edition);
    }

    static final class BuilderImpl implements Builder {
        private String orderingServiceEndpoint;

        private String edition;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFabricAttributes model) {
            orderingServiceEndpoint(model.orderingServiceEndpoint);
            edition(model.edition);
        }

        public final String getOrderingServiceEndpoint() {
            return orderingServiceEndpoint;
        }

        @Override
        public final Builder orderingServiceEndpoint(String orderingServiceEndpoint) {
            this.orderingServiceEndpoint = orderingServiceEndpoint;
            return this;
        }

        public final void setOrderingServiceEndpoint(String orderingServiceEndpoint) {
            this.orderingServiceEndpoint = orderingServiceEndpoint;
        }

        public final String getEdition() {
            return edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public NetworkFabricAttributes build() {
            return new NetworkFabricAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
