/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An invitation to an AWS account to create a member and join the network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Invitation implements SdkPojo, Serializable, ToCopyableBuilder<Invitation.Builder, Invitation> {
    private static final SdkField<String> INVITATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Invitation::invitationId)).setter(setter(Builder::invitationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvitationId").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Invitation::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Invitation::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Invitation::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<NetworkSummary> NETWORK_SUMMARY_FIELD = SdkField
            .<NetworkSummary> builder(MarshallingType.SDK_POJO).getter(getter(Invitation::networkSummary))
            .setter(setter(Builder::networkSummary)).constructor(NetworkSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATION_ID_FIELD,
            CREATION_DATE_FIELD, EXPIRATION_DATE_FIELD, STATUS_FIELD, NETWORK_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String invitationId;

    private final Instant creationDate;

    private final Instant expirationDate;

    private final String status;

    private final NetworkSummary networkSummary;

    private Invitation(BuilderImpl builder) {
        this.invitationId = builder.invitationId;
        this.creationDate = builder.creationDate;
        this.expirationDate = builder.expirationDate;
        this.status = builder.status;
        this.networkSummary = builder.networkSummary;
    }

    /**
     * <p>
     * The unique identifier for the invitation.
     * </p>
     * 
     * @return The unique identifier for the invitation.
     */
    public String invitationId() {
        return invitationId;
    }

    /**
     * <p>
     * The date and time that the invitation was created.
     * </p>
     * 
     * @return The date and time that the invitation was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time that the invitation expires. This is the <code>CreationDate</code> plus the
     * <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this
     * date and time, the invitee can no longer create a member and join the network using this
     * <code>InvitationId</code>.
     * </p>
     * 
     * @return The date and time that the invitation expires. This is the <code>CreationDate</code> plus the
     *         <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After
     *         this date and time, the invitee can no longer create a member and join the network using this
     *         <code>InvitationId</code>.
     */
    public Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * The status of the invitation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not yet
     * expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCEPTED</code> - The invitee created a member and joined the network using the <code>InvitationID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The invitee rejected the invitation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
     * <code>ExpirationDate</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the invitation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has
     *         not yet expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCEPTED</code> - The invitee created a member and joined the network using the
     *         <code>InvitationID</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The invitee rejected the invitation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
     *         <code>ExpirationDate</code>.
     *         </p>
     *         </li>
     * @see InvitationStatus
     */
    public InvitationStatus status() {
        return InvitationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the invitation:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not yet
     * expired.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACCEPTED</code> - The invitee created a member and joined the network using the <code>InvitationID</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The invitee rejected the invitation.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
     * <code>ExpirationDate</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InvitationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the invitation:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has
     *         not yet expired.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACCEPTED</code> - The invitee created a member and joined the network using the
     *         <code>InvitationID</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The invitee rejected the invitation.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
     *         <code>ExpirationDate</code>.
     *         </p>
     *         </li>
     * @see InvitationStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the NetworkSummary property for this object.
     * 
     * @return The value of the NetworkSummary property for this object.
     */
    public NetworkSummary networkSummary() {
        return networkSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invitationId());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invitation)) {
            return false;
        }
        Invitation other = (Invitation) obj;
        return Objects.equals(invitationId(), other.invitationId()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(expirationDate(), other.expirationDate())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(networkSummary(), other.networkSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Invitation").add("InvitationId", invitationId()).add("CreationDate", creationDate())
                .add("ExpirationDate", expirationDate()).add("Status", statusAsString()).add("NetworkSummary", networkSummary())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvitationId":
            return Optional.ofNullable(clazz.cast(invitationId()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "NetworkSummary":
            return Optional.ofNullable(clazz.cast(networkSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Invitation, T> g) {
        return obj -> g.apply((Invitation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Invitation> {
        /**
         * <p>
         * The unique identifier for the invitation.
         * </p>
         * 
         * @param invitationId
         *        The unique identifier for the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitationId(String invitationId);

        /**
         * <p>
         * The date and time that the invitation was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time that the invitation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time that the invitation expires. This is the <code>CreationDate</code> plus the
         * <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After
         * this date and time, the invitee can no longer create a member and join the network using this
         * <code>InvitationId</code>.
         * </p>
         * 
         * @param expirationDate
         *        The date and time that the invitation expires. This is the <code>CreationDate</code> plus the
         *        <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>.
         *        After this date and time, the invitee can no longer create a member and join the network using this
         *        <code>InvitationId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * The status of the invitation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not
         * yet expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCEPTED</code> - The invitee created a member and joined the network using the
         * <code>InvitationID</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The invitee rejected the invitation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
         * <code>ExpirationDate</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the invitation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation
         *        has not yet expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCEPTED</code> - The invitee created a member and joined the network using the
         *        <code>InvitationID</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The invitee rejected the invitation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
         *        <code>ExpirationDate</code>.
         *        </p>
         *        </li>
         * @see InvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvitationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the invitation:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation has not
         * yet expired.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACCEPTED</code> - The invitee created a member and joined the network using the
         * <code>InvitationID</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The invitee rejected the invitation.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
         * <code>ExpirationDate</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the invitation:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - The invitee has not created a member to join the network, and the invitation
         *        has not yet expired.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCEPTING</code> - The invitee has begun creating a member, and creation has not yet completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACCEPTED</code> - The invitee created a member and joined the network using the
         *        <code>InvitationID</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The invitee rejected the invitation.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the
         *        <code>ExpirationDate</code>.
         *        </p>
         *        </li>
         * @see InvitationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvitationStatus
         */
        Builder status(InvitationStatus status);

        /**
         * Sets the value of the NetworkSummary property for this object.
         *
         * @param networkSummary
         *        The new value for the NetworkSummary property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSummary(NetworkSummary networkSummary);

        /**
         * Sets the value of the NetworkSummary property for this object.
         *
         * This is a convenience that creates an instance of the {@link NetworkSummary.Builder} avoiding the need to
         * create one manually via {@link NetworkSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #networkSummary(NetworkSummary)}.
         * 
         * @param networkSummary
         *        a consumer that will call methods on {@link NetworkSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSummary(NetworkSummary)
         */
        default Builder networkSummary(Consumer<NetworkSummary.Builder> networkSummary) {
            return networkSummary(NetworkSummary.builder().applyMutation(networkSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String invitationId;

        private Instant creationDate;

        private Instant expirationDate;

        private String status;

        private NetworkSummary networkSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(Invitation model) {
            invitationId(model.invitationId);
            creationDate(model.creationDate);
            expirationDate(model.expirationDate);
            status(model.status);
            networkSummary(model.networkSummary);
        }

        public final String getInvitationId() {
            return invitationId;
        }

        @Override
        public final Builder invitationId(String invitationId) {
            this.invitationId = invitationId;
            return this;
        }

        public final void setInvitationId(String invitationId) {
            this.invitationId = invitationId;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InvitationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final NetworkSummary.Builder getNetworkSummary() {
            return networkSummary != null ? networkSummary.toBuilder() : null;
        }

        @Override
        public final Builder networkSummary(NetworkSummary networkSummary) {
            this.networkSummary = networkSummary;
            return this;
        }

        public final void setNetworkSummary(NetworkSummary.BuilderImpl networkSummary) {
            this.networkSummary = networkSummary != null ? networkSummary.build() : null;
        }

        @Override
        public Invitation build() {
            return new Invitation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
