/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProposalResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<GetProposalResponse.Builder, GetProposalResponse> {
    private static final SdkField<Proposal> PROPOSAL_FIELD = SdkField.<Proposal> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetProposalResponse::proposal)).setter(setter(Builder::proposal)).constructor(Proposal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proposal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_FIELD));

    private final Proposal proposal;

    private GetProposalResponse(BuilderImpl builder) {
        super(builder);
        this.proposal = builder.proposal;
    }

    /**
     * <p>
     * Information about a proposal.
     * </p>
     * 
     * @return Information about a proposal.
     */
    public Proposal proposal() {
        return proposal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proposal());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProposalResponse)) {
            return false;
        }
        GetProposalResponse other = (GetProposalResponse) obj;
        return Objects.equals(proposal(), other.proposal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetProposalResponse").add("Proposal", proposal()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Proposal":
            return Optional.ofNullable(clazz.cast(proposal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProposalResponse, T> g) {
        return obj -> g.apply((GetProposalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetProposalResponse> {
        /**
         * <p>
         * Information about a proposal.
         * </p>
         * 
         * @param proposal
         *        Information about a proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposal(Proposal proposal);

        /**
         * <p>
         * Information about a proposal.
         * </p>
         * This is a convenience that creates an instance of the {@link Proposal.Builder} avoiding the need to create
         * one manually via {@link Proposal#builder()}.
         *
         * When the {@link Consumer} completes, {@link Proposal.Builder#build()} is called immediately and its result is
         * passed to {@link #proposal(Proposal)}.
         * 
         * @param proposal
         *        a consumer that will call methods on {@link Proposal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposal(Proposal)
         */
        default Builder proposal(Consumer<Proposal.Builder> proposal) {
            return proposal(Proposal.builder().applyMutation(proposal).build());
        }
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private Proposal proposal;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProposalResponse model) {
            super(model);
            proposal(model.proposal);
        }

        public final Proposal.Builder getProposal() {
            return proposal != null ? proposal.toBuilder() : null;
        }

        @Override
        public final Builder proposal(Proposal proposal) {
            this.proposal = proposal;
            return this;
        }

        public final void setProposal(Proposal.BuilderImpl proposal) {
            this.proposal = proposal != null ? proposal.build() : null;
        }

        @Override
        public GetProposalResponse build() {
            return new GetProposalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
