/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties of a peer node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Node implements SdkPojo, Serializable, ToCopyableBuilder<Node.Builder, Node> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Node::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<NodeFrameworkAttributes> FRAMEWORK_ATTRIBUTES_FIELD = SdkField
            .<NodeFrameworkAttributes> builder(MarshallingType.SDK_POJO).getter(getter(Node::frameworkAttributes))
            .setter(setter(Builder::frameworkAttributes)).constructor(NodeFrameworkAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkAttributes").build())
            .build();

    private static final SdkField<NodeLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField
            .<NodeLogPublishingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(Node::logPublishingConfiguration))
            .setter(setter(Builder::logPublishingConfiguration))
            .constructor(NodeLogPublishingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Node::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Node::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            MEMBER_ID_FIELD, ID_FIELD, INSTANCE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, FRAMEWORK_ATTRIBUTES_FIELD,
            LOG_PUBLISHING_CONFIGURATION_FIELD, STATUS_FIELD, CREATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String networkId;

    private final String memberId;

    private final String id;

    private final String instanceType;

    private final String availabilityZone;

    private final NodeFrameworkAttributes frameworkAttributes;

    private final NodeLogPublishingConfiguration logPublishingConfiguration;

    private final String status;

    private final Instant creationDate;

    private Node(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.id = builder.id;
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.frameworkAttributes = builder.frameworkAttributes;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
    }

    /**
     * <p>
     * The unique identifier of the network that the node is in.
     * </p>
     * 
     * @return The unique identifier of the network that the node is in.
     */
    public String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The unique identifier of the member to which the node belongs.
     * </p>
     * 
     * @return The unique identifier of the member to which the node belongs.
     */
    public String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The unique identifier of the node.
     * </p>
     * 
     * @return The unique identifier of the node.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The instance type of the node.
     * </p>
     * 
     * @return The instance type of the node.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Availability Zone in which the node exists.
     * </p>
     * 
     * @return The Availability Zone in which the node exists.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Attributes of the blockchain framework being used.
     * </p>
     * 
     * @return Attributes of the blockchain framework being used.
     */
    public NodeFrameworkAttributes frameworkAttributes() {
        return frameworkAttributes;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public NodeLogPublishingConfiguration logPublishingConfiguration() {
        return logPublishingConfiguration;
    }

    /**
     * <p>
     * The status of the node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the node.
     * @see NodeStatus
     */
    public NodeStatus status() {
        return NodeStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the node.
     * @see NodeStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the node was created.
     * </p>
     * 
     * @return The date and time that the node was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(memberId(), other.memberId())
                && Objects.equals(id(), other.id()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(frameworkAttributes(), other.frameworkAttributes())
                && Objects.equals(logPublishingConfiguration(), other.logPublishingConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Node").add("NetworkId", networkId()).add("MemberId", memberId()).add("Id", id())
                .add("InstanceType", instanceType()).add("AvailabilityZone", availabilityZone())
                .add("FrameworkAttributes", frameworkAttributes())
                .add("LogPublishingConfiguration", logPublishingConfiguration()).add("Status", statusAsString())
                .add("CreationDate", creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "FrameworkAttributes":
            return Optional.ofNullable(clazz.cast(frameworkAttributes()));
        case "LogPublishingConfiguration":
            return Optional.ofNullable(clazz.cast(logPublishingConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Node> {
        /**
         * <p>
         * The unique identifier of the network that the node is in.
         * </p>
         * 
         * @param networkId
         *        The unique identifier of the network that the node is in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The unique identifier of the member to which the node belongs.
         * </p>
         * 
         * @param memberId
         *        The unique identifier of the member to which the node belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The unique identifier of the node.
         * </p>
         * 
         * @param id
         *        The unique identifier of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The instance type of the node.
         * </p>
         * 
         * @param instanceType
         *        The instance type of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Availability Zone in which the node exists.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the node exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Attributes of the blockchain framework being used.
         * </p>
         * 
         * @param frameworkAttributes
         *        Attributes of the blockchain framework being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkAttributes(NodeFrameworkAttributes frameworkAttributes);

        /**
         * <p>
         * Attributes of the blockchain framework being used.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeFrameworkAttributes.Builder} avoiding the
         * need to create one manually via {@link NodeFrameworkAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeFrameworkAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #frameworkAttributes(NodeFrameworkAttributes)}.
         * 
         * @param frameworkAttributes
         *        a consumer that will call methods on {@link NodeFrameworkAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkAttributes(NodeFrameworkAttributes)
         */
        default Builder frameworkAttributes(Consumer<NodeFrameworkAttributes.Builder> frameworkAttributes) {
            return frameworkAttributes(NodeFrameworkAttributes.builder().applyMutation(frameworkAttributes).build());
        }

        /**
         * <p/>
         * 
         * @param logPublishingConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link NodeLogPublishingConfiguration.Builder} avoiding
         * the need to create one manually via {@link NodeLogPublishingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeLogPublishingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logPublishingConfiguration(NodeLogPublishingConfiguration)}.
         * 
         * @param logPublishingConfiguration
         *        a consumer that will call methods on {@link NodeLogPublishingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingConfiguration(NodeLogPublishingConfiguration)
         */
        default Builder logPublishingConfiguration(Consumer<NodeLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return logPublishingConfiguration(NodeLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)
                    .build());
        }

        /**
         * <p>
         * The status of the node.
         * </p>
         * 
         * @param status
         *        The status of the node.
         * @see NodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the node.
         * </p>
         * 
         * @param status
         *        The status of the node.
         * @see NodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeStatus
         */
        Builder status(NodeStatus status);

        /**
         * <p>
         * The date and time that the node was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time that the node was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);
    }

    static final class BuilderImpl implements Builder {
        private String networkId;

        private String memberId;

        private String id;

        private String instanceType;

        private String availabilityZone;

        private NodeFrameworkAttributes frameworkAttributes;

        private NodeLogPublishingConfiguration logPublishingConfiguration;

        private String status;

        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            networkId(model.networkId);
            memberId(model.memberId);
            id(model.id);
            instanceType(model.instanceType);
            availabilityZone(model.availabilityZone);
            frameworkAttributes(model.frameworkAttributes);
            logPublishingConfiguration(model.logPublishingConfiguration);
            status(model.status);
            creationDate(model.creationDate);
        }

        public final String getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getMemberId() {
            return memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final NodeFrameworkAttributes.Builder getFrameworkAttributes() {
            return frameworkAttributes != null ? frameworkAttributes.toBuilder() : null;
        }

        @Override
        public final Builder frameworkAttributes(NodeFrameworkAttributes frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes;
            return this;
        }

        public final void setFrameworkAttributes(NodeFrameworkAttributes.BuilderImpl frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes != null ? frameworkAttributes.build() : null;
        }

        public final NodeLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return logPublishingConfiguration != null ? logPublishingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final void setLogPublishingConfiguration(NodeLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NodeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public Node build() {
            return new Node(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
