/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties for logging events associated with a member of a Managed Blockchain network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberLogPublishingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberLogPublishingConfiguration.Builder, MemberLogPublishingConfiguration> {
    private static final SdkField<MemberFabricLogPublishingConfiguration> FABRIC_FIELD = SdkField
            .<MemberFabricLogPublishingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(MemberLogPublishingConfiguration::fabric)).setter(setter(Builder::fabric))
            .constructor(MemberFabricLogPublishingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final MemberFabricLogPublishingConfiguration fabric;

    private MemberLogPublishingConfiguration(BuilderImpl builder) {
        this.fabric = builder.fabric;
    }

    /**
     * <p>
     * Configuration properties for logging events associated with a member of a Managed Blockchain network using the
     * Hyperledger Fabric framework.
     * </p>
     * 
     * @return Configuration properties for logging events associated with a member of a Managed Blockchain network
     *         using the Hyperledger Fabric framework.
     */
    public MemberFabricLogPublishingConfiguration fabric() {
        return fabric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fabric());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberLogPublishingConfiguration)) {
            return false;
        }
        MemberLogPublishingConfiguration other = (MemberLogPublishingConfiguration) obj;
        return Objects.equals(fabric(), other.fabric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MemberLogPublishingConfiguration").add("Fabric", fabric()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fabric":
            return Optional.ofNullable(clazz.cast(fabric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberLogPublishingConfiguration, T> g) {
        return obj -> g.apply((MemberLogPublishingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberLogPublishingConfiguration> {
        /**
         * <p>
         * Configuration properties for logging events associated with a member of a Managed Blockchain network using
         * the Hyperledger Fabric framework.
         * </p>
         * 
         * @param fabric
         *        Configuration properties for logging events associated with a member of a Managed Blockchain network
         *        using the Hyperledger Fabric framework.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fabric(MemberFabricLogPublishingConfiguration fabric);

        /**
         * <p>
         * Configuration properties for logging events associated with a member of a Managed Blockchain network using
         * the Hyperledger Fabric framework.
         * </p>
         * This is a convenience that creates an instance of the {@link MemberFabricLogPublishingConfiguration.Builder}
         * avoiding the need to create one manually via {@link MemberFabricLogPublishingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemberFabricLogPublishingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #fabric(MemberFabricLogPublishingConfiguration)}.
         * 
         * @param fabric
         *        a consumer that will call methods on {@link MemberFabricLogPublishingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fabric(MemberFabricLogPublishingConfiguration)
         */
        default Builder fabric(Consumer<MemberFabricLogPublishingConfiguration.Builder> fabric) {
            return fabric(MemberFabricLogPublishingConfiguration.builder().applyMutation(fabric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MemberFabricLogPublishingConfiguration fabric;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberLogPublishingConfiguration model) {
            fabric(model.fabric);
        }

        public final MemberFabricLogPublishingConfiguration.Builder getFabric() {
            return fabric != null ? fabric.toBuilder() : null;
        }

        @Override
        public final Builder fabric(MemberFabricLogPublishingConfiguration fabric) {
            this.fabric = fabric;
            return this;
        }

        public final void setFabric(MemberFabricLogPublishingConfiguration.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        @Override
        public MemberLogPublishingConfiguration build() {
            return new MemberLogPublishingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
