/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.UsageByAccount;
import software.amazon.awssdk.services.macie2.model.___listOfUsageByAccountCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageRecord> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(UsageRecord.getter(UsageRecord::accountId)).setter(UsageRecord.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Instant> AUTOMATED_DISCOVERY_FREE_TRIAL_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("automatedDiscoveryFreeTrialStartDate").getter(UsageRecord.getter(UsageRecord::automatedDiscoveryFreeTrialStartDate)).setter(UsageRecord.setter(Builder::automatedDiscoveryFreeTrialStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automatedDiscoveryFreeTrialStartDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> FREE_TRIAL_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("freeTrialStartDate").getter(UsageRecord.getter(UsageRecord::freeTrialStartDate)).setter(UsageRecord.setter(Builder::freeTrialStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialStartDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<UsageByAccount>> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usage").getter(UsageRecord.getter(UsageRecord::usage)).setter(UsageRecord.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageByAccount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AUTOMATED_DISCOVERY_FREE_TRIAL_START_DATE_FIELD, FREE_TRIAL_START_DATE_FIELD, USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UsageRecord.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Instant automatedDiscoveryFreeTrialStartDate;
    private final Instant freeTrialStartDate;
    private final List<UsageByAccount> usage;

    private UsageRecord(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.automatedDiscoveryFreeTrialStartDate = builder.automatedDiscoveryFreeTrialStartDate;
        this.freeTrialStartDate = builder.freeTrialStartDate;
        this.usage = builder.usage;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Instant automatedDiscoveryFreeTrialStartDate() {
        return this.automatedDiscoveryFreeTrialStartDate;
    }

    public final Instant freeTrialStartDate() {
        return this.freeTrialStartDate;
    }

    public final boolean hasUsage() {
        return this.usage != null && !(this.usage instanceof SdkAutoConstructList);
    }

    public final List<UsageByAccount> usage() {
        return this.usage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedDiscoveryFreeTrialStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeTrialStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsage() ? this.usage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageRecord)) {
            return false;
        }
        UsageRecord other = (UsageRecord)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.automatedDiscoveryFreeTrialStartDate(), other.automatedDiscoveryFreeTrialStartDate()) && Objects.equals(this.freeTrialStartDate(), other.freeTrialStartDate()) && this.hasUsage() == other.hasUsage() && Objects.equals(this.usage(), other.usage());
    }

    public final String toString() {
        return ToString.builder((String)"UsageRecord").add("AccountId", (Object)this.accountId()).add("AutomatedDiscoveryFreeTrialStartDate", (Object)this.automatedDiscoveryFreeTrialStartDate()).add("FreeTrialStartDate", (Object)this.freeTrialStartDate()).add("Usage", this.hasUsage() ? this.usage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "automatedDiscoveryFreeTrialStartDate": {
                return Optional.ofNullable(clazz.cast(this.automatedDiscoveryFreeTrialStartDate()));
            }
            case "freeTrialStartDate": {
                return Optional.ofNullable(clazz.cast(this.freeTrialStartDate()));
            }
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("automatedDiscoveryFreeTrialStartDate", AUTOMATED_DISCOVERY_FREE_TRIAL_START_DATE_FIELD);
        map.put("freeTrialStartDate", FREE_TRIAL_START_DATE_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageRecord, T> g) {
        return obj -> g.apply((UsageRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Instant automatedDiscoveryFreeTrialStartDate;
        private Instant freeTrialStartDate;
        private List<UsageByAccount> usage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UsageRecord model) {
            this.accountId(model.accountId);
            this.automatedDiscoveryFreeTrialStartDate(model.automatedDiscoveryFreeTrialStartDate);
            this.freeTrialStartDate(model.freeTrialStartDate);
            this.usage(model.usage);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Instant getAutomatedDiscoveryFreeTrialStartDate() {
            return this.automatedDiscoveryFreeTrialStartDate;
        }

        public final void setAutomatedDiscoveryFreeTrialStartDate(Instant automatedDiscoveryFreeTrialStartDate) {
            this.automatedDiscoveryFreeTrialStartDate = automatedDiscoveryFreeTrialStartDate;
        }

        @Override
        public final Builder automatedDiscoveryFreeTrialStartDate(Instant automatedDiscoveryFreeTrialStartDate) {
            this.automatedDiscoveryFreeTrialStartDate = automatedDiscoveryFreeTrialStartDate;
            return this;
        }

        public final Instant getFreeTrialStartDate() {
            return this.freeTrialStartDate;
        }

        public final void setFreeTrialStartDate(Instant freeTrialStartDate) {
            this.freeTrialStartDate = freeTrialStartDate;
        }

        @Override
        public final Builder freeTrialStartDate(Instant freeTrialStartDate) {
            this.freeTrialStartDate = freeTrialStartDate;
            return this;
        }

        public final List<UsageByAccount.Builder> getUsage() {
            List<UsageByAccount.Builder> result = ___listOfUsageByAccountCopier.copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<UsageByAccount.BuilderImpl> usage) {
            this.usage = ___listOfUsageByAccountCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<UsageByAccount> usage) {
            this.usage = ___listOfUsageByAccountCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(UsageByAccount ... usage) {
            this.usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<UsageByAccount.Builder> ... usage) {
            this.usage(Stream.of(usage).map(c -> (UsageByAccount)((UsageByAccount.Builder)UsageByAccount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UsageRecord build() {
            return new UsageRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageRecord> {
        public Builder accountId(String var1);

        public Builder automatedDiscoveryFreeTrialStartDate(Instant var1);

        public Builder freeTrialStartDate(Instant var1);

        public Builder usage(Collection<UsageByAccount> var1);

        public Builder usage(UsageByAccount ... var1);

        public Builder usage(Consumer<UsageByAccount.Builder> ... var1);
    }
}

