/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.ClassificationResult;
import software.amazon.awssdk.services.macie2.model.OriginType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClassificationDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClassificationDetails> {
    private static final SdkField<String> DETAILED_RESULTS_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detailedResultsLocation").getter(ClassificationDetails.getter(ClassificationDetails::detailedResultsLocation)).setter(ClassificationDetails.setter(Builder::detailedResultsLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detailedResultsLocation").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(ClassificationDetails.getter(ClassificationDetails::jobArn)).setter(ClassificationDetails.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(ClassificationDetails.getter(ClassificationDetails::jobId)).setter(ClassificationDetails.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> ORIGIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("originType").getter(ClassificationDetails.getter(ClassificationDetails::originTypeAsString)).setter(ClassificationDetails.setter(Builder::originType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originType").build()}).build();
    private static final SdkField<ClassificationResult> RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("result").getter(ClassificationDetails.getter(ClassificationDetails::result)).setter(ClassificationDetails.setter(Builder::result)).constructor(ClassificationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAILED_RESULTS_LOCATION_FIELD, JOB_ARN_FIELD, JOB_ID_FIELD, ORIGIN_TYPE_FIELD, RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClassificationDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String detailedResultsLocation;
    private final String jobArn;
    private final String jobId;
    private final String originType;
    private final ClassificationResult result;

    private ClassificationDetails(BuilderImpl builder) {
        this.detailedResultsLocation = builder.detailedResultsLocation;
        this.jobArn = builder.jobArn;
        this.jobId = builder.jobId;
        this.originType = builder.originType;
        this.result = builder.result;
    }

    public final String detailedResultsLocation() {
        return this.detailedResultsLocation;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final OriginType originType() {
        return OriginType.fromValue(this.originType);
    }

    public final String originTypeAsString() {
        return this.originType;
    }

    public final ClassificationResult result() {
        return this.result;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedResultsLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.originTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.result());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassificationDetails)) {
            return false;
        }
        ClassificationDetails other = (ClassificationDetails)obj;
        return Objects.equals(this.detailedResultsLocation(), other.detailedResultsLocation()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.originTypeAsString(), other.originTypeAsString()) && Objects.equals(this.result(), other.result());
    }

    public final String toString() {
        return ToString.builder((String)"ClassificationDetails").add("DetailedResultsLocation", (Object)this.detailedResultsLocation()).add("JobArn", (Object)this.jobArn()).add("JobId", (Object)this.jobId()).add("OriginType", (Object)this.originTypeAsString()).add("Result", (Object)this.result()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detailedResultsLocation": {
                return Optional.ofNullable(clazz.cast(this.detailedResultsLocation()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "originType": {
                return Optional.ofNullable(clazz.cast(this.originTypeAsString()));
            }
            case "result": {
                return Optional.ofNullable(clazz.cast(this.result()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detailedResultsLocation", DETAILED_RESULTS_LOCATION_FIELD);
        map.put("jobArn", JOB_ARN_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("originType", ORIGIN_TYPE_FIELD);
        map.put("result", RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClassificationDetails, T> g) {
        return obj -> g.apply((ClassificationDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String detailedResultsLocation;
        private String jobArn;
        private String jobId;
        private String originType;
        private ClassificationResult result;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassificationDetails model) {
            this.detailedResultsLocation(model.detailedResultsLocation);
            this.jobArn(model.jobArn);
            this.jobId(model.jobId);
            this.originType(model.originType);
            this.result(model.result);
        }

        public final String getDetailedResultsLocation() {
            return this.detailedResultsLocation;
        }

        public final void setDetailedResultsLocation(String detailedResultsLocation) {
            this.detailedResultsLocation = detailedResultsLocation;
        }

        @Override
        public final Builder detailedResultsLocation(String detailedResultsLocation) {
            this.detailedResultsLocation = detailedResultsLocation;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getOriginType() {
            return this.originType;
        }

        public final void setOriginType(String originType) {
            this.originType = originType;
        }

        @Override
        public final Builder originType(String originType) {
            this.originType = originType;
            return this;
        }

        @Override
        public final Builder originType(OriginType originType) {
            this.originType(originType == null ? null : originType.toString());
            return this;
        }

        public final ClassificationResult.Builder getResult() {
            return this.result != null ? this.result.toBuilder() : null;
        }

        public final void setResult(ClassificationResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(ClassificationResult result) {
            this.result = result;
            return this;
        }

        public ClassificationDetails build() {
            return new ClassificationDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClassificationDetails> {
        public Builder detailedResultsLocation(String var1);

        public Builder jobArn(String var1);

        public Builder jobId(String var1);

        public Builder originType(String var1);

        public Builder originType(OriginType var1);

        public Builder result(ClassificationResult var1);

        default public Builder result(Consumer<ClassificationResult.Builder> result) {
            return this.result((ClassificationResult)((ClassificationResult.Builder)ClassificationResult.builder().applyMutation(result)).build());
        }
    }
}

