/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides processing statistics for a classification job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Statistics implements SdkPojo, Serializable, ToCopyableBuilder<Statistics.Builder, Statistics> {
    private static final SdkField<Double> APPROXIMATE_NUMBER_OF_OBJECTS_TO_PROCESS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("approximateNumberOfObjectsToProcess")
            .getter(getter(Statistics::approximateNumberOfObjectsToProcess))
            .setter(setter(Builder::approximateNumberOfObjectsToProcess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("approximateNumberOfObjectsToProcess").build()).build();

    private static final SdkField<Double> NUMBER_OF_RUNS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("numberOfRuns").getter(getter(Statistics::numberOfRuns)).setter(setter(Builder::numberOfRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfRuns").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROXIMATE_NUMBER_OF_OBJECTS_TO_PROCESS_FIELD, NUMBER_OF_RUNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double approximateNumberOfObjectsToProcess;

    private final Double numberOfRuns;

    private Statistics(BuilderImpl builder) {
        this.approximateNumberOfObjectsToProcess = builder.approximateNumberOfObjectsToProcess;
        this.numberOfRuns = builder.numberOfRuns;
    }

    /**
     * <p>
     * The approximate number of objects that the job has yet to process during its current run.
     * </p>
     * 
     * @return The approximate number of objects that the job has yet to process during its current run.
     */
    public final Double approximateNumberOfObjectsToProcess() {
        return approximateNumberOfObjectsToProcess;
    }

    /**
     * <p>
     * The number of times that the job has run.
     * </p>
     * 
     * @return The number of times that the job has run.
     */
    public final Double numberOfRuns() {
        return numberOfRuns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateNumberOfObjectsToProcess());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRuns());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statistics)) {
            return false;
        }
        Statistics other = (Statistics) obj;
        return Objects.equals(approximateNumberOfObjectsToProcess(), other.approximateNumberOfObjectsToProcess())
                && Objects.equals(numberOfRuns(), other.numberOfRuns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Statistics").add("ApproximateNumberOfObjectsToProcess", approximateNumberOfObjectsToProcess())
                .add("NumberOfRuns", numberOfRuns()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approximateNumberOfObjectsToProcess":
            return Optional.ofNullable(clazz.cast(approximateNumberOfObjectsToProcess()));
        case "numberOfRuns":
            return Optional.ofNullable(clazz.cast(numberOfRuns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("approximateNumberOfObjectsToProcess", APPROXIMATE_NUMBER_OF_OBJECTS_TO_PROCESS_FIELD);
        map.put("numberOfRuns", NUMBER_OF_RUNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Statistics, T> g) {
        return obj -> g.apply((Statistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Statistics> {
        /**
         * <p>
         * The approximate number of objects that the job has yet to process during its current run.
         * </p>
         * 
         * @param approximateNumberOfObjectsToProcess
         *        The approximate number of objects that the job has yet to process during its current run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateNumberOfObjectsToProcess(Double approximateNumberOfObjectsToProcess);

        /**
         * <p>
         * The number of times that the job has run.
         * </p>
         * 
         * @param numberOfRuns
         *        The number of times that the job has run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRuns(Double numberOfRuns);
    }

    static final class BuilderImpl implements Builder {
        private Double approximateNumberOfObjectsToProcess;

        private Double numberOfRuns;

        private BuilderImpl() {
        }

        private BuilderImpl(Statistics model) {
            approximateNumberOfObjectsToProcess(model.approximateNumberOfObjectsToProcess);
            numberOfRuns(model.numberOfRuns);
        }

        public final Double getApproximateNumberOfObjectsToProcess() {
            return approximateNumberOfObjectsToProcess;
        }

        public final void setApproximateNumberOfObjectsToProcess(Double approximateNumberOfObjectsToProcess) {
            this.approximateNumberOfObjectsToProcess = approximateNumberOfObjectsToProcess;
        }

        @Override
        public final Builder approximateNumberOfObjectsToProcess(Double approximateNumberOfObjectsToProcess) {
            this.approximateNumberOfObjectsToProcess = approximateNumberOfObjectsToProcess;
            return this;
        }

        public final Double getNumberOfRuns() {
            return numberOfRuns;
        }

        public final void setNumberOfRuns(Double numberOfRuns) {
            this.numberOfRuns = numberOfRuns;
        }

        @Override
        public final Builder numberOfRuns(Double numberOfRuns) {
            this.numberOfRuns = numberOfRuns;
            return this;
        }

        @Override
        public Statistics build() {
            return new Statistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
