/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the operator to use in a property-based condition that filters the results of a query for findings. For
 * detailed information and examples of each operator, see <a
 * href="https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html">Fundamentals of filtering
 * findings</a> in the <i>Amazon Macie User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CriterionAdditionalProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<CriterionAdditionalProperties.Builder, CriterionAdditionalProperties> {
    private static final SdkField<List<String>> EQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eq")
            .getter(getter(CriterionAdditionalProperties::eq))
            .setter(setter(Builder::eq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EQ_EXACT_MATCH_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("eqExactMatch")
            .getter(getter(CriterionAdditionalProperties::eqExactMatch))
            .setter(setter(Builder::eqExactMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eqExactMatch").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> GT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("gt")
            .getter(getter(CriterionAdditionalProperties::gt)).setter(setter(Builder::gt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gt").build()).build();

    private static final SdkField<Long> GTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("gte")
            .getter(getter(CriterionAdditionalProperties::gte)).setter(setter(Builder::gte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gte").build()).build();

    private static final SdkField<Long> LT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("lt")
            .getter(getter(CriterionAdditionalProperties::lt)).setter(setter(Builder::lt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lt").build()).build();

    private static final SdkField<Long> LTE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("lte")
            .getter(getter(CriterionAdditionalProperties::lte)).setter(setter(Builder::lte))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lte").build()).build();

    private static final SdkField<List<String>> NEQ_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("neq")
            .getter(getter(CriterionAdditionalProperties::neq))
            .setter(setter(Builder::neq))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neq").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQ_FIELD,
            EQ_EXACT_MATCH_FIELD, GT_FIELD, GTE_FIELD, LT_FIELD, LTE_FIELD, NEQ_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> eq;

    private final List<String> eqExactMatch;

    private final Long gt;

    private final Long gte;

    private final Long lt;

    private final Long lte;

    private final List<String> neq;

    private CriterionAdditionalProperties(BuilderImpl builder) {
        this.eq = builder.eq;
        this.eqExactMatch = builder.eqExactMatch;
        this.gt = builder.gt;
        this.gte = builder.gte;
        this.lt = builder.lt;
        this.lte = builder.lte;
        this.neq = builder.neq;
    }

    /**
     * For responses, this returns true if the service returned a value for the Eq property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasEq() {
        return eq != null && !(eq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR
     * logic to join the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEq} method.
     * </p>
     * 
     * @return The value for the property matches (equals) the specified value. If you specify multiple values, Macie
     *         uses OR logic to join the values.
     */
    public final List<String> eq() {
        return eq;
    }

    /**
     * For responses, this returns true if the service returned a value for the EqExactMatch property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEqExactMatch() {
        return eqExactMatch != null && !(eqExactMatch instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value for the property exclusively matches (equals an exact match for) all the specified values. If you
     * specify multiple values, Amazon Macie uses AND logic to join the values.
     * </p>
     * <p>
     * You can use this operator with the following properties: customDataIdentifiers.detections.arn,
     * customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
     * resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
     * resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEqExactMatch} method.
     * </p>
     * 
     * @return The value for the property exclusively matches (equals an exact match for) all the specified values. If
     *         you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
     *         <p>
     *         You can use this operator with the following properties: customDataIdentifiers.detections.arn,
     *         customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
     *         resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
     *         resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
     */
    public final List<String> eqExactMatch() {
        return eqExactMatch;
    }

    /**
     * <p>
     * The value for the property is greater than the specified value.
     * </p>
     * 
     * @return The value for the property is greater than the specified value.
     */
    public final Long gt() {
        return gt;
    }

    /**
     * <p>
     * The value for the property is greater than or equal to the specified value.
     * </p>
     * 
     * @return The value for the property is greater than or equal to the specified value.
     */
    public final Long gte() {
        return gte;
    }

    /**
     * <p>
     * The value for the property is less than the specified value.
     * </p>
     * 
     * @return The value for the property is less than the specified value.
     */
    public final Long lt() {
        return lt;
    }

    /**
     * <p>
     * The value for the property is less than or equal to the specified value.
     * </p>
     * 
     * @return The value for the property is less than or equal to the specified value.
     */
    public final Long lte() {
        return lte;
    }

    /**
     * For responses, this returns true if the service returned a value for the Neq property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNeq() {
        return neq != null && !(neq instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values,
     * Macie uses OR logic to join the values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNeq} method.
     * </p>
     * 
     * @return The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple
     *         values, Macie uses OR logic to join the values.
     */
    public final List<String> neq() {
        return neq;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEq() ? eq() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEqExactMatch() ? eqExactMatch() : null);
        hashCode = 31 * hashCode + Objects.hashCode(gt());
        hashCode = 31 * hashCode + Objects.hashCode(gte());
        hashCode = 31 * hashCode + Objects.hashCode(lt());
        hashCode = 31 * hashCode + Objects.hashCode(lte());
        hashCode = 31 * hashCode + Objects.hashCode(hasNeq() ? neq() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CriterionAdditionalProperties)) {
            return false;
        }
        CriterionAdditionalProperties other = (CriterionAdditionalProperties) obj;
        return hasEq() == other.hasEq() && Objects.equals(eq(), other.eq()) && hasEqExactMatch() == other.hasEqExactMatch()
                && Objects.equals(eqExactMatch(), other.eqExactMatch()) && Objects.equals(gt(), other.gt())
                && Objects.equals(gte(), other.gte()) && Objects.equals(lt(), other.lt()) && Objects.equals(lte(), other.lte())
                && hasNeq() == other.hasNeq() && Objects.equals(neq(), other.neq());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CriterionAdditionalProperties").add("Eq", hasEq() ? eq() : null)
                .add("EqExactMatch", hasEqExactMatch() ? eqExactMatch() : null).add("Gt", gt()).add("Gte", gte()).add("Lt", lt())
                .add("Lte", lte()).add("Neq", hasNeq() ? neq() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "eq":
            return Optional.ofNullable(clazz.cast(eq()));
        case "eqExactMatch":
            return Optional.ofNullable(clazz.cast(eqExactMatch()));
        case "gt":
            return Optional.ofNullable(clazz.cast(gt()));
        case "gte":
            return Optional.ofNullable(clazz.cast(gte()));
        case "lt":
            return Optional.ofNullable(clazz.cast(lt()));
        case "lte":
            return Optional.ofNullable(clazz.cast(lte()));
        case "neq":
            return Optional.ofNullable(clazz.cast(neq()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("eq", EQ_FIELD);
        map.put("eqExactMatch", EQ_EXACT_MATCH_FIELD);
        map.put("gt", GT_FIELD);
        map.put("gte", GTE_FIELD);
        map.put("lt", LT_FIELD);
        map.put("lte", LTE_FIELD);
        map.put("neq", NEQ_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CriterionAdditionalProperties, T> g) {
        return obj -> g.apply((CriterionAdditionalProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CriterionAdditionalProperties> {
        /**
         * <p>
         * The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses
         * OR logic to join the values.
         * </p>
         * 
         * @param eq
         *        The value for the property matches (equals) the specified value. If you specify multiple values, Macie
         *        uses OR logic to join the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(Collection<String> eq);

        /**
         * <p>
         * The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses
         * OR logic to join the values.
         * </p>
         * 
         * @param eq
         *        The value for the property matches (equals) the specified value. If you specify multiple values, Macie
         *        uses OR logic to join the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eq(String... eq);

        /**
         * <p>
         * The value for the property exclusively matches (equals an exact match for) all the specified values. If you
         * specify multiple values, Amazon Macie uses AND logic to join the values.
         * </p>
         * <p>
         * You can use this operator with the following properties: customDataIdentifiers.detections.arn,
         * customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         * resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         * resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * </p>
         * 
         * @param eqExactMatch
         *        The value for the property exclusively matches (equals an exact match for) all the specified values.
         *        If you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
         *        <p>
         *        You can use this operator with the following properties: customDataIdentifiers.detections.arn,
         *        customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         *        resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         *        resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eqExactMatch(Collection<String> eqExactMatch);

        /**
         * <p>
         * The value for the property exclusively matches (equals an exact match for) all the specified values. If you
         * specify multiple values, Amazon Macie uses AND logic to join the values.
         * </p>
         * <p>
         * You can use this operator with the following properties: customDataIdentifiers.detections.arn,
         * customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         * resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         * resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * </p>
         * 
         * @param eqExactMatch
         *        The value for the property exclusively matches (equals an exact match for) all the specified values.
         *        If you specify multiple values, Amazon Macie uses AND logic to join the values.</p>
         *        <p>
         *        You can use this operator with the following properties: customDataIdentifiers.detections.arn,
         *        customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key,
         *        resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key,
         *        resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eqExactMatch(String... eqExactMatch);

        /**
         * <p>
         * The value for the property is greater than the specified value.
         * </p>
         * 
         * @param gt
         *        The value for the property is greater than the specified value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gt(Long gt);

        /**
         * <p>
         * The value for the property is greater than or equal to the specified value.
         * </p>
         * 
         * @param gte
         *        The value for the property is greater than or equal to the specified value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gte(Long gte);

        /**
         * <p>
         * The value for the property is less than the specified value.
         * </p>
         * 
         * @param lt
         *        The value for the property is less than the specified value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lt(Long lt);

        /**
         * <p>
         * The value for the property is less than or equal to the specified value.
         * </p>
         * 
         * @param lte
         *        The value for the property is less than or equal to the specified value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lte(Long lte);

        /**
         * <p>
         * The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values,
         * Macie uses OR logic to join the values.
         * </p>
         * 
         * @param neq
         *        The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple
         *        values, Macie uses OR logic to join the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(Collection<String> neq);

        /**
         * <p>
         * The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values,
         * Macie uses OR logic to join the values.
         * </p>
         * 
         * @param neq
         *        The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple
         *        values, Macie uses OR logic to join the values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neq(String... neq);
    }

    static final class BuilderImpl implements Builder {
        private List<String> eq = DefaultSdkAutoConstructList.getInstance();

        private List<String> eqExactMatch = DefaultSdkAutoConstructList.getInstance();

        private Long gt;

        private Long gte;

        private Long lt;

        private Long lte;

        private List<String> neq = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CriterionAdditionalProperties model) {
            eq(model.eq);
            eqExactMatch(model.eqExactMatch);
            gt(model.gt);
            gte(model.gte);
            lt(model.lt);
            lte(model.lte);
            neq(model.neq);
        }

        public final Collection<String> getEq() {
            if (eq instanceof SdkAutoConstructList) {
                return null;
            }
            return eq;
        }

        public final void setEq(Collection<String> eq) {
            this.eq = ___listOf__stringCopier.copy(eq);
        }

        @Override
        public final Builder eq(Collection<String> eq) {
            this.eq = ___listOf__stringCopier.copy(eq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eq(String... eq) {
            eq(Arrays.asList(eq));
            return this;
        }

        public final Collection<String> getEqExactMatch() {
            if (eqExactMatch instanceof SdkAutoConstructList) {
                return null;
            }
            return eqExactMatch;
        }

        public final void setEqExactMatch(Collection<String> eqExactMatch) {
            this.eqExactMatch = ___listOf__stringCopier.copy(eqExactMatch);
        }

        @Override
        public final Builder eqExactMatch(Collection<String> eqExactMatch) {
            this.eqExactMatch = ___listOf__stringCopier.copy(eqExactMatch);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eqExactMatch(String... eqExactMatch) {
            eqExactMatch(Arrays.asList(eqExactMatch));
            return this;
        }

        public final Long getGt() {
            return gt;
        }

        public final void setGt(Long gt) {
            this.gt = gt;
        }

        @Override
        public final Builder gt(Long gt) {
            this.gt = gt;
            return this;
        }

        public final Long getGte() {
            return gte;
        }

        public final void setGte(Long gte) {
            this.gte = gte;
        }

        @Override
        public final Builder gte(Long gte) {
            this.gte = gte;
            return this;
        }

        public final Long getLt() {
            return lt;
        }

        public final void setLt(Long lt) {
            this.lt = lt;
        }

        @Override
        public final Builder lt(Long lt) {
            this.lt = lt;
            return this;
        }

        public final Long getLte() {
            return lte;
        }

        public final void setLte(Long lte) {
            this.lte = lte;
        }

        @Override
        public final Builder lte(Long lte) {
            this.lte = lte;
            return this;
        }

        public final Collection<String> getNeq() {
            if (neq instanceof SdkAutoConstructList) {
                return null;
            }
            return neq;
        }

        public final void setNeq(Collection<String> neq) {
            this.neq = ___listOf__stringCopier.copy(neq);
        }

        @Override
        public final Builder neq(Collection<String> neq) {
            this.neq = ___listOf__stringCopier.copy(neq);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neq(String... neq) {
            neq(Arrays.asList(neq));
            return this;
        }

        @Override
        public CriterionAdditionalProperties build() {
            return new CriterionAdditionalProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
