/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInvitationsResponse extends Macie2Response implements
        ToCopyableBuilder<CreateInvitationsResponse.Builder, CreateInvitationsResponse> {
    private static final SdkField<List<UnprocessedAccount>> UNPROCESSED_ACCOUNTS_FIELD = SdkField
            .<List<UnprocessedAccount>> builder(MarshallingType.LIST)
            .memberName("unprocessedAccounts")
            .getter(getter(CreateInvitationsResponse::unprocessedAccounts))
            .setter(setter(Builder::unprocessedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedAccount> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedAccount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_ACCOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UnprocessedAccount> unprocessedAccounts;

    private CreateInvitationsResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAccounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUnprocessedAccounts() {
        return unprocessedAccounts != null && !(unprocessedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
     * account and explains why the invitation hasn't been processed for the account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAccounts} method.
     * </p>
     * 
     * @return An array of objects, one for each account whose invitation hasn't been processed. Each object identifies
     *         the account and explains why the invitation hasn't been processed for the account.
     */
    public final List<UnprocessedAccount> unprocessedAccounts() {
        return unprocessedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAccounts() ? unprocessedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInvitationsResponse)) {
            return false;
        }
        CreateInvitationsResponse other = (CreateInvitationsResponse) obj;
        return hasUnprocessedAccounts() == other.hasUnprocessedAccounts()
                && Objects.equals(unprocessedAccounts(), other.unprocessedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInvitationsResponse")
                .add("UnprocessedAccounts", hasUnprocessedAccounts() ? unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unprocessedAccounts":
            return Optional.ofNullable(clazz.cast(unprocessedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unprocessedAccounts", UNPROCESSED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInvitationsResponse, T> g) {
        return obj -> g.apply((CreateInvitationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateInvitationsResponse> {
        /**
         * <p>
         * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
         * account and explains why the invitation hasn't been processed for the account.
         * </p>
         * 
         * @param unprocessedAccounts
         *        An array of objects, one for each account whose invitation hasn't been processed. Each object
         *        identifies the account and explains why the invitation hasn't been processed for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts);

        /**
         * <p>
         * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
         * account and explains why the invitation hasn't been processed for the account.
         * </p>
         * 
         * @param unprocessedAccounts
         *        An array of objects, one for each account whose invitation hasn't been processed. Each object
         *        identifies the account and explains why the invitation hasn't been processed for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts);

        /**
         * <p>
         * An array of objects, one for each account whose invitation hasn't been processed. Each object identifies the
         * account and explains why the invitation hasn't been processed for the account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.macie2.model.UnprocessedAccount.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.macie2.model.UnprocessedAccount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.macie2.model.UnprocessedAccount.Builder#build()} is called immediately
         * and its result is passed to {@link #unprocessedAccounts(List<UnprocessedAccount>)}.
         * 
         * @param unprocessedAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.macie2.model.UnprocessedAccount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAccounts(java.util.Collection<UnprocessedAccount>)
         */
        Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private List<UnprocessedAccount> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInvitationsResponse model) {
            super(model);
            unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<UnprocessedAccount.Builder> getUnprocessedAccounts() {
            List<UnprocessedAccount.Builder> result = ___listOfUnprocessedAccountCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<UnprocessedAccount.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = ___listOfUnprocessedAccountCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<UnprocessedAccount> unprocessedAccounts) {
            this.unprocessedAccounts = ___listOfUnprocessedAccountCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(UnprocessedAccount... unprocessedAccounts) {
            unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<UnprocessedAccount.Builder>... unprocessedAccounts) {
            unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> UnprocessedAccount.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateInvitationsResponse build() {
            return new CreateInvitationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
