/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the status of automated sensitive data discovery for an Amazon Macie account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedDiscoveryAccount implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedDiscoveryAccount.Builder, AutomatedDiscoveryAccount> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AutomatedDiscoveryAccount::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AutomatedDiscoveryAccount::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String status;

    private AutomatedDiscoveryAccount(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the account.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the account.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The current status of automated sensitive data discovery for the account. Possible values are: ENABLED, perform
     * automated sensitive data discovery activities for the account; and, DISABLED, don't perform automated sensitive
     * data discovery activities for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedDiscoveryAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of automated sensitive data discovery for the account. Possible values are: ENABLED,
     *         perform automated sensitive data discovery activities for the account; and, DISABLED, don't perform
     *         automated sensitive data discovery activities for the account.
     * @see AutomatedDiscoveryAccountStatus
     */
    public final AutomatedDiscoveryAccountStatus status() {
        return AutomatedDiscoveryAccountStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of automated sensitive data discovery for the account. Possible values are: ENABLED, perform
     * automated sensitive data discovery activities for the account; and, DISABLED, don't perform automated sensitive
     * data discovery activities for the account.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AutomatedDiscoveryAccountStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of automated sensitive data discovery for the account. Possible values are: ENABLED,
     *         perform automated sensitive data discovery activities for the account; and, DISABLED, don't perform
     *         automated sensitive data discovery activities for the account.
     * @see AutomatedDiscoveryAccountStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedDiscoveryAccount)) {
            return false;
        }
        AutomatedDiscoveryAccount other = (AutomatedDiscoveryAccount) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedDiscoveryAccount").add("AccountId", accountId()).add("Status", statusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedDiscoveryAccount, T> g) {
        return obj -> g.apply((AutomatedDiscoveryAccount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedDiscoveryAccount> {
        /**
         * <p>
         * The Amazon Web Services account ID for the account.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The current status of automated sensitive data discovery for the account. Possible values are: ENABLED,
         * perform automated sensitive data discovery activities for the account; and, DISABLED, don't perform automated
         * sensitive data discovery activities for the account.
         * </p>
         * 
         * @param status
         *        The current status of automated sensitive data discovery for the account. Possible values are:
         *        ENABLED, perform automated sensitive data discovery activities for the account; and, DISABLED, don't
         *        perform automated sensitive data discovery activities for the account.
         * @see AutomatedDiscoveryAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryAccountStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of automated sensitive data discovery for the account. Possible values are: ENABLED,
         * perform automated sensitive data discovery activities for the account; and, DISABLED, don't perform automated
         * sensitive data discovery activities for the account.
         * </p>
         * 
         * @param status
         *        The current status of automated sensitive data discovery for the account. Possible values are:
         *        ENABLED, perform automated sensitive data discovery activities for the account; and, DISABLED, don't
         *        perform automated sensitive data discovery activities for the account.
         * @see AutomatedDiscoveryAccountStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedDiscoveryAccountStatus
         */
        Builder status(AutomatedDiscoveryAccountStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedDiscoveryAccount model) {
            accountId(model.accountId);
            status(model.status);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedDiscoveryAccountStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AutomatedDiscoveryAccount build() {
            return new AutomatedDiscoveryAccount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
