/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the criteria for an allow list. The criteria must specify a regular expression (regex) or an S3 object
 * (s3WordsList). It can't specify both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllowListCriteria implements SdkPojo, Serializable,
        ToCopyableBuilder<AllowListCriteria.Builder, AllowListCriteria> {
    private static final SdkField<String> REGEX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("regex")
            .getter(getter(AllowListCriteria::regex)).setter(setter(Builder::regex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regex").build()).build();

    private static final SdkField<S3WordsList> S3_WORDS_LIST_FIELD = SdkField.<S3WordsList> builder(MarshallingType.SDK_POJO)
            .memberName("s3WordsList").getter(getter(AllowListCriteria::s3WordsList)).setter(setter(Builder::s3WordsList))
            .constructor(S3WordsList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3WordsList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGEX_FIELD,
            S3_WORDS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String regex;

    private final S3WordsList s3WordsList;

    private AllowListCriteria(BuilderImpl builder) {
        this.regex = builder.regex;
        this.s3WordsList = builder.s3WordsList;
    }

    /**
     * <p>
     * The regular expression (<i>regex</i>) that defines the text pattern to ignore. The expression can contain as many
     * as 512 characters.
     * </p>
     * 
     * @return The regular expression (<i>regex</i>) that defines the text pattern to ignore. The expression can contain
     *         as many as 512 characters.
     */
    public final String regex() {
        return regex;
    }

    /**
     * <p>
     * The location and name of the S3 object that lists specific text to ignore.
     * </p>
     * 
     * @return The location and name of the S3 object that lists specific text to ignore.
     */
    public final S3WordsList s3WordsList() {
        return s3WordsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(regex());
        hashCode = 31 * hashCode + Objects.hashCode(s3WordsList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowListCriteria)) {
            return false;
        }
        AllowListCriteria other = (AllowListCriteria) obj;
        return Objects.equals(regex(), other.regex()) && Objects.equals(s3WordsList(), other.s3WordsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AllowListCriteria").add("Regex", regex()).add("S3WordsList", s3WordsList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "regex":
            return Optional.ofNullable(clazz.cast(regex()));
        case "s3WordsList":
            return Optional.ofNullable(clazz.cast(s3WordsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("regex", REGEX_FIELD);
        map.put("s3WordsList", S3_WORDS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AllowListCriteria, T> g) {
        return obj -> g.apply((AllowListCriteria) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AllowListCriteria> {
        /**
         * <p>
         * The regular expression (<i>regex</i>) that defines the text pattern to ignore. The expression can contain as
         * many as 512 characters.
         * </p>
         * 
         * @param regex
         *        The regular expression (<i>regex</i>) that defines the text pattern to ignore. The expression can
         *        contain as many as 512 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regex(String regex);

        /**
         * <p>
         * The location and name of the S3 object that lists specific text to ignore.
         * </p>
         * 
         * @param s3WordsList
         *        The location and name of the S3 object that lists specific text to ignore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3WordsList(S3WordsList s3WordsList);

        /**
         * <p>
         * The location and name of the S3 object that lists specific text to ignore.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3WordsList.Builder} avoiding the need to
         * create one manually via {@link S3WordsList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3WordsList.Builder#build()} is called immediately and its result
         * is passed to {@link #s3WordsList(S3WordsList)}.
         * 
         * @param s3WordsList
         *        a consumer that will call methods on {@link S3WordsList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3WordsList(S3WordsList)
         */
        default Builder s3WordsList(Consumer<S3WordsList.Builder> s3WordsList) {
            return s3WordsList(S3WordsList.builder().applyMutation(s3WordsList).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String regex;

        private S3WordsList s3WordsList;

        private BuilderImpl() {
        }

        private BuilderImpl(AllowListCriteria model) {
            regex(model.regex);
            s3WordsList(model.s3WordsList);
        }

        public final String getRegex() {
            return regex;
        }

        public final void setRegex(String regex) {
            this.regex = regex;
        }

        @Override
        public final Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public final S3WordsList.Builder getS3WordsList() {
            return s3WordsList != null ? s3WordsList.toBuilder() : null;
        }

        public final void setS3WordsList(S3WordsList.BuilderImpl s3WordsList) {
            this.s3WordsList = s3WordsList != null ? s3WordsList.build() : null;
        }

        @Override
        public final Builder s3WordsList(S3WordsList s3WordsList) {
            this.s3WordsList = s3WordsList;
            return this;
        }

        @Override
        public AllowListCriteria build() {
            return new AllowListCriteria(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
